/*
 * Decompiled with CFR 0.152.
 */
package com.YTrollman.CableTiers.blocks;

import com.YTrollman.CableTiers.CableTier;
import com.YTrollman.CableTiers.ContentType;
import com.YTrollman.CableTiers.blockentity.TieredBlockEntity;
import com.YTrollman.CableTiers.node.TieredNetworkNode;
import com.refinedmods.refinedstorage.block.BlockDirection;
import com.refinedmods.refinedstorage.block.CableBlock;
import com.refinedmods.refinedstorage.block.shape.ShapeCache;
import com.refinedmods.refinedstorage.container.factory.BlockEntityMenuProvider;
import com.refinedmods.refinedstorage.render.ConstantsCable;
import com.refinedmods.refinedstorage.util.BlockUtils;
import com.refinedmods.refinedstorage.util.CollisionUtils;
import com.refinedmods.refinedstorage.util.NetworkUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;

public abstract class TieredCableBlock<T extends TieredBlockEntity<N>, N extends TieredNetworkNode<N>>
extends CableBlock {
    private final ContentType<? extends TieredCableBlock<T, N>, T, ?, N> contentType;
    private final CableTier tier;

    protected TieredCableBlock(ContentType<? extends TieredCableBlock<T, N>, T, ?, N> contentType, CableTier tier) {
        super(BlockUtils.DEFAULT_GLASS_PROPERTIES);
        this.contentType = contentType;
        this.tier = tier;
    }

    public ContentType<? extends TieredCableBlock<T, N>, T, ?, N> getContentType() {
        return this.contentType;
    }

    public CableTier getTier() {
        return this.tier;
    }

    public BlockDirection getDirection() {
        return BlockDirection.ANY;
    }

    protected abstract VoxelShape getHeadShape(BlockState var1);

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        return ConstantsCable.addCoverVoxelShapes((VoxelShape)ShapeCache.getOrCreate((BlockState)state, s -> {
            VoxelShape shape = TieredCableBlock.getCableShape((BlockState)s);
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)this.getHeadShape((BlockState)s));
            return shape;
        }), (BlockGetter)world, (BlockPos)pos);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return this.contentType.getBlockEntityType(this.tier).m_155264_(pos, state);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!level.f_46443_ && CollisionUtils.isInBounds((VoxelShape)this.getHeadShape(state), (BlockPos)pos, (Vec3)hit.m_82450_())) {
            return NetworkUtils.attemptModify((Level)level, (BlockPos)pos, (Player)player, () -> NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new BlockEntityMenuProvider((Component)Component.m_237115_((String)this.m_7705_()), (tile, windowId, inventory, p) -> this.contentType.createContainer(windowId, p, (TieredBlockEntity)((Object)((Object)tile))), pos), (BlockPos)pos));
        }
        return InteractionResult.SUCCESS;
    }
}

