/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import dan200.computercraft.api.client.TransformedModel;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.client.turtle.TurtleUpgradeModellers;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.turtle.blocks.TileTurtle;
import dan200.computercraft.shared.util.DirectionUtil;
import dan200.computercraft.shared.util.Holiday;
import dan200.computercraft.shared.util.HolidayUtil;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.data.ModelData;

public class TileEntityTurtleRenderer
implements BlockEntityRenderer<TileTurtle> {
    private static final ModelResourceLocation NORMAL_TURTLE_MODEL = new ModelResourceLocation("computercraft:turtle_normal", "inventory");
    private static final ModelResourceLocation ADVANCED_TURTLE_MODEL = new ModelResourceLocation("computercraft:turtle_advanced", "inventory");
    private static final ResourceLocation COLOUR_TURTLE_MODEL = new ResourceLocation("computercraft", "block/turtle_colour");
    private static final ResourceLocation ELF_OVERLAY_MODEL = new ResourceLocation("computercraft", "block/turtle_elf_overlay");
    private final RandomSource random = RandomSource.m_216335_((long)0L);
    private final BlockEntityRenderDispatcher renderer;

    public TileEntityTurtleRenderer(BlockEntityRendererProvider.Context context) {
        this.renderer = context.m_173581_();
    }

    public static ResourceLocation getTurtleModel(ComputerFamily family, boolean coloured) {
        switch (family) {
            default: {
                return coloured ? COLOUR_TURTLE_MODEL : NORMAL_TURTLE_MODEL;
            }
            case ADVANCED: 
        }
        return coloured ? COLOUR_TURTLE_MODEL : ADVANCED_TURTLE_MODEL;
    }

    public static ResourceLocation getTurtleOverlayModel(ResourceLocation overlay, boolean christmas) {
        if (overlay != null) {
            return overlay;
        }
        if (christmas) {
            return ELF_OVERLAY_MODEL;
        }
        return null;
    }

    public void render(@Nonnull TileTurtle turtle, float partialTicks, @Nonnull PoseStack transform, @Nonnull MultiBufferSource buffers, int lightmapCoord, int overlayLight) {
        int[] nArray;
        String label = turtle.createProxy().getLabel();
        HitResult hit = this.renderer.f_112250_;
        if (label != null && hit.m_6662_() == HitResult.Type.BLOCK && turtle.m_58899_().equals((Object)((BlockHitResult)hit).m_82425_())) {
            Minecraft mc = Minecraft.m_91087_();
            Font font = this.renderer.f_112253_;
            transform.m_85836_();
            transform.m_85837_(0.5, 1.2, 0.5);
            transform.m_85845_(mc.m_91290_().m_114470_());
            transform.m_85841_(-0.025f, -0.025f, 0.025f);
            Matrix4f matrix = transform.m_85850_().m_85861_();
            int opacity = (int)(mc.f_91066_.m_92141_(0.25f) * 255.0f) << 24;
            float width = (float)(-font.m_92895_(label)) / 2.0f;
            font.m_92811_(label, width, 0.0f, 0x20FFFFFF, false, matrix, buffers, true, opacity, lightmapCoord);
            font.m_92811_(label, width, 0.0f, -1, false, matrix, buffers, false, 0, lightmapCoord);
            transform.m_85849_();
        }
        transform.m_85836_();
        Vec3 offset = turtle.getRenderOffset(partialTicks);
        float yaw = turtle.getRenderYaw(partialTicks);
        transform.m_85837_(offset.f_82479_, offset.f_82480_, offset.f_82481_);
        transform.m_85837_(0.5, 0.5, 0.5);
        transform.m_85845_(Vector3f.f_122225_.m_122240_(180.0f - yaw));
        if (label != null && (label.equals("Dinnerbone") || label.equals("Grumm"))) {
            transform.m_85841_(1.0f, -1.0f, 1.0f);
        }
        transform.m_85837_(-0.5, -0.5, -0.5);
        int colour = turtle.getColour();
        ComputerFamily family = turtle.getFamily();
        ResourceLocation overlay = turtle.getOverlay();
        VertexConsumer buffer = buffers.m_6299_(Sheets.m_110792_());
        ResourceLocation resourceLocation = TileEntityTurtleRenderer.getTurtleModel(family, colour != -1);
        if (colour == -1) {
            nArray = null;
        } else {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = colour;
        }
        this.renderModel(transform, buffer, lightmapCoord, overlayLight, resourceLocation, nArray);
        ResourceLocation overlayModel = TileEntityTurtleRenderer.getTurtleOverlayModel(overlay, HolidayUtil.getCurrentHoliday() == Holiday.CHRISTMAS);
        if (overlayModel != null) {
            this.renderModel(transform, buffer, lightmapCoord, overlayLight, overlayModel, null);
        }
        this.renderUpgrade(transform, buffer, lightmapCoord, overlayLight, turtle, TurtleSide.LEFT, partialTicks);
        this.renderUpgrade(transform, buffer, lightmapCoord, overlayLight, turtle, TurtleSide.RIGHT, partialTicks);
        transform.m_85849_();
    }

    private void renderUpgrade(@Nonnull PoseStack transform, @Nonnull VertexConsumer renderer, int lightmapCoord, int overlayLight, TileTurtle turtle, TurtleSide side, float f) {
        ITurtleUpgrade upgrade = turtle.getUpgrade(side);
        if (upgrade == null) {
            return;
        }
        transform.m_85836_();
        float toolAngle = turtle.getToolRenderAngle(side, f);
        transform.m_85837_(0.0, 0.5, 0.5);
        transform.m_85845_(Vector3f.f_122222_.m_122240_(toolAngle));
        transform.m_85837_(0.0, -0.5, -0.5);
        TransformedModel model = TurtleUpgradeModellers.getModel(upgrade, turtle.getAccess(), side);
        model.getMatrix().push(transform);
        this.renderModel(transform, renderer, lightmapCoord, overlayLight, model.getModel(), null);
        transform.m_85849_();
        transform.m_85849_();
    }

    private void renderModel(@Nonnull PoseStack transform, @Nonnull VertexConsumer renderer, int lightmapCoord, int overlayLight, ResourceLocation modelLocation, int[] tints) {
        ModelManager modelManager = Minecraft.m_91087_().m_91291_().m_115103_().m_109393_();
        this.renderModel(transform, renderer, lightmapCoord, overlayLight, modelManager.getModel(modelLocation), tints);
    }

    private void renderModel(@Nonnull PoseStack transform, @Nonnull VertexConsumer renderer, int lightmapCoord, int overlayLight, BakedModel model, int[] tints) {
        this.random.m_188584_(0L);
        TileEntityTurtleRenderer.renderQuads(transform, renderer, lightmapCoord, overlayLight, model.getQuads(null, null, this.random, ModelData.EMPTY, null), tints);
        for (Direction facing : DirectionUtil.FACINGS) {
            TileEntityTurtleRenderer.renderQuads(transform, renderer, lightmapCoord, overlayLight, model.getQuads(null, facing, this.random, ModelData.EMPTY, null), tints);
        }
    }

    private static void renderQuads(@Nonnull PoseStack transform, @Nonnull VertexConsumer buffer, int lightmapCoord, int overlayLight, List<BakedQuad> quads, int[] tints) {
        PoseStack.Pose matrix = transform.m_85850_();
        for (BakedQuad bakedquad : quads) {
            int idx;
            int tint = -1;
            if (tints != null && bakedquad.m_111304_() && (idx = bakedquad.m_111305_()) >= 0 && idx < tints.length) {
                tint = tints[bakedquad.m_111305_()];
            }
            float r = (float)(tint >> 16 & 0xFF) / 255.0f;
            float g = (float)(tint >> 8 & 0xFF) / 255.0f;
            float b = (float)(tint & 0xFF) / 255.0f;
            buffer.m_85987_(matrix, bakedquad, r, g, b, lightmapCoord, overlayLight);
        }
    }
}

