/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.render;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import dan200.computercraft.client.render.TurtleSmartItemModel;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;

public final class TurtleModelLoader
implements IGeometryLoader<TurtleModel> {
    private static final ResourceLocation COLOUR_TURTLE_MODEL = new ResourceLocation("computercraft", "block/turtle_colour");
    public static final TurtleModelLoader INSTANCE = new TurtleModelLoader();

    private TurtleModelLoader() {
    }

    @Nonnull
    public TurtleModel read(@Nonnull JsonObject modelContents, @Nonnull JsonDeserializationContext deserializationContext) {
        ResourceLocation model = new ResourceLocation(GsonHelper.m_13906_((JsonObject)modelContents, (String)"model"));
        return new TurtleModel(model);
    }

    public static final class TurtleModel
    implements IUnbakedGeometry<TurtleModel> {
        private final ResourceLocation family;

        private TurtleModel(ResourceLocation family) {
            this.family = family;
        }

        public Collection<Material> getMaterials(IGeometryBakingContext context, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
            HashSet<Material> materials = new HashSet<Material>();
            materials.addAll(modelGetter.apply(this.family).m_5500_(modelGetter, missingTextureErrors));
            materials.addAll(modelGetter.apply(COLOUR_TURTLE_MODEL).m_5500_(modelGetter, missingTextureErrors));
            return materials;
        }

        public BakedModel bake(IGeometryBakingContext owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState transform, ItemOverrides overrides, ResourceLocation modelLocation) {
            return new TurtleSmartItemModel(bakery.bake(this.family, transform, spriteGetter), bakery.bake(COLOUR_TURTLE_MODEL, transform, spriteGetter));
        }
    }
}

