/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.modem.wireless;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.network.IPacketNetwork;
import dan200.computercraft.shared.peripheral.modem.ModemPeripheral;
import dan200.computercraft.shared.peripheral.modem.ModemState;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public abstract class WirelessModemPeripheral
extends ModemPeripheral {
    public static final String NORMAL_ADJECTIVE = "upgrade.computercraft.wireless_modem_normal.adjective";
    public static final String ADVANCED_ADJECTIVE = "upgrade.computercraft.wireless_modem_advanced.adjective";
    private final boolean advanced;

    public WirelessModemPeripheral(ModemState state, boolean advanced) {
        super(state);
        this.advanced = advanced;
    }

    @Override
    public boolean isInterdimensional() {
        return this.advanced;
    }

    @Override
    public double getRange() {
        if (this.advanced) {
            return 2.147483647E9;
        }
        Level world = this.getLevel();
        if (world != null) {
            Vec3 position = this.getPosition();
            double minRange = ComputerCraft.modemRange;
            double maxRange = ComputerCraft.modemHighAltitudeRange;
            if (world.m_46471_() && world.m_46470_()) {
                minRange = ComputerCraft.modemRangeDuringStorm;
                maxRange = ComputerCraft.modemHighAltitudeRangeDuringStorm;
            }
            if (position.f_82480_ > 96.0 && maxRange > minRange) {
                return minRange + (position.f_82480_ - 96.0) * ((maxRange - minRange) / ((double)(world.m_151558_() - 1) - 96.0));
            }
            return minRange;
        }
        return 0.0;
    }

    @Override
    protected IPacketNetwork getNetwork() {
        return ComputerCraftAPI.getWirelessNetwork();
    }
}

