/*
 * Decompiled with CFR 0.152.
 */
package com.smashingmods.chemlib.api.addons.datagen;

import com.smashingmods.chemlib.api.MatterState;
import com.smashingmods.chemlib.api.addons.registry.AddonRegistry;
import com.smashingmods.chemlib.common.items.ChemicalItem;
import com.smashingmods.chemlib.common.items.CompoundItem;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.data.DataGenerator;
import net.minecraft.world.item.BucketItem;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class ModItemModelGenerator
extends ItemModelProvider {
    private final AddonRegistry addonRegistry;

    public ModItemModelGenerator(DataGenerator generator, AddonRegistry pAddonRegistry, ExistingFileHelper existingFileHelper) {
        super(generator, pAddonRegistry.getModID(), ModItemModelGenerator.makeNewHelper(existingFileHelper));
        this.addonRegistry = pAddonRegistry;
    }

    private static ExistingFileHelper makeNewHelper(ExistingFileHelper pExistingFileHelper) {
        return pExistingFileHelper;
    }

    protected void registerModels() {
        this.generateCompoundModels();
        this.addonRegistry.getCompounds().forEach(this::registerCompound);
        this.addonRegistry.getCompoundItemsAsStream().forEach(this::registerCompoundDust);
        this.addonRegistry.getBucketsAsStream().forEach(this::registerBucket);
    }

    private void generateCompoundModels() {
        for (String type : Arrays.asList("solid", "liquid", "gas", "dust")) {
            ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(String.format("item/compound_%s_model", type), this.mcLoc("item/generated"))).texture("layer0", String.format("chemlib:items/compound_%s_layer_0", type))).texture("layer1", String.format("chemlib:items/compound_%s_layer_1", type));
        }
        ((ItemModelBuilder)this.withExistingParent("item/chemical_dust_model", this.mcLoc("item/generated"))).texture("layer0", "chemlib:items/dust");
    }

    private void registerCompound(CompoundItem pCompound) {
        switch (pCompound.getMatterState()) {
            case SOLID: {
                this.withExistingParent(String.format("item/%s", pCompound.getChemicalName()), this.modLoc("item/compound_solid_model"));
                break;
            }
            case LIQUID: {
                this.withExistingParent(String.format("item/%s", pCompound.getChemicalName()), this.modLoc("item/compound_liquid_model"));
                break;
            }
            case GAS: {
                this.withExistingParent(String.format("item/%s", pCompound.getChemicalName()), this.modLoc("item/compound_gas_model"));
            }
        }
    }

    private void registerCompoundDust(ChemicalItem pItem) {
        this.withExistingParent(String.format("item/%s_dust", pItem.getChemicalName()), this.modLoc("item/compound_dust_model"));
    }

    private void registerBucket(BucketItem pBucket) {
        String path = Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)pBucket)).m_135815_();
        int pieces = path.split("_").length;
        String chemicalName = "";
        for (int i = 0; i < pieces - 1; ++i) {
            chemicalName = String.format("%s%s%s", chemicalName, chemicalName.isEmpty() ? "" : "_", path.split("_")[i]);
        }
        Optional<CompoundItem> optionalCompound = this.addonRegistry.getCompoundByName(chemicalName);
        if (optionalCompound.isEmpty()) {
            return;
        }
        MatterState matterState = Objects.requireNonNull(optionalCompound.get()).getMatterState();
        switch (matterState) {
            case LIQUID: {
                ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(String.format("item/%s", path), this.mcLoc("item/generated"))).texture("layer0", "chemlib:items/bucket_layer_0")).texture("layer1", "chemlib:items/bucket_layer_1");
                break;
            }
            case GAS: {
                ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(String.format("item/%s", path), this.mcLoc("item/generated"))).texture("layer0", "chemlib:items/gas_bucket_layer_0")).texture("layer1", "chemlib:items/gas_bucket_layer_1");
            }
        }
    }
}

