/*
 * Decompiled with CFR 0.152.
 */
package com.smashingmods.chemlib.client;

import com.google.common.base.Suppliers;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import com.smashingmods.chemlib.Config;
import com.smashingmods.chemlib.api.Chemical;
import com.smashingmods.chemlib.common.items.ChemicalItem;
import com.smashingmods.chemlib.common.items.ElementItem;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;

public class AbbreviationRenderer
extends BlockEntityWithoutLevelRenderer {
    public static final Supplier<BlockEntityWithoutLevelRenderer> INSTANCE = Suppliers.memoize(() -> new AbbreviationRenderer(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_()));
    public static final IClientItemExtensions RENDERER = new IClientItemExtensions(){

        public BlockEntityWithoutLevelRenderer getCustomRenderer() {
            return INSTANCE.get();
        }
    };

    public AbbreviationRenderer(BlockEntityRenderDispatcher pBlockEntityRenderDispatcher, EntityModelSet pEntityModelSet) {
        super(pBlockEntityRenderDispatcher, pEntityModelSet);
    }

    public void m_108829_(ItemStack pStack, ItemTransforms.TransformType pTransformType, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay) {
        boolean isGui = pTransformType == ItemTransforms.TransformType.GUI;
        boolean isFrame = pTransformType == ItemTransforms.TransformType.FIXED;
        ModelResourceLocation modelResourceLocation = null;
        MultiBufferSource buffer = pBuffer;
        Item item = pStack.m_41720_();
        if (item instanceof ElementItem) {
            ElementItem elementItem = (ElementItem)item;
            switch (elementItem.getMatterState()) {
                case LIQUID: {
                    modelResourceLocation = new ModelResourceLocation(new ResourceLocation("chemlib", "element_liquid_model"), "inventory");
                    break;
                }
                case GAS: {
                    modelResourceLocation = new ModelResourceLocation(new ResourceLocation("chemlib", "element_gas_model"), "inventory");
                    break;
                }
                default: {
                    modelResourceLocation = new ModelResourceLocation(new ResourceLocation("chemlib", "element_solid_model"), "inventory");
                    break;
                }
            }
        } else {
            item = pStack.m_41720_();
            if (item instanceof ChemicalItem) {
                ChemicalItem chemicalItem = (ChemicalItem)item;
                switch (chemicalItem.getItemType()) {
                    case DUST: {
                        modelResourceLocation = new ModelResourceLocation(new ResourceLocation("chemlib", "chemical_dust_model"), "inventory");
                        break;
                    }
                    case NUGGET: {
                        modelResourceLocation = new ModelResourceLocation(new ResourceLocation("chemlib", "chemical_nugget_model"), "inventory");
                        break;
                    }
                    case INGOT: {
                        modelResourceLocation = new ModelResourceLocation(new ResourceLocation("chemlib", "chemical_ingot_model"), "inventory");
                        break;
                    }
                    case PLATE: {
                        modelResourceLocation = new ModelResourceLocation(new ResourceLocation("chemlib", "chemical_plate_model"), "inventory");
                    }
                }
            }
        }
        if (modelResourceLocation != null) {
            BakedModel bakedModel = Minecraft.m_91087_().m_91291_().m_115103_().m_109393_().m_119422_(modelResourceLocation);
            pPoseStack.m_85836_();
            pPoseStack.m_85837_(0.5, 0.5, 0.0);
            if (isGui) {
                Lighting.m_84930_();
                buffer = Minecraft.m_91087_().m_91269_().m_110104_();
            }
            pPoseStack.m_85836_();
            switch (pTransformType) {
                case THIRD_PERSON_LEFT_HAND: 
                case THIRD_PERSON_RIGHT_HAND: {
                    pPoseStack.m_85837_(0.0, -0.2, 0.45);
                    break;
                }
                case FIRST_PERSON_LEFT_HAND: {
                    pPoseStack.m_85837_(-0.025, -0.025, 0.75);
                    pPoseStack.m_85845_(Vector3f.f_122227_.m_122240_(25.0f));
                    pPoseStack.m_85845_(Vector3f.f_122222_.m_122240_(45.0f));
                    pPoseStack.m_85845_(Vector3f.f_122224_.m_122240_(80.0f));
                    break;
                }
                case FIRST_PERSON_RIGHT_HAND: {
                    pPoseStack.m_85837_(-0.2, -0.05, 0.75);
                    pPoseStack.m_85845_(Vector3f.f_122226_.m_122240_(25.0f));
                    pPoseStack.m_85845_(Vector3f.f_122223_.m_122240_(45.0f));
                    pPoseStack.m_85845_(Vector3f.f_122225_.m_122240_(100.0f));
                    pPoseStack.m_85845_(Vector3f.f_122226_.m_122240_(45.0f));
                    break;
                }
                case HEAD: {
                    pPoseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
                    pPoseStack.m_85837_(0.0, -0.75, -0.75);
                    break;
                }
                case GROUND: {
                    pPoseStack.m_85837_(0.0, -0.25, 0.5);
                    pPoseStack.m_85841_(1.5f, 1.5f, 1.5f);
                    break;
                }
                case FIXED: {
                    pPoseStack.m_85845_(Vector3f.f_122224_.m_122240_(180.0f));
                    pPoseStack.m_85837_(0.0, 0.0, -0.5);
                }
            }
            Minecraft.m_91087_().m_91291_().m_115143_(pStack, pTransformType, false, pPoseStack, buffer, isGui ? 0xF000F0 : pPackedLight, isGui ? OverlayTexture.f_118083_ : pPackedOverlay, ForgeHooksClient.handleCameraTransforms((PoseStack)pPoseStack, (BakedModel)bakedModel, (ItemTransforms.TransformType)pTransformType, (boolean)false));
            if (isGui) {
                ((MultiBufferSource.BufferSource)buffer).m_109911_();
            }
            pPoseStack.m_85849_();
            if (isGui || isFrame) {
                pPoseStack.m_85836_();
                pPoseStack.m_85845_(Vector3f.f_122222_.m_122270_(180.0f));
                pPoseStack.m_85837_(-0.16, 0.0, -0.55);
                pPoseStack.m_85841_(0.05f, 0.08f, 0.08f);
                if (isFrame) {
                    pPoseStack.m_85845_(Vector3f.f_122224_.m_122240_(180.0f));
                    pPoseStack.m_85845_(Vector3f.f_122222_.m_122240_(53.0f));
                    pPoseStack.m_85837_(-8.0, -1.0, 1.7);
                    pPoseStack.m_85841_(1.0f, 0.65f, 1.0f);
                }
                Consumer<Chemical> renderAbbreviation = chemical -> Minecraft.m_91087_().f_91062_.m_92750_(pPoseStack, chemical.getAbbreviation(), -5.0f, 0.0f, 0xFFFFFF);
                Item item2 = pStack.m_41720_();
                if (item2 instanceof ElementItem) {
                    ElementItem elementItem = (ElementItem)item2;
                    if (((Boolean)Config.Common.renderElementAbbreviations.get()).booleanValue()) {
                        renderAbbreviation.accept(elementItem);
                    }
                } else {
                    item2 = pStack.m_41720_();
                    if (item2 instanceof ChemicalItem) {
                        ChemicalItem chemicalItem = (ChemicalItem)item2;
                        switch (chemicalItem.getItemType()) {
                            case DUST: {
                                if (!((Boolean)Config.Common.renderDustAbbreviations.get()).booleanValue()) break;
                                renderAbbreviation.accept(chemicalItem);
                                break;
                            }
                            case NUGGET: {
                                if (!((Boolean)Config.Common.renderNuggetAbbreviations.get()).booleanValue()) break;
                                renderAbbreviation.accept(chemicalItem);
                                break;
                            }
                            case INGOT: {
                                if (!((Boolean)Config.Common.renderIngotAbbreviations.get()).booleanValue()) break;
                                renderAbbreviation.accept(chemicalItem);
                                break;
                            }
                            case PLATE: {
                                if (!((Boolean)Config.Common.renderPlateAbbreviations.get()).booleanValue()) break;
                                renderAbbreviation.accept(chemicalItem);
                            }
                        }
                    }
                }
                if (isGui) {
                    Lighting.m_84931_();
                }
                pPoseStack.m_85849_();
            }
            pPoseStack.m_85849_();
        }
    }
}

