/*
 * Decompiled with CFR 0.152.
 */
package com.smashingmods.chemlib.datagen;

import com.smashingmods.chemlib.api.ChemicalBlockType;
import com.smashingmods.chemlib.common.blocks.ChemicalBlock;
import com.smashingmods.chemlib.registry.BlockRegistry;
import com.smashingmods.chemlib.registry.FluidRegistry;
import net.minecraft.data.DataGenerator;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;

public class BlockStateGenerator
extends BlockStateProvider {
    private final ExistingFileHelper existingFileHelper;

    public BlockStateGenerator(DataGenerator pGenerator, ExistingFileHelper pExistingFileHelper) {
        super(pGenerator, "chemlib", pExistingFileHelper);
        this.existingFileHelper = pExistingFileHelper;
    }

    protected void registerStatesAndModels() {
        this.generateBlockModel("metal", "metal_block");
        this.generateBlockModel("lamp_off", "lamp_block");
        this.generateBlockModel("lamp_on", "lamp_on");
        BlockRegistry.getChemicalBlocksByType(ChemicalBlockType.METAL).forEach(this::registerMetalBlock);
        BlockRegistry.getChemicalBlocksByType(ChemicalBlockType.LAMP).forEach(this::registerLampBlock);
        FluidRegistry.getLiquidBlocks().forEach(this::registerLiquidBlock);
    }

    private void generateBlockModel(String pName, String pTexture) {
        ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(String.format("block/%s_model", pName), this.mcLoc("block/block"))).texture("all", this.modLoc(String.format("block/%s", pTexture)))).texture("particle", "#all")).element().cube("#all").faces((direction, faceBuilder) -> faceBuilder.uvs(0.0f, 0.0f, 16.0f, 16.0f).tintindex(0).end()).end();
    }

    private void registerMetalBlock(ChemicalBlock pBlock) {
        String name = String.format("block/%s_metal_block", pBlock.getChemicalName());
        ((BlockModelBuilder)this.models().withExistingParent(name, this.modLoc("block/metal_model"))).texture("all", this.modLoc("block/metal_block"));
        ModelFile.ExistingModelFile modelFile = new ModelFile.ExistingModelFile(this.modLoc("block/metal_model"), this.existingFileHelper);
        this.getVariantBuilder(pBlock).forAllStates(arg_0 -> BlockStateGenerator.lambda$registerMetalBlock$1((ModelFile)modelFile, arg_0));
    }

    private void registerLampBlock(ChemicalBlock pBlock) {
        String off = String.format("block/%s_lamp_block", pBlock.getChemicalName());
        String on = String.format("block/%s_lamp_block_on", pBlock.getChemicalName());
        this.models().withExistingParent(off, this.modLoc("block/lamp_off_model"));
        this.models().withExistingParent(on, this.modLoc("block/lamp_on_model"));
        this.getVariantBuilder(pBlock).forAllStates(state -> {
            ModelFile.ExistingModelFile modelFile = new ModelFile.ExistingModelFile(this.modLoc(String.format("block/lamp_%s_model", (Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_) != false ? "on" : "off")), this.existingFileHelper);
            return ConfiguredModel.builder().modelFile((ModelFile)modelFile).build();
        });
    }

    private void registerLiquidBlock(LiquidBlock pBlock) {
        ModelFile.ExistingModelFile modelFile = new ModelFile.ExistingModelFile(this.mcLoc("block/water"), this.existingFileHelper);
        this.getVariantBuilder((Block)pBlock).forAllStates(arg_0 -> BlockStateGenerator.lambda$registerLiquidBlock$3((ModelFile)modelFile, arg_0));
    }

    private static /* synthetic */ ConfiguredModel[] lambda$registerLiquidBlock$3(ModelFile modelFile, BlockState state) {
        return ConfiguredModel.builder().modelFile(modelFile).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$registerMetalBlock$1(ModelFile modelFile, BlockState state) {
        return ConfiguredModel.builder().modelFile(modelFile).build();
    }
}

