/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.chipped.datagen.builder;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import earth.terrarium.chipped.common.recipe.ChippedRecipe;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChippedRecipeBuilder
implements RecipeBuilder {
    protected final Advancement.Builder advancement = Advancement.Builder.m_138353_();
    protected final RecipeSerializer<ChippedRecipe> serializer;
    protected final Item workbench;
    protected final List<String> tags;

    public ChippedRecipeBuilder(RecipeSerializer<ChippedRecipe> serializer, Item workbench, List<String> tags) {
        this.serializer = serializer;
        this.workbench = workbench;
        this.tags = tags;
    }

    @NotNull
    public ChippedRecipeBuilder unlockedBy(@NotNull String name, @NotNull CriterionTriggerInstance trigger) {
        this.advancement.m_138386_(name, trigger);
        return this;
    }

    @NotNull
    public ChippedRecipeBuilder group(@Nullable String group) {
        return this;
    }

    @NotNull
    public Item m_142372_() {
        return this.workbench;
    }

    public void m_126140_(@NotNull Consumer<FinishedRecipe> consumer, @NotNull ResourceLocation id) {
        if (this.advancement.m_138405_().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + id);
        }
        this.advancement.m_138396_(f_236353_).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)id)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)id)).m_138360_(RequirementsStrategy.f_15979_);
        consumer.accept(new Result(id, this.serializer, this.workbench, this.tags, this.advancement, new ResourceLocation(id.m_135827_(), "recipes/" + id.m_135815_())));
    }

    public record Result(ResourceLocation id, RecipeSerializer<ChippedRecipe> serializer, Item workbench, List<String> tags, Advancement.Builder advancement, ResourceLocation advancementId) implements FinishedRecipe
    {
        public void m_7917_(@NotNull JsonObject json) {
            JsonArray jsonElements = new JsonArray();
            this.tags.forEach(s -> jsonElements.add(new ResourceLocation("chipped", s).toString()));
            json.add("tags", (JsonElement)jsonElements);
        }

        @NotNull
        public ResourceLocation m_6445_() {
            return this.id;
        }

        @NotNull
        public RecipeSerializer<?> m_6637_() {
            return this.serializer;
        }

        @NotNull
        public JsonObject m_5860_() {
            return this.advancement.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

