/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.compat.theoneprobe.providers;

import com.mojang.authlib.GameProfile;
import dev.compactmods.machines.api.core.Tooltips;
import dev.compactmods.machines.api.tunnels.TunnelDefinition;
import dev.compactmods.machines.dimension.Dimension;
import dev.compactmods.machines.i18n.TranslationUtil;
import dev.compactmods.machines.machine.CompactMachineBlock;
import dev.compactmods.machines.machine.CompactMachineBlockEntity;
import dev.compactmods.machines.room.data.CompactRoomData;
import dev.compactmods.machines.tunnel.TunnelItem;
import dev.compactmods.machines.tunnel.graph.TunnelConnectionGraph;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.apiimpl.styles.ItemStyle;
import mcjty.theoneprobe.apiimpl.styles.LayoutStyle;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class CompactMachineProvider
implements IProbeInfoProvider {
    public ResourceLocation getID() {
        return new ResourceLocation("compactmachines", "machine");
    }

    public void addProbeInfo(ProbeMode probeMode, IProbeInfo info, Player player, Level level, BlockState blockState, IProbeHitData hitData) {
        Block block = blockState.m_60734_();
        if (!(block instanceof CompactMachineBlock)) {
            return;
        }
        CompactMachineBlock mach = (CompactMachineBlock)block;
        MinecraftServer server = level.m_7654_();
        if (server == null) {
            return;
        }
        ServerLevel compactDim = server.m_129880_(Dimension.COMPACT_DIMENSION);
        BlockEntity te = level.m_7702_(hitData.getPos());
        if (te instanceof CompactMachineBlockEntity) {
            CompactMachineBlockEntity machine = (CompactMachineBlockEntity)te;
            machine.getConnectedRoom().ifPresentOrElse(room -> {
                MutableComponent boundTo = TranslationUtil.tooltip(Tooltips.Machines.BOUND_TO, room);
                info.text((Component)boundTo);
            }, () -> {
                MutableComponent newMachine = TranslationUtil.message(new ResourceLocation("compactmachines", "new_machine")).m_130940_(ChatFormatting.GREEN);
                info.text((Component)newMachine);
            });
            machine.getOwnerUUID().ifPresent(ownerID -> {
                Player owner = level.m_46003_(ownerID);
                if (owner != null) {
                    GameProfile ownerProfile = owner.m_36316_();
                    MutableComponent ownerText = TranslationUtil.tooltip(Tooltips.Machines.OWNER, ownerProfile.getName()).m_130940_(ChatFormatting.GRAY);
                    info.text((Component)ownerText);
                }
            });
            machine.getConnectedRoom().ifPresent(room -> {
                if (compactDim == null) {
                    return;
                }
                CompactRoomData roomData = CompactRoomData.get(compactDim);
                TunnelConnectionGraph graph = TunnelConnectionGraph.forRoom(compactDim, room);
                Set<TunnelDefinition> applied = graph.getTypesForSide(machine.getLevelPosition(), hitData.getSideHit()).collect(Collectors.toSet());
                switch (probeMode) {
                    case NORMAL: {
                        IProbeInfo group = info.horizontal(new LayoutStyle().alignment(ElementAlignment.ALIGN_TOPLEFT).padding(0).spacing(0));
                        applied.forEach(tn -> {
                            ItemStack item = TunnelItem.createStack(tn);
                            group.item(item, new ItemStyle().bounds(8, 8));
                        });
                        break;
                    }
                    case EXTENDED: {
                        IProbeInfo tgg = info.vertical(new LayoutStyle().alignment(ElementAlignment.ALIGN_TOPLEFT));
                        applied.forEach(tn -> {
                            IProbeInfo tg = tgg.horizontal(new LayoutStyle().alignment(ElementAlignment.ALIGN_CENTER).hPadding(2).vPadding(2).spacing(0));
                            ItemStack item = TunnelItem.createStack(tn);
                            tg.item(item, new ItemStyle().bounds(8, 8));
                            tg.itemLabel(item);
                        });
                    }
                }
                Optional<CompactRoomData.RoomData> rd = roomData.forRoom((ChunkPos)room);
                rd.ifPresent(r -> {});
            });
        }
    }
}

