/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.machine.graph.legacy;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.compactmods.machines.CompactMachines;
import dev.compactmods.machines.dimension.Dimension;
import dev.compactmods.machines.dimension.MissingDimensionException;
import dev.compactmods.machines.location.LevelBlockPosition;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import org.apache.logging.log4j.Logger;

public class LegacyMachineLocationsGraph
extends SavedData {
    private static final String DATA_KEY = "compactmachines_machines";
    private final Map<Integer, LevelBlockPosition> machineMapping = new HashMap<Integer, LevelBlockPosition>();

    private LegacyMachineLocationsGraph() {
    }

    public static LegacyMachineLocationsGraph get(MinecraftServer server) throws MissingDimensionException {
        ServerLevel compactDim = server.m_129880_(Dimension.COMPACT_DIMENSION);
        if (compactDim == null) {
            throw new MissingDimensionException();
        }
        return (LegacyMachineLocationsGraph)compactDim.m_8895_().m_164858_(LegacyMachineLocationsGraph::load, DATA_KEY);
    }

    private static LegacyMachineLocationsGraph load(CompoundTag tag) {
        LegacyMachineLocationsGraph tmp = new LegacyMachineLocationsGraph();
        if (tag.m_128441_("locations")) {
            List locations = (List)MachineData.CODEC.listOf().fieldOf("locations").codec().parse((DynamicOps)NbtOps.f_128958_, (Object)tag).getOrThrow(false, arg_0 -> ((Logger)CompactMachines.LOGGER).error(arg_0));
            locations.forEach(md -> tmp.machineMapping.putIfAbsent(md.machine, md.location));
        }
        return tmp;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        return tag;
    }

    public LevelBlockPosition getLocation(int legacyMachineId) {
        if (!this.machineMapping.containsKey(legacyMachineId)) {
            return null;
        }
        return this.machineMapping.get(legacyMachineId);
    }

    private record MachineData(LevelBlockPosition location, int machine) {
        public static final Codec<MachineData> CODEC = RecordCodecBuilder.create(i -> i.group((App)LevelBlockPosition.CODEC.fieldOf("location").forGetter(MachineData::location), (App)Codec.INT.fieldOf("machine").forGetter(MachineData::machine)).apply((Applicative)i, MachineData::new));
    }
}

