/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.tunnel.definitions;

import com.google.common.collect.ImmutableSet;
import dev.compactmods.machines.api.tunnels.TunnelDefinition;
import dev.compactmods.machines.api.tunnels.TunnelPosition;
import dev.compactmods.machines.api.tunnels.capability.CapabilityTunnel;
import dev.compactmods.machines.api.tunnels.lifecycle.TunnelInstance;
import dev.compactmods.machines.api.tunnels.lifecycle.TunnelTeardownHandler;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.FastColor;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class ItemTunnel
implements TunnelDefinition,
CapabilityTunnel<Instance>,
TunnelTeardownHandler<Instance> {
    @Override
    public int ringColor() {
        return FastColor.ARGB32.m_13660_((int)255, (int)205, (int)143, (int)36);
    }

    @Override
    public Instance newInstance(BlockPos pos, Direction side) {
        return new Instance(10);
    }

    @Override
    public ImmutableSet<Capability<?>> getSupportedCapabilities() {
        return ImmutableSet.of((Object)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
    }

    @Override
    public <CapType> LazyOptional<CapType> getCapability(Capability<CapType> capType, Instance instance) {
        if (capType == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return instance.lazy();
        }
        return LazyOptional.empty();
    }

    @Override
    public void onRemoved(TunnelPosition position, Instance instance) {
        BlockPos dropAt = position.pos().m_5484_(position.side(), 1);
        NonNullList stacks = NonNullList.m_122779_();
        for (int i = 0; i < instance.handler.getSlots(); ++i) {
            ItemStack stack = instance.handler.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            stacks.add((Object)stack);
        }
        Containers.m_19010_((Level)position.level(), (BlockPos)dropAt, (NonNullList)stacks);
    }

    public static class Instance
    implements TunnelInstance,
    INBTSerializable<CompoundTag> {
        private final LazyOptional<IItemHandler> laze;
        final ItemStackHandler handler;

        public Instance(int buffer) {
            this.handler = new ItemStackHandler(buffer);
            this.laze = LazyOptional.of(this::getItems);
        }

        @Nonnull
        private IItemHandler getItems() {
            return this.handler;
        }

        public <CapType> LazyOptional<CapType> lazy() {
            return this.laze.cast();
        }

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128365_("items", (Tag)this.handler.serializeNBT());
            return tag;
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.handler.deserializeNBT(nbt.m_128469_("items"));
        }
    }
}

