/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.connectedglass;

import com.supermartijn642.connectedglass.CGGlassType;
import com.supermartijn642.connectedglass.ConnectedGlassClient;
import com.supermartijn642.connectedglass.data.CGBlockStateGenerator;
import com.supermartijn642.connectedglass.data.CGChiselingRecipeProvider;
import com.supermartijn642.connectedglass.data.CGLanguageGenerator;
import com.supermartijn642.connectedglass.data.CGLootTableGenerator;
import com.supermartijn642.connectedglass.data.CGModelGenerator;
import com.supermartijn642.connectedglass.data.CGRecipeGenerator;
import com.supermartijn642.connectedglass.data.CGTagGenerator;
import com.supermartijn642.core.item.CreativeItemGroup;
import com.supermartijn642.core.registry.GeneratorRegistrationHandler;
import com.supermartijn642.core.registry.RegistrationHandler;
import net.minecraft.data.DataGenerator;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;

@Mod(value="connectedglass")
public class ConnectedGlass {
    public static final CreativeItemGroup GROUP = CreativeItemGroup.create((String)"connectedglass", () -> CGGlassType.BORDERLESS_GLASS.getBlock().m_5456_());

    public ConnectedGlass() {
        ConnectedGlass.register();
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> ConnectedGlassClient::register);
        ConnectedGlass.registerGenerators();
    }

    private static void register() {
        RegistrationHandler handler = RegistrationHandler.get((String)"connectedglass");
        for (CGGlassType type : CGGlassType.values()) {
            handler.registerBlockCallback(type::registerBlocks);
            handler.registerItemCallback(type::registerItems);
        }
    }

    private static void registerGenerators() {
        GeneratorRegistrationHandler handler = GeneratorRegistrationHandler.get((String)"connectedglass");
        handler.addGenerator(CGModelGenerator::new);
        handler.addGenerator(CGBlockStateGenerator::new);
        handler.addProvider((generator, fileHelper) -> new CGChiselingRecipeProvider((DataGenerator)generator, (ExistingFileHelper)fileHelper));
        handler.addGenerator(CGLanguageGenerator::new);
        handler.addGenerator(CGLootTableGenerator::new);
        handler.addGenerator(CGRecipeGenerator::new);
        handler.addGenerator(CGTagGenerator::new);
    }
}

