/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.registry;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.cookingforblockheads.CookingForBlockheads;
import net.blay09.mods.cookingforblockheads.CookingForBlockheadsConfig;
import net.blay09.mods.cookingforblockheads.KitchenMultiBlock;
import net.blay09.mods.cookingforblockheads.api.ISortButton;
import net.blay09.mods.cookingforblockheads.api.IngredientPredicateWithCache;
import net.blay09.mods.cookingforblockheads.api.RecipeStatus;
import net.blay09.mods.cookingforblockheads.api.SinkHandler;
import net.blay09.mods.cookingforblockheads.api.SourceItem;
import net.blay09.mods.cookingforblockheads.api.ToasterHandler;
import net.blay09.mods.cookingforblockheads.api.capability.DefaultKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.capability.IKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.event.FoodRegistryInitEvent;
import net.blay09.mods.cookingforblockheads.menu.inventory.InventoryCraftBook;
import net.blay09.mods.cookingforblockheads.registry.FoodRecipeType;
import net.blay09.mods.cookingforblockheads.registry.IngredientPredicateWithCacheImpl;
import net.blay09.mods.cookingforblockheads.registry.recipe.FoodIngredient;
import net.blay09.mods.cookingforblockheads.registry.recipe.FoodRecipe;
import net.blay09.mods.cookingforblockheads.registry.recipe.GeneralFoodRecipe;
import net.blay09.mods.cookingforblockheads.registry.recipe.SmeltingFood;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class CookingRegistry {
    private static final List<Recipe<Container>> recipeList = Lists.newArrayList();
    private static final ArrayListMultimap<ResourceLocation, FoodRecipe> foodItems = ArrayListMultimap.create();
    private static final NonNullList<ItemStack> tools = NonNullList.m_122779_();
    private static final Map<ItemStack, Integer> ovenFuelItems = Maps.newHashMap();
    private static final Map<ItemStack, ItemStack> ovenRecipes = Maps.newHashMap();
    private static final Map<ItemStack, SinkHandler> sinkHandlers = Maps.newHashMap();
    private static final Map<ItemStack, ToasterHandler> toastHandlers = Maps.newHashMap();
    private static final NonNullList<ItemStack> waterItems = NonNullList.m_122779_();
    private static final NonNullList<ItemStack> milkItems = NonNullList.m_122779_();
    private static final List<ISortButton> customSortButtons = Lists.newArrayList();
    private static Collection<ItemStack> nonFoodRecipes = Collections.emptyList();
    private static final ToasterHandler dummyBreadToasterHandler = itemStack -> {
        boolean alreadyToasted;
        CompoundTag tag = itemStack.m_41783_();
        boolean bl = alreadyToasted = tag != null && tag.m_128471_("CookingForBlockheadsToasted");
        if (alreadyToasted) {
            if (CookingForBlockheadsConfig.getActive().allowVeryToastedBread) {
                ItemStack veryToasted = new ItemStack((ItemLike)Items.f_42414_);
                veryToasted.m_41714_((Component)Component.m_237115_((String)"tooltip.cookingforblockheads:very_toasted"));
                return veryToasted;
            }
            return itemStack;
        }
        ItemStack toasted = itemStack.m_41777_();
        toasted.m_41714_((Component)Component.m_237110_((String)"tooltip.cookingforblockheads:toasted", (Object[])new Object[]{itemStack.m_41786_()}));
        toasted.m_41784_().m_128379_("CookingForBlockheadsToasted", true);
        return toasted;
    };

    public static void initFoodRegistry(RecipeManager recipeManager) {
        recipeList.clear();
        foodItems.clear();
        FoodRegistryInitEvent init = new FoodRegistryInitEvent();
        Balm.getEvents().fireEvent((Object)init);
        nonFoodRecipes = init.getNonFoodRecipes();
        block0: for (Recipe recipe : recipeManager.m_44051_()) {
            if (!CookingRegistry.isValidRecipeType(recipe)) continue;
            ItemStack output = recipe.m_8043_();
            if (output == null) {
                CookingForBlockheads.logger.warn("Recipe " + recipe.m_6423_() + " returned a null ItemStack in getRecipeOutput - this is bad! The developer of " + recipe.m_6423_().m_135827_() + " should return an empty ItemStack instead to avoid problems.");
                continue;
            }
            if (output.m_41619_()) continue;
            if (output.m_41720_().m_41472_()) {
                if (CookingRegistry.isWeirdConversionRecipe(recipe)) continue;
                CookingRegistry.addFoodRecipe((Recipe<? extends Container>)recipe);
                continue;
            }
            for (ItemStack itemStack : nonFoodRecipes) {
                if (!recipe.m_8043_().m_41656_(itemStack)) continue;
                CookingRegistry.addFoodRecipe((Recipe<? extends Container>)recipe);
                continue block0;
            }
        }
    }

    private static boolean isValidRecipeType(Recipe<?> recipe) {
        return recipe.m_6671_() == RecipeType.f_44107_ || recipe.m_6671_() == RecipeType.f_44108_;
    }

    public static boolean isWeirdConversionRecipe(Recipe<?> recipe) {
        if (recipe.m_7527_().size() == 2 && recipe.m_8043_().m_41613_() == 2) {
            Ingredient first = (Ingredient)recipe.m_7527_().get(0);
            Ingredient second = (Ingredient)recipe.m_7527_().get(1);
            return first.test(recipe.m_8043_()) && second.test(recipe.m_8043_());
        }
        return false;
    }

    public static boolean isNonFoodRecipe(ItemStack itemStack) {
        if (itemStack.m_41619_()) {
            return false;
        }
        for (ItemStack nonFoodStack : nonFoodRecipes) {
            if (!itemStack.m_41656_(nonFoodStack)) continue;
            return true;
        }
        return false;
    }

    public static void addFoodRecipe(Recipe<? extends Container> recipe) {
        ItemStack output = recipe.m_8043_();
        if (!output.m_41619_() && !recipe.m_7527_().isEmpty()) {
            FoodRecipe foodRecipe;
            if (recipe instanceof AbstractCookingRecipe) {
                foodRecipe = new SmeltingFood(recipe);
            } else if (recipe instanceof CraftingRecipe) {
                foodRecipe = new GeneralFoodRecipe(recipe);
            } else {
                return;
            }
            recipeList.add(recipe);
            foodItems.put((Object)Balm.getRegistries().getKey(output.m_41720_()), (Object)foodRecipe);
        }
    }

    public static Multimap<ResourceLocation, FoodRecipe> getFoodRecipes() {
        return foodItems;
    }

    public static Collection<FoodRecipe> getFoodRecipes(ItemStack outputItem) {
        return foodItems.get((Object)Balm.getRegistries().getKey(outputItem.m_41720_()));
    }

    public static Collection<FoodRecipe> getFoodRecipes(ResourceLocation outputItem) {
        return foodItems.get((Object)outputItem);
    }

    public static void addToolItem(ItemStack toolItem) {
        tools.add((Object)toolItem);
    }

    public static boolean isToolItem(ItemStack itemStack) {
        if (itemStack.m_41619_()) {
            return false;
        }
        for (ItemStack toolItem : tools) {
            if (!toolItem.m_41726_(itemStack)) continue;
            return true;
        }
        return false;
    }

    public static boolean isToolItem(Ingredient ingredient) {
        for (ItemStack itemStack : ingredient.m_43908_()) {
            if (!CookingRegistry.isToolItem(itemStack)) continue;
            return true;
        }
        return false;
    }

    public static void addOvenFuel(ItemStack itemStack, int fuelTime) {
        ovenFuelItems.put(itemStack, fuelTime);
    }

    public static int getOvenFuelTime(ItemStack itemStack) {
        for (Map.Entry<ItemStack, Integer> entry : ovenFuelItems.entrySet()) {
            if (!entry.getKey().m_41656_(itemStack)) continue;
            return entry.getValue();
        }
        return 0;
    }

    public static void addSmeltingItem(ItemStack source, ItemStack result) {
        ovenRecipes.put(source, result);
    }

    public static ItemStack getSmeltingResult(ItemStack itemStack) {
        for (Map.Entry<ItemStack, ItemStack> entry : ovenRecipes.entrySet()) {
            if (!entry.getKey().m_41656_(itemStack)) continue;
            return entry.getValue();
        }
        return ItemStack.f_41583_;
    }

    public static void addToasterHandler(ItemStack itemStack, ToasterHandler toastHandler) {
        toastHandlers.put(itemStack, toastHandler);
    }

    @Nullable
    public static ToasterHandler getToasterHandler(ItemStack itemStack) {
        for (Map.Entry<ItemStack, ToasterHandler> entry : toastHandlers.entrySet()) {
            if (!entry.getKey().m_41656_(itemStack)) continue;
            return entry.getValue();
        }
        if (itemStack.m_41720_() == Items.f_42406_) {
            return dummyBreadToasterHandler;
        }
        return null;
    }

    public static void addSinkHandler(ItemStack itemStack, SinkHandler sinkHandler) {
        sinkHandlers.put(itemStack, sinkHandler);
    }

    public static ItemStack getSinkOutput(ItemStack itemStack) {
        if (itemStack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        for (Map.Entry<ItemStack, SinkHandler> entry : sinkHandlers.entrySet()) {
            if (!entry.getKey().m_41656_(itemStack)) continue;
            return entry.getValue().getSinkOutput(itemStack);
        }
        return ItemStack.f_41583_;
    }

    @Nullable
    private static SourceItem findAnyItemStack(ItemStack checkStack, List<IKitchenItemProvider> inventories, boolean requireBucket) {
        if (checkStack.m_41619_()) {
            return null;
        }
        IngredientPredicateWithCache predicate = IngredientPredicateWithCacheImpl.of((it, count) -> it.m_41726_(checkStack) && count > 0, checkStack);
        for (int i = 0; i < inventories.size(); ++i) {
            IKitchenItemProvider itemProvider = inventories.get(i);
            SourceItem found = itemProvider.findSource(predicate, 1, inventories, requireBucket, true);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public static List<SourceItem> findSourceCandidates(FoodIngredient ingredient, List<IKitchenItemProvider> inventories, boolean requireBucket, boolean isNoFilter) {
        SourceItem sourceItem;
        ItemStack[] variants;
        ArrayList<SourceItem> sourceList = new ArrayList<SourceItem>();
        for (ItemStack checkStack : variants = ingredient.getItemStacks()) {
            ItemStack foundStack;
            SourceItem sourceItem2 = CookingRegistry.findAnyItemStack(checkStack, inventories, requireBucket);
            ItemStack itemStack = foundStack = sourceItem2 != null ? sourceItem2.getSourceStack() : ItemStack.f_41583_;
            if (foundStack.m_41619_() && (isNoFilter || ingredient.isToolItem())) {
                sourceItem2 = new SourceItem(null, -1, checkStack);
            }
            if (sourceItem2 == null) continue;
            sourceList.add(sourceItem2);
        }
        SourceItem sourceItem3 = sourceItem = !sourceList.isEmpty() ? (SourceItem)sourceList.get(0) : null;
        if (sourceItem != null && sourceItem.getSourceProvider() != null) {
            sourceItem.getSourceProvider().markAsUsed(sourceItem, 1, inventories, requireBucket);
        }
        return sourceList;
    }

    public static boolean consumeBucket(List<IKitchenItemProvider> inventories, boolean simulate) {
        ItemStack bucketStack = new ItemStack((ItemLike)Items.f_42446_);
        IngredientPredicateWithCache predicate = IngredientPredicateWithCacheImpl.of((it, count) -> it.m_41656_(bucketStack) && count > 0, bucketStack);
        for (int i = 0; i < inventories.size(); ++i) {
            IKitchenItemProvider itemProvider = inventories.get(i);
            SourceItem sourceItem = itemProvider.findSourceAndMarkAsUsed(predicate, 1, inventories, false, simulate);
            if (sourceItem == null) continue;
            return true;
        }
        return false;
    }

    public static RecipeStatus getRecipeStatus(FoodRecipe recipe, List<IKitchenItemProvider> inventories, boolean hasOven) {
        boolean requireBucket = CookingRegistry.doesItemRequireBucketForCrafting(recipe.getOutputItem());
        for (IKitchenItemProvider itemProvider : inventories) {
            itemProvider.resetSimulation();
        }
        List<FoodIngredient> craftMatrix = recipe.getCraftMatrix();
        boolean missingTools = false;
        for (FoodIngredient ingredient : craftMatrix) {
            if (ingredient == null) continue;
            List<SourceItem> sourceList = CookingRegistry.findSourceCandidates(ingredient, inventories, requireBucket, false);
            if (sourceList.isEmpty()) {
                return RecipeStatus.MISSING_INGREDIENTS;
            }
            if (!sourceList.stream().allMatch(it -> it.getSourceProvider() == null)) continue;
            missingTools = true;
        }
        if (recipe.getType() == FoodRecipeType.SMELTING && !hasOven) {
            return RecipeStatus.MISSING_TOOLS;
        }
        return missingTools ? RecipeStatus.MISSING_TOOLS : RecipeStatus.AVAILABLE;
    }

    public static List<IKitchenItemProvider> getItemProviders(@Nullable KitchenMultiBlock multiBlock, Inventory inventory) {
        return multiBlock != null ? multiBlock.getItemProviders(inventory) : Lists.newArrayList((Object[])new IKitchenItemProvider[]{new DefaultKitchenItemProvider((Container)inventory)});
    }

    @Nullable
    public static <T extends Recipe<?>> T findFoodRecipe(InventoryCraftBook craftMatrix, Level level, RecipeType<T> recipeType, Item expectedItem) {
        for (Recipe<Container> recipe : recipeList) {
            if (recipe.m_6671_() != recipeType || !recipe.m_5818_((Container)craftMatrix, level) || recipe.m_8043_().m_41720_() != expectedItem) continue;
            return (T)recipe;
        }
        return null;
    }

    public static void addWaterItem(ItemStack waterItem) {
        waterItems.add((Object)waterItem);
    }

    public static void addMilkItem(ItemStack milkItem) {
        milkItems.add((Object)milkItem);
    }

    public static void addSortButton(ISortButton button) {
        customSortButtons.add(button);
    }

    public static NonNullList<ItemStack> getWaterItems() {
        return waterItems;
    }

    public static NonNullList<ItemStack> getMilkItems() {
        return milkItems;
    }

    public static List<ISortButton> getSortButtons() {
        return customSortButtons;
    }

    public static boolean doesItemRequireBucketForCrafting(ItemStack outputItem) {
        ItemStack containerItem = Balm.getHooks().getCraftingRemainingItem(outputItem);
        if (!containerItem.m_41619_() && containerItem.m_41720_() == Items.f_42446_) {
            return true;
        }
        ResourceLocation registryName = Balm.getRegistries().getKey(outputItem.m_41720_());
        return registryName != null && registryName.m_135815_().contains("bucket");
    }
}

