/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.woodcutter.compatibility;

import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.SingleItemRecipe;

public class CustomRecipeCategory<T extends SingleItemRecipe>
implements IRecipeCategory<T> {
    private static final ResourceLocation RECIPE_GUI_VANILLA = new ResourceLocation("jei", "textures/gui/gui_vanilla.png");
    private static final int WIDTH = 116;
    private static final int HEIGHT = 18;
    private final RecipeType<T> recipeType;
    private final Component translation;
    private final IDrawable icon;
    private final IDrawable background;

    CustomRecipeCategory(RecipeType<T> recipeType, Component translation, ItemStack icon, IGuiHelper guiHelper) {
        this.recipeType = recipeType;
        this.translation = translation;
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)icon);
        this.background = guiHelper.drawableBuilder(RECIPE_GUI_VANILLA, 49, 168, 116, 18).addPadding(0, 0, 40, 0).build();
    }

    public RecipeType<T> getRecipeType() {
        return this.recipeType;
    }

    public Component getTitle() {
        return this.translation;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder recipeLayoutBuilder, T recipe, IFocusGroup focuses) {
        recipeLayoutBuilder.addSlot(RecipeIngredientRole.INPUT, 41, 1).addIngredients((Ingredient)recipe.m_7527_().get(0));
        recipeLayoutBuilder.addSlot(RecipeIngredientRole.OUTPUT, 99, 1).addItemStack(recipe.m_8043_());
    }

    public boolean isHandled(T recipe) {
        return true;
    }
}

