/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.modules.radiation.network;

import java.util.function.Supplier;
import mcjty.deepresonance.modules.radiation.item.RadiationMonitorItem;
import mcjty.deepresonance.modules.radiation.network.PacketReturnRadiation;
import mcjty.deepresonance.setup.DeepResonanceMessages;
import mcjty.lib.varia.LevelTools;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class PacketGetRadiationLevel {
    private final GlobalPos coordinate;

    public PacketGetRadiationLevel(FriendlyByteBuf buf) {
        ResourceKey id = LevelTools.getId((ResourceLocation)buf.m_130281_());
        int x = buf.readInt();
        int y = buf.readInt();
        int z = buf.readInt();
        this.coordinate = GlobalPos.m_122643_((ResourceKey)id, (BlockPos)new BlockPos(x, y, z));
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130085_(this.coordinate.m_122640_().m_135782_());
        buf.writeInt(this.coordinate.m_122646_().m_123341_());
        buf.writeInt(this.coordinate.m_122646_().m_123342_());
        buf.writeInt(this.coordinate.m_122646_().m_123343_());
    }

    public PacketGetRadiationLevel(GlobalPos coordinate) {
        this.coordinate = coordinate;
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            ServerPlayer player = ctx.getSender();
            ServerLevel world = player.m_9236_();
            float strength = RadiationMonitorItem.calculateRadiationStrength((Level)world, this.coordinate);
            PacketReturnRadiation packet = new PacketReturnRadiation(strength);
            DeepResonanceMessages.INSTANCE.sendTo((Object)packet, player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        });
        ctx.setPacketHandled(true);
    }
}

