/*
 * Decompiled with CFR 0.152.
 */
package sirttas.dpanvil.api.data;

import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import sirttas.dpanvil.api.codec.CodecHelper;
import sirttas.dpanvil.api.data.AbstractManagedDataProvider;
import sirttas.dpanvil.api.data.IDataManager;

public abstract class AbstractManagedDataBuilderProvider<T, B>
extends AbstractManagedDataProvider<T> {
    private final Function<B, JsonElement> builder;
    private final Map<ResourceLocation, B> data;
    private static final RegistryOps<JsonElement> REGISTRY_OPS = RegistryOps.m_206821_((DynamicOps)JsonOps.INSTANCE, (RegistryAccess)RegistryAccess.m_206197_());

    protected AbstractManagedDataBuilderProvider(DataGenerator generator, IDataManager<T> manager, Encoder<B> encoder) {
        this(generator, manager, (B b) -> CodecHelper.encode(encoder, REGISTRY_OPS, b));
    }

    protected AbstractManagedDataBuilderProvider(DataGenerator generator, IDataManager<T> manager, Function<B, JsonElement> builder) {
        super(generator, manager);
        this.builder = builder;
        this.data = new HashMap<ResourceLocation, B>();
    }

    public void m_213708_(@Nonnull CachedOutput cache) throws IOException {
        this.collectBuilders();
        for (Map.Entry<ResourceLocation, B> entry : this.data.entrySet()) {
            this.save(cache, entry.getValue(), entry.getKey());
        }
        this.data.clear();
    }

    protected abstract void collectBuilders();

    protected B add(ResourceKey<T> key, B element) {
        return this.add(key.m_135782_(), element);
    }

    protected B add(ResourceLocation id, B element) {
        return (B)this.data.compute(id, (k, v) -> {
            if (v != null) {
                throw new IllegalStateException("Duplicate id: " + id + ", manager: " + this.manager);
            }
            return element;
        });
    }

    protected void save(CachedOutput cache, B element, ResourceKey<T> key) throws IOException {
        this.save(cache, element, key.m_135782_());
    }

    protected void save(CachedOutput cache, B element, ResourceLocation id) throws IOException {
        try {
            this.save(cache, (B)this.builder.apply(element), id);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error saving data: " + id + ", manager: " + this.manager, e);
        }
    }

    @Nonnull
    protected <U> Registry<U> getRegistry(ResourceKey<? extends Registry<U>> registry) {
        return (Registry)REGISTRY_OPS.m_206826_(registry).orElseThrow(() -> new IllegalStateException("Registry " + registry + " not found"));
    }

    public <U> HolderSet<U> createHolderSet(TagKey<U> tag) {
        return this.getRegistry(tag.f_203867_()).m_203561_(tag);
    }
}

