/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.instrument.io.purifier;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.block.entity.AbstractECCraftingBlockEntity;
import sirttas.elementalcraft.block.entity.ECBlockEntityTypes;
import sirttas.elementalcraft.block.instrument.io.AbstractIOInstrumentBlockEntity;
import sirttas.elementalcraft.block.instrument.io.purifier.PurifierContainer;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.recipe.instrument.io.IPurifierRecipe;

public class PurifierBlockEntity
extends AbstractIOInstrumentBlockEntity<PurifierBlockEntity, IPurifierRecipe> {
    private static final AbstractECCraftingBlockEntity.Config<PurifierBlockEntity, IPurifierRecipe> CONFIG = new AbstractECCraftingBlockEntity.Config((Supplier<BlockEntityType<?>>)ECBlockEntityTypes.PURIFIER, null, (Supplier<Integer>)ECConfig.COMMON.purifierTransferSpeed, (Supplier<Integer>)ECConfig.COMMON.purifierMaxRunes);
    private final PurifierContainer inventory = new PurifierContainer(this::m_6596_);

    public PurifierBlockEntity(BlockPos pos, BlockState state) {
        super(CONFIG, pos, state);
    }

    @Override
    @Nonnull
    @NotNull
    protected IItemHandler createHandler() {
        return new SidedInvWrapper((WorldlyContainer)this.inventory, null);
    }

    @Override
    protected IPurifierRecipe lookupRecipe() {
        IPurifierRecipe recipe;
        ItemStack input = this.inventory.m_8020_(0);
        if (!input.m_41619_() && (recipe = ElementalCraft.PURE_ORE_MANAGER.getRecipes(input)) != null && recipe.matches(this)) {
            return recipe;
        }
        return null;
    }

    @Override
    @Nonnull
    @NotNull
    public Container getInventory() {
        return this.inventory;
    }
}

