/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.data.predicate.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import sirttas.dpanvil.api.predicate.block.BlockPosPredicateType;
import sirttas.dpanvil.api.predicate.block.IBlockPosPredicate;
import sirttas.elementalcraft.data.predicate.block.ECBlockPosPredicateTypes;

public class RangeFromSpawnPredicate
implements IBlockPosPredicate {
    public static final String NAME = "range_from_spawn";
    public static final Codec<RangeFromSpawnPredicate> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.INT.fieldOf("range").forGetter(p -> p.range)).apply((Applicative)builder, RangeFromSpawnPredicate::new));
    private final int range;
    private final int rangeSq;

    public RangeFromSpawnPredicate(int range) {
        this.range = range;
        this.rangeSq = range * range;
    }

    public BlockPosPredicateType<RangeFromSpawnPredicate> getType() {
        return (BlockPosPredicateType)ECBlockPosPredicateTypes.RANGE_FROM_SPAWN.get();
    }

    public boolean test(@Nonnull LevelReader level, @Nonnull BlockPos pos, @Nullable Direction direction) {
        BlockPos blockPos;
        if (level instanceof ServerLevelAccessor) {
            ServerLevelAccessor accessor = (ServerLevelAccessor)level;
            blockPos = accessor.m_6018_().m_220360_();
        } else {
            blockPos = BlockPos.f_121853_;
        }
        BlockPos spawn = blockPos;
        return new BlockPos(spawn.m_123341_(), 0, spawn.m_123343_()).m_123331_((Vec3i)new BlockPos(pos.m_123341_(), 0, pos.m_123343_())) > (double)this.rangeSq;
    }
}

