/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.config.ECConfig;

@OnlyIn(value=Dist.CLIENT)
public class GuiHelper {
    private static final ResourceLocation GAUGE = ElementalCraft.createRL("textures/gui/element_gauge.png");

    private GuiHelper() {
    }

    public static void blit(PoseStack poseStack, int x, int y, int u, int v, int width, int height) {
        GuiComponent.m_93133_((PoseStack)poseStack, (int)x, (int)y, (float)u, (float)v, (int)width, (int)height, (int)256, (int)256);
    }

    private static int getElementTypeOffset(ElementType type) {
        return switch (type) {
            case ElementType.WATER -> 1;
            case ElementType.FIRE -> 2;
            case ElementType.EARTH -> 3;
            case ElementType.AIR -> 4;
            default -> 0;
        };
    }

    public static void renderElementGauge(PoseStack poseStack, int x, int y, int amount, int max, ElementType type) {
        GuiHelper.renderElementGauge(poseStack, x, y, amount, max, type, true);
    }

    public static void renderElementGauge(PoseStack poseStack, int x, int y, int amount, int max, ElementType type, boolean showDebugInfo) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)GAUGE);
        GuiHelper.blit(poseStack, x, y, 0, 0, 16, 16);
        int progress = Math.max(0, (int)((double)Math.min(amount, max) / (double)max * 16.0));
        if (progress <= 1 && amount > 0) {
            progress = 2;
        }
        GuiHelper.blit(poseStack, x, y + 16 - progress, GuiHelper.getElementTypeOffset(type) * 16, 16 - progress + (Boolean.TRUE.equals(ECConfig.CLIENT.usePaleElementGauge.get()) ? 16 : 0), 16, progress);
        if (GuiHelper.showDebugInfo() && showDebugInfo) {
            Minecraft.m_91087_().f_91062_.m_92750_(poseStack, amount + "/" + max, (float)x, (float)y + 16.0f, 0xFFFFFF);
        }
    }

    public static void renderCheck(PoseStack poseStack, Check check, int x, int y) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)GAUGE);
        GuiHelper.blit(poseStack, x, y, 0, 16 + check.offset, 6, 6);
    }

    public static boolean showDebugInfo() {
        Minecraft minecraft = Minecraft.m_91087_();
        return minecraft.f_91074_.m_7500_() && minecraft.f_91066_.f_92125_;
    }

    public static enum Check {
        VALID(0),
        PAUSED(6),
        INVALID(12);

        private final int offset;

        private Check(int offset) {
            this.offset = offset;
        }

        public int getOffset() {
            return this.offset;
        }
    }
}

