/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.item;

import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import sirttas.elementalcraft.property.ECProperties;

public class ECItem
extends Item {
    private boolean foil = false;

    public ECItem() {
        this(ECProperties.Items.DEFAULT_ITEM_PROPERTIES);
    }

    public ECItem(Item.Properties properties) {
        super(properties);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_5812_(@Nonnull ItemStack stack) {
        return this.foil || super.m_5812_(stack);
    }

    public ECItem setFoil(boolean foil) {
        this.foil = foil;
        return this;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void addAttributeMultiMapToTooltip(List<Component> tooltip, Multimap<Attribute, AttributeModifier> multiMap) {
        ECItem.addAttributeMultiMapToTooltip(tooltip, multiMap, null);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void addAttributeMultiMapToTooltip(List<Component> tooltip, Multimap<Attribute, AttributeModifier> multiMap, @Nullable Component title) {
        if (!multiMap.isEmpty()) {
            tooltip.add((Component)Component.m_237119_());
            if (title != null) {
                tooltip.add(title);
            }
            for (Map.Entry entry : multiMap.entries()) {
                tooltip.add((Component)ECItem.getAttributeTooltip((Attribute)entry.getKey(), (AttributeModifier)entry.getValue()));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static MutableComponent getAttributeTooltip(Attribute attribute, AttributeModifier attributemodifier) {
        double d0 = attributemodifier.m_22218_();
        double d1 = attributemodifier.m_22217_() != AttributeModifier.Operation.MULTIPLY_BASE && attributemodifier.m_22217_() != AttributeModifier.Operation.MULTIPLY_TOTAL ? (attribute.equals(Attributes.f_22278_) ? d0 * 10.0 : d0) : d0 * 100.0;
        if (d0 > 0.0) {
            return Component.m_237110_((String)("attribute.modifier.plus." + attributemodifier.m_22217_().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(d1), Component.m_237115_((String)attribute.m_22087_())}).m_130940_(ChatFormatting.BLUE);
        }
        if (d0 < 0.0) {
            return Component.m_237110_((String)("attribute.modifier.take." + attributemodifier.m_22217_().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(d1 *= -1.0), Component.m_237115_((String)attribute.m_22087_())}).m_130940_(ChatFormatting.RED);
        }
        return null;
    }
}

