/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.item;

import java.util.Map;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.registries.RegistryObject;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.block.ECBlocks;
import sirttas.elementalcraft.block.ITooltipImageBlock;
import sirttas.elementalcraft.block.container.AbstractElementContainerBlock;
import sirttas.elementalcraft.block.container.ElementContainerBlockItem;
import sirttas.elementalcraft.block.pipe.upgrade.PipeUpgrade;
import sirttas.elementalcraft.block.pipe.upgrade.type.PipeUpgradeType;
import sirttas.elementalcraft.block.pipe.upgrade.type.PipeUpgradeTypes;
import sirttas.elementalcraft.block.shrine.upgrade.translocation.TranslocationShrineUpgradeBlockItem;
import sirttas.elementalcraft.item.ECItem;
import sirttas.elementalcraft.item.TooltipImageBlockItem;
import sirttas.elementalcraft.item.chisel.ChiselItem;
import sirttas.elementalcraft.item.elemental.CrystalItem;
import sirttas.elementalcraft.item.elemental.ElementalItem;
import sirttas.elementalcraft.item.elemental.LensItem;
import sirttas.elementalcraft.item.elemental.ShardItem;
import sirttas.elementalcraft.item.holder.ElementHolderItem;
import sirttas.elementalcraft.item.holder.PureElementHolderItem;
import sirttas.elementalcraft.item.jewel.JewelItem;
import sirttas.elementalcraft.item.jewel.JewelModel;
import sirttas.elementalcraft.item.pipe.CoverFrameItem;
import sirttas.elementalcraft.item.pipe.PipeUpgradeItem;
import sirttas.elementalcraft.item.pureore.PureOreItem;
import sirttas.elementalcraft.item.rune.RuneItem;
import sirttas.elementalcraft.item.rune.RuneModel;
import sirttas.elementalcraft.item.source.SourceStabilizerItem;
import sirttas.elementalcraft.item.source.analysis.SourceAnalysisGlassItem;
import sirttas.elementalcraft.item.source.receptacle.ReceptacleHelper;
import sirttas.elementalcraft.item.source.receptacle.ReceptacleItem;
import sirttas.elementalcraft.item.spell.FocusItem;
import sirttas.elementalcraft.item.spell.ScrollItem;
import sirttas.elementalcraft.item.spell.SpellEffectItem;
import sirttas.elementalcraft.item.spell.StaffItem;
import sirttas.elementalcraft.item.spell.book.SpellBookItem;
import sirttas.elementalcraft.property.ECProperties;
import sirttas.elementalcraft.registry.RegistryHelper;
import sirttas.elementalcraft.spell.SpellHelper;

@Mod.EventBusSubscriber(modid="elementalcraft", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ECItems {
    private static final DeferredRegister<Item> DEFERRED_REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"elementalcraft");
    public static final RegistryObject<FocusItem> FOCUS = ECItems.register(FocusItem::new, "focus");
    public static final RegistryObject<StaffItem> STAFF = ECItems.register(StaffItem::new, "staff");
    public static final RegistryObject<ScrollItem> SCROLL = ECItems.register(ScrollItem::new, "scroll");
    public static final RegistryObject<SpellBookItem> SPELL_BOOK = ECItems.register(SpellBookItem::new, "spell_book");
    public static final RegistryObject<ReceptacleItem> RECEPTACLE = ECItems.register(ReceptacleItem::new, "receptacle");
    public static final RegistryObject<SourceStabilizerItem> SOURCE_STABILIZER = ECItems.register(SourceStabilizerItem::new, "source_stabilizer");
    public static final RegistryObject<SourceAnalysisGlassItem> SOURCE_ANALYSIS_GLASS = ECItems.register(SourceAnalysisGlassItem::new, "source_analysis_glass");
    public static final RegistryObject<ElementHolderItem> FIRE_HOLDER = ECItems.register(() -> new ElementHolderItem(ElementType.FIRE), "element_holder_fire");
    public static final RegistryObject<ElementHolderItem> WATER_HOLDER = ECItems.register(() -> new ElementHolderItem(ElementType.WATER), "element_holder_water");
    public static final RegistryObject<ElementHolderItem> EARTH_HOLDER = ECItems.register(() -> new ElementHolderItem(ElementType.EARTH), "element_holder_earth");
    public static final RegistryObject<ElementHolderItem> AIR_HOLDER = ECItems.register(() -> new ElementHolderItem(ElementType.AIR), "element_holder_air");
    public static final RegistryObject<ECItem> PURE_HOLDER_CORE = ECItems.register(ECItem::new, "pure_element_holder_core");
    public static final RegistryObject<PureElementHolderItem> PURE_HOLDER = ECItems.register(PureElementHolderItem::new, "pure_element_holder");
    public static final RegistryObject<PureOreItem> PURE_ORE = ECItems.register(PureOreItem::new, "pure_ore");
    public static final RegistryObject<RuneItem> RUNE = ECItems.register(RuneItem::new, "rune");
    public static final RegistryObject<ChiselItem> CHISEL = ECItems.register(ChiselItem::new, "chisel");
    public static final RegistryObject<CoverFrameItem> COVER_FRAME = ECItems.register(CoverFrameItem::new, "cover_frame");
    public static final RegistryObject<PipeUpgradeItem> ELEMENT_PUMP = ECItems.register(PipeUpgradeTypes.ELEMENT_PUMP);
    public static final RegistryObject<PipeUpgradeItem> PIPE_PRIORITY_RINGS = ECItems.register(PipeUpgradeTypes.PIPE_PRIORITY_RINGS);
    public static final RegistryObject<PipeUpgradeItem> ELEMENT_VALVE = ECItems.register(PipeUpgradeTypes.ELEMENT_VALVE);
    public static final RegistryObject<PipeUpgradeItem> ELEMENT_BEAM = ECItems.register(PipeUpgradeTypes.ELEMENT_BEAM);
    public static final RegistryObject<Item> ELEMENTOPEDIA = RegistryObject.create((ResourceLocation)new ResourceLocation("patchouli", "guide_book"), (IForgeRegistry)ForgeRegistries.ITEMS);
    public static final RegistryObject<ECItem> INERT_CRYSTAL = ECItems.register(ECItem::new, "inert_crystal");
    public static final RegistryObject<ECItem> CONTAINED_CRYSTAL = ECItems.register(ECItem::new, "contained_crystal");
    public static final RegistryObject<ECItem> STRONGLY_CONTAINED_CRYSTAL = ECItems.register(ECItem::new, "strongly_contained_crystal");
    public static final RegistryObject<ECItem> PURE_CRYSTAL = ECItems.register(() -> new ECItem().setFoil(true), "purecrystal");
    public static final RegistryObject<ECItem> DRENCHED_IRON_INGOT = ECItems.register(ECItem::new, "drenched_iron_ingot");
    public static final RegistryObject<ECItem> DRENCHED_IRON_NUGGET = ECItems.register(ECItem::new, "drenched_iron_nugget");
    public static final RegistryObject<ECItem> SWIFT_ALLOY_INGOT = ECItems.register(ECItem::new, "swift_alloy_ingot");
    public static final RegistryObject<ECItem> SWIFT_ALLOY_NUGGET = ECItems.register(ECItem::new, "swift_alloy_nugget");
    public static final RegistryObject<ECItem> HARDENED_HANDLE = ECItems.register(ECItem::new, "hardened_handle");
    public static final RegistryObject<ECItem> DRENCHED_SAW_BLADE = ECItems.register(ECItem::new, "drenched_saw_blade");
    public static final RegistryObject<ECItem> SHRINE_BASE = ECItems.register(ECItem::new, "shrinebase");
    public static final RegistryObject<ECItem> FIREITE_INGOT = ECItems.register(ECItem::new, "fireite_ingot");
    public static final RegistryObject<ECItem> FIREITE_NUGGET = ECItems.register(ECItem::new, "fireite_nugget");
    public static final RegistryObject<ECItem> AIR_SILK = ECItems.register(ECItem::new, "air_silk");
    public static final RegistryObject<ECItem> SHRINE_UPGRADE_CORE = ECItems.register(ECItem::new, "shrine_upgrade_core");
    public static final RegistryObject<ECItem> SCROLL_PAPER = ECItems.register(ECItem::new, "scroll_paper");
    public static final RegistryObject<ECItem> SPRINGALINE_SHARD = ECItems.register(ECItem::new, "springaline_shard");
    public static final RegistryObject<ECItem> SOLAR_PRISM = ECItems.register(ECItem::new, "solar_prism");
    public static final RegistryObject<CrystalItem> FIRE_CRYSTAL = ECItems.register(() -> new CrystalItem(ElementType.FIRE), "firecrystal");
    public static final RegistryObject<CrystalItem> WATER_CRYSTAL = ECItems.register(() -> new CrystalItem(ElementType.WATER), "watercrystal");
    public static final RegistryObject<CrystalItem> EARTH_CRYSTAL = ECItems.register(() -> new CrystalItem(ElementType.EARTH), "earthcrystal");
    public static final RegistryObject<CrystalItem> AIR_CRYSTAL = ECItems.register(() -> new CrystalItem(ElementType.AIR), "aircrystal");
    public static final RegistryObject<ShardItem> FIRE_SHARD = ECItems.register(() -> new ShardItem(ElementType.FIRE), "fire_shard");
    public static final RegistryObject<ShardItem> WATER_SHARD = ECItems.register(() -> new ShardItem(ElementType.WATER), "water_shard");
    public static final RegistryObject<ShardItem> EARTH_SHARD = ECItems.register(() -> new ShardItem(ElementType.EARTH), "earth_shard");
    public static final RegistryObject<ShardItem> AIR_SHARD = ECItems.register(() -> new ShardItem(ElementType.AIR), "air_shard");
    public static final RegistryObject<ShardItem> POWERFUL_FIRE_SHARD = ECItems.register(() -> new ShardItem(ElementType.FIRE, 9), "powerful_fire_shard");
    public static final RegistryObject<ShardItem> POWERFUL_WATER_SHARD = ECItems.register(() -> new ShardItem(ElementType.WATER, 9), "powerful_water_shard");
    public static final RegistryObject<ShardItem> POWERFUL_EARTH_SHARD = ECItems.register(() -> new ShardItem(ElementType.EARTH, 9), "powerful_earth_shard");
    public static final RegistryObject<ShardItem> POWERFUL_AIR_SHARD = ECItems.register(() -> new ShardItem(ElementType.AIR, 9), "powerful_air_shard");
    public static final RegistryObject<ElementalItem> CRUDE_FIRE_GEM = ECItems.register(() -> new ElementalItem(ElementType.FIRE), "crude_fire_gem");
    public static final RegistryObject<ElementalItem> CRUDE_WATER_GEM = ECItems.register(() -> new ElementalItem(ElementType.WATER), "crude_water_gem");
    public static final RegistryObject<ElementalItem> CRUDE_EARTH_GEM = ECItems.register(() -> new ElementalItem(ElementType.EARTH), "crude_earth_gem");
    public static final RegistryObject<ElementalItem> CRUDE_AIR_GEM = ECItems.register(() -> new ElementalItem(ElementType.AIR), "crude_air_gem");
    public static final RegistryObject<ElementalItem> FINE_FIRE_GEM = ECItems.register(() -> new ElementalItem(ElementType.FIRE), "fine_fire_gem");
    public static final RegistryObject<ElementalItem> FINE_WATER_GEM = ECItems.register(() -> new ElementalItem(ElementType.WATER), "fine_water_gem");
    public static final RegistryObject<ElementalItem> FINE_EARTH_GEM = ECItems.register(() -> new ElementalItem(ElementType.EARTH), "fine_earth_gem");
    public static final RegistryObject<ElementalItem> FINE_AIR_GEM = ECItems.register(() -> new ElementalItem(ElementType.AIR), "fine_air_gem");
    public static final RegistryObject<ElementalItem> PRISTINE_FIRE_GEM = ECItems.register(() -> new ElementalItem(ElementType.FIRE), "pristine_fire_gem");
    public static final RegistryObject<ElementalItem> PRISTINE_WATER_GEM = ECItems.register(() -> new ElementalItem(ElementType.WATER), "pristine_water_gem");
    public static final RegistryObject<ElementalItem> PRISTINE_EARTH_GEM = ECItems.register(() -> new ElementalItem(ElementType.EARTH), "pristine_earth_gem");
    public static final RegistryObject<ElementalItem> PRISTINE_AIR_GEM = ECItems.register(() -> new ElementalItem(ElementType.AIR), "pristine_air_gem");
    public static final RegistryObject<LensItem> FIRE_LENS = ECItems.register(() -> new LensItem(ElementType.FIRE), "fire_lens");
    public static final RegistryObject<LensItem> WATER_LENS = ECItems.register(() -> new LensItem(ElementType.WATER), "water_lens");
    public static final RegistryObject<LensItem> EARTH_LENS = ECItems.register(() -> new LensItem(ElementType.EARTH), "earth_lens");
    public static final RegistryObject<LensItem> AIR_LENS = ECItems.register(() -> new LensItem(ElementType.AIR), "air_lens");
    public static final RegistryObject<ECItem> MINOR_RUNE_SLATE = ECItems.register(ECItem::new, "minor_rune_slate");
    public static final RegistryObject<ECItem> RUNE_SLATE = ECItems.register(ECItem::new, "rune_slate");
    public static final RegistryObject<ECItem> MAJOR_RUNE_SLATE = ECItems.register(ECItem::new, "major_rune_slate");
    public static final RegistryObject<ECItem> UNSET_JEWEL = ECItems.register(ECItem::new, "unset_jewel");
    public static final RegistryObject<JewelItem> JEWEL = ECItems.register(JewelItem::new, "jewel");
    public static final RegistryObject<ElementalItem> ARTIFICIAL_FIRE_SOURCE_SEED = ECItems.register(() -> new ElementalItem(ElementType.FIRE), "artificial_fire_source_seed");
    public static final RegistryObject<ElementalItem> ARTIFICIAL_WATER_SOURCE_SEED = ECItems.register(() -> new ElementalItem(ElementType.WATER), "artificial_water_source_seed");
    public static final RegistryObject<ElementalItem> ARTIFICIAL_EARTH_SOURCE_SEED = ECItems.register(() -> new ElementalItem(ElementType.EARTH), "artificial_earth_source_seed");
    public static final RegistryObject<ElementalItem> ARTIFICIAL_AIR_SOURCE_SEED = ECItems.register(() -> new ElementalItem(ElementType.AIR), "artificial_air_source_seed");
    public static final RegistryObject<ElementalItem> NATURAL_FIRE_SOURCE_SEED = ECItems.register(() -> new ElementalItem(ElementType.FIRE), "natural_fire_source_seed");
    public static final RegistryObject<ElementalItem> NATURAL_WATER_SOURCE_SEED = ECItems.register(() -> new ElementalItem(ElementType.WATER), "natural_water_source_seed");
    public static final RegistryObject<ElementalItem> NATURAL_EARTH_SOURCE_SEED = ECItems.register(() -> new ElementalItem(ElementType.EARTH), "natural_earth_source_seed");
    public static final RegistryObject<ElementalItem> NATURAL_AIR_SOURCE_SEED = ECItems.register(() -> new ElementalItem(ElementType.AIR), "natural_air_source_seed");
    public static final RegistryObject<SpellEffectItem> REPAIR_HAMMER = ECItems.register(SpellEffectItem::new, "repair_hammer");

    private ECItems() {
    }

    @SubscribeEvent
    public static void registerBlockItems(RegisterEvent event) {
        if (!event.getRegistryKey().equals((Object)Registry.f_122904_)) {
            return;
        }
        IForgeRegistry registry = event.getForgeRegistry();
        if (registry == null) {
            return;
        }
        RegistryHelper.register(registry, new BlockItem((Block)ECBlocks.FIREITE_BLOCK.get(), ECProperties.Items.FIREITE), ECBlocks.FIREITE_BLOCK);
        RegistryHelper.register(registry, new TranslocationShrineUpgradeBlockItem((Block)ECBlocks.TRANSLOCATION_SHRINE_UPGRADE.get(), ECProperties.Items.DEFAULT_ITEM_PROPERTIES), ECBlocks.TRANSLOCATION_SHRINE_UPGRADE);
        for (Block block : ForgeRegistries.BLOCKS) {
            TooltipImageBlockItem blockItem;
            ResourceLocation registryName = ForgeRegistries.BLOCKS.getKey((Object)block);
            if (registryName == null || !ElementalCraft.owns(registryName) || registry.containsKey(registryName)) continue;
            if (block instanceof AbstractElementContainerBlock) {
                AbstractElementContainerBlock containerBlock = (AbstractElementContainerBlock)block;
                blockItem = new ElementContainerBlockItem(containerBlock, ECProperties.Items.DEFAULT_ITEM_PROPERTIES);
            } else {
                blockItem = block instanceof ITooltipImageBlock ? new TooltipImageBlockItem(block, ECProperties.Items.DEFAULT_ITEM_PROPERTIES) : new BlockItem(block, ECProperties.Items.DEFAULT_ITEM_PROPERTIES);
            }
            RegistryHelper.register(registry, blockItem, registryName);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void replaceModels(ModelEvent.BakingCompleted event) {
        Map modelRegistry = event.getModels();
        ECItems.replaceModels(modelRegistry, "rune", RuneModel::new);
        ECItems.replaceModels(modelRegistry, "jewel", JewelModel::new);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void replaceModels(Map<ResourceLocation, BakedModel> modelRegistry, String name, UnaryOperator<BakedModel> modelFactory) {
        modelRegistry.computeIfPresent((ResourceLocation)new ModelResourceLocation(ElementalCraft.createRL(name), "inventory"), (k, v) -> (BakedModel)modelFactory.apply((BakedModel)v));
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void registerItemColors(RegisterColorHandlersEvent.Item event) {
        event.register((s, l) -> l == 0 ? -1 : ReceptacleHelper.getElementType(s).getColor(), new ItemLike[]{(ItemLike)RECEPTACLE.get()});
        event.register((s, l) -> {
            int[] colors = ElementalCraft.PURE_ORE_MANAGER.getColors(s);
            return colors != null && l < colors.length ? colors[l] : -1;
        }, new ItemLike[]{(ItemLike)PURE_ORE.get()});
        event.register((s, l) -> l == 0 ? -1 : SpellHelper.getSpell(s).getColor(), new ItemLike[]{(ItemLike)SCROLL.get()});
        event.register((s, l) -> l == 0 ? -1 : ((ElementHolderItem)s.m_41720_()).getElementType().getColor(), new ItemLike[]{(ItemLike)FIRE_HOLDER.get(), (ItemLike)WATER_HOLDER.get(), (ItemLike)EARTH_HOLDER.get(), (ItemLike)AIR_HOLDER.get()});
    }

    private static <T extends PipeUpgrade> RegistryObject<PipeUpgradeItem> register(RegistryObject<PipeUpgradeType<T>> pipeUpgrade) {
        return ECItems.register(() -> new PipeUpgradeItem(() -> ((RegistryObject)pipeUpgrade).get(), ECProperties.Items.DEFAULT_ITEM_PROPERTIES), pipeUpgrade.getId().m_135815_());
    }

    private static <T extends Item> RegistryObject<T> register(Supplier<T> item, String name) {
        return DEFERRED_REGISTER.register(name, item);
    }

    public static void register(IEventBus bus) {
        DEFERRED_REGISTER.register(bus);
    }
}

