/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.recipe.instrument;

import com.google.gson.JsonObject;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.block.instrument.inscriber.InscriberBlockEntity;
import sirttas.elementalcraft.recipe.ECRecipeSerializers;
import sirttas.elementalcraft.recipe.ECRecipeTypes;
import sirttas.elementalcraft.recipe.RecipeHelper;
import sirttas.elementalcraft.recipe.instrument.AbstractInstrumentRecipe;

public class InscriptionRecipe
extends AbstractInstrumentRecipe<InscriberBlockEntity> {
    public static final String NAME = "inscription";
    private final NonNullList<Ingredient> ingredients;
    private final int elementAmount;
    private final ItemStack output;

    public InscriptionRecipe(ResourceLocation id, ElementType type, int elementAmount, ItemStack output, List<Ingredient> ingredients) {
        super(id, type);
        this.ingredients = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])((Ingredient[])ingredients.toArray(Ingredient[]::new)));
        this.elementAmount = elementAmount;
        this.output = output;
    }

    @Override
    public int getElementAmount() {
        return this.elementAmount;
    }

    @Override
    public boolean matches(InscriberBlockEntity inscriber) {
        if (inscriber.getContainerElementType() == this.getElementType()) {
            return RecipeHelper.matchesUnordered(inscriber.getInventory(), this.ingredients);
        }
        return false;
    }

    @Nonnull
    public NonNullList<Ingredient> m_7527_() {
        return this.ingredients;
    }

    @Nonnull
    public ItemStack m_8043_() {
        return this.output;
    }

    @Nonnull
    public RecipeType<?> m_6671_() {
        return (RecipeType)ECRecipeTypes.INSCRIPTION.get();
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ECRecipeSerializers.INSCRIPTION.get();
    }

    public static class Serializer
    implements RecipeSerializer<InscriptionRecipe> {
        @Nonnull
        public InscriptionRecipe fromJson(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
            ElementType type = ElementType.byName(GsonHelper.m_13906_((JsonObject)json, (String)"element_type"));
            int elementAmount = GsonHelper.m_13927_((JsonObject)json, (String)"element_amount");
            NonNullList<Ingredient> ingredients = RecipeHelper.readIngredients(GsonHelper.m_13933_((JsonObject)json, (String)"ingredients"));
            ingredients.add(0, (Object)RecipeHelper.deserializeIngredient(json, "slate"));
            ItemStack output = RecipeHelper.readRecipeOutput(json, "output");
            return new InscriptionRecipe(recipeId, type, elementAmount, output, (List<Ingredient>)ingredients);
        }

        public InscriptionRecipe fromNetwork(@Nonnull ResourceLocation recipeId, FriendlyByteBuf buffer) {
            ElementType type = ElementType.byName(buffer.m_130277_());
            int elementAmount = buffer.readInt();
            ItemStack output = buffer.m_130267_();
            int i = buffer.readInt();
            NonNullList ingredients = NonNullList.m_122780_((int)i, (Object)Ingredient.f_43901_);
            for (int j = 0; j < i; ++j) {
                ingredients.set(j, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            return new InscriptionRecipe(recipeId, type, elementAmount, output, (List<Ingredient>)ingredients);
        }

        public void toNetwork(FriendlyByteBuf buffer, InscriptionRecipe recipe) {
            buffer.m_130070_(recipe.getElementType().m_7912_());
            buffer.writeInt(recipe.getElementAmount());
            buffer.m_130055_(recipe.m_8043_());
            buffer.writeInt(recipe.m_7527_().size());
            recipe.m_7527_().forEach(ingredient -> ingredient.m_43923_(buffer));
        }
    }
}

