/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.block;

import dev.ftb.mods.ftbic.FTBICConfig;
import dev.ftb.mods.ftbic.block.BaseCableBlock;
import dev.ftb.mods.ftbic.block.BurntCableBlock;
import dev.ftb.mods.ftbic.block.ElectricBlock;
import dev.ftb.mods.ftbic.block.entity.ElectricBlockEntity;
import dev.ftb.mods.ftbic.util.EnergyHandler;
import dev.ftb.mods.ftbic.util.EnergyTier;
import dev.ftb.mods.ftbic.util.FTBICUtils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.Nullable;

public class CableBlock
extends BaseCableBlock {
    public final EnergyTier tier;

    public CableBlock(EnergyTier _tier, int border, SoundType soundType) {
        super(border, soundType);
        this.tier = _tier;
    }

    @Override
    @Deprecated
    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        if (facingState.m_60734_() instanceof BurntCableBlock) {
            return state;
        }
        boolean c = this.canCableConnectFrom(facingState, (BlockGetter)level, facingPos, facing.m_122424_());
        if (!level.m_5776_() && facingState.m_60734_() != this && c != (Boolean)state.m_61143_((Property)CONNECTION[facing.ordinal()])) {
            ElectricBlockEntity.electricNetworkUpdated(level, facingPos);
        }
        return (BlockState)state.m_61124_((Property)CONNECTION[facing.ordinal()], (Comparable)Boolean.valueOf(c));
    }

    private boolean canCableConnectFrom(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        if (state.m_60734_() instanceof CableBlock) {
            return state.m_60734_() == this;
        }
        if (state.m_60734_() instanceof ElectricBlock) {
            return true;
        }
        if (!state.m_60795_()) {
            BlockEntity be = world.m_7702_(pos);
            if (be instanceof EnergyHandler) {
                return true;
            }
            if (be != null && (Double)FTBICConfig.ENERGY.ZAP_TO_FE_CONVERSION_RATE.get() > 0.0) {
                return be.getCapability(CapabilityEnergy.ENERGY, face).filter(IEnergyStorage::canReceive).isPresent();
            }
        }
        return false;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockState state = this.m_49966_();
        for (Direction direction : Direction.values()) {
            BlockPos p = pos.m_121945_(direction);
            BlockState s = world.m_8055_(p);
            if (!this.canCableConnectFrom(s, (BlockGetter)world, p, direction.m_122424_())) continue;
            state = (BlockState)state.m_61124_((Property)CONNECTION[direction.ordinal()], (Comparable)Boolean.valueOf(true));
        }
        return (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(world.m_6425_(pos).m_76152_() == Fluids.f_76193_));
    }

    @Deprecated
    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState state1, boolean b) {
        super.m_6807_(state, level, pos, state1, b);
        if (!level.m_5776_() && !state.m_60713_(state1.m_60734_())) {
            ElectricBlockEntity.electricNetworkUpdated((LevelAccessor)level, pos);
        }
    }

    @Deprecated
    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState state1, boolean b) {
        super.m_6810_(state, level, pos, state1, b);
        if (!level.m_5776_() && !state.m_60713_(state1.m_60734_())) {
            ElectricBlockEntity.electricNetworkUpdated((LevelAccessor)level, pos);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> list, TooltipFlag flag) {
        list.add((Component)Component.m_237110_((String)"ftbic.max_input", (Object[])new Object[]{FTBICUtils.formatEnergy(this.tier.transferRate.get()).m_130946_("/t").m_130940_(ChatFormatting.GRAY)}).m_130940_(ChatFormatting.DARK_GRAY));
        Double feRatio = (Double)FTBICConfig.ENERGY.ZAP_TO_FE_CONVERSION_RATE.get();
        if (feRatio > 0.0) {
            list.add((Component)Component.m_237110_((String)"ftbic.zap_to_fe_conversion", (Object[])new Object[]{FTBICConfig.ENERGY_FORMAT, feRatio}).m_130940_(ChatFormatting.DARK_GRAY));
        }
    }
}

