/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.block.entity.generator;

import dev.ftb.mods.ftbic.FTBICConfig;
import dev.ftb.mods.ftbic.block.BurntCableBlock;
import dev.ftb.mods.ftbic.block.CableBlock;
import dev.ftb.mods.ftbic.block.ElectricBlockInstance;
import dev.ftb.mods.ftbic.block.entity.ElectricBlockEntity;
import dev.ftb.mods.ftbic.block.entity.machine.BatteryInventory;
import dev.ftb.mods.ftbic.util.CachedEnergyStorage;
import dev.ftb.mods.ftbic.util.CachedEnergyStorageOrigin;
import dev.ftb.mods.ftbic.util.EnergyHandler;
import dev.ftb.mods.ftbic.util.EnergyItemHandler;
import dev.ftb.mods.ftbic.util.FTBICUtils;
import dev.ftb.mods.ftbic.util.ForgeEnergyHandler;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class GeneratorBlockEntity
extends ElectricBlockEntity {
    private long currentElectricNetwork = -1L;
    private CachedEnergyStorage[] connectedEnergyBlocks;
    public final BatteryInventory chargeBatteryInventory = new BatteryInventory(this, true);
    public double maxEnergyOutput;
    public double maxEnergyOutputTransfer;

    public GeneratorBlockEntity(ElectricBlockInstance type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void initProperties() {
        super.initProperties();
        this.maxEnergyOutput = this.electricBlockInstance.maxEnergyOutput.get();
        this.maxEnergyOutputTransfer = (Double)FTBICConfig.ENERGY.LV_TRANSFER_RATE.get();
    }

    @Override
    public void writeData(CompoundTag tag) {
        super.writeData(tag);
        if (!this.chargeBatteryInventory.getStackInSlot(0).m_41619_()) {
            tag.m_128365_("ChargeBattery", (Tag)this.chargeBatteryInventory.getStackInSlot(0).serializeNBT());
        }
    }

    @Override
    public void readData(CompoundTag tag) {
        super.readData(tag);
        if (tag.m_128441_("ChargeBattery")) {
            this.chargeBatteryInventory.loadItem(ItemStack.m_41712_((CompoundTag)tag.m_128469_("ChargeBattery")));
        } else {
            this.chargeBatteryInventory.loadItem(ItemStack.f_41583_);
        }
    }

    @Override
    public void onBroken(Level level, BlockPos pos) {
        super.onBroken(level, pos);
        Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)this.chargeBatteryInventory.getStackInSlot(0));
    }

    public void handleEnergyOutput() {
        double tenergy;
        double transfer;
        EnergyItemHandler item;
        double e;
        Item item2;
        ItemStack battery;
        if (this.f_58857_.m_5776_()) {
            return;
        }
        if (this.energy > 0.0 && !(battery = this.chargeBatteryInventory.getStackInSlot(0)).m_41619_() && (item2 = battery.m_41720_()) instanceof EnergyItemHandler && (e = item.insertEnergy(battery, Math.min(this.energy, transfer = (item = (EnergyItemHandler)item2).isCreativeEnergyItem() ? Double.POSITIVE_INFINITY : this.maxEnergyOutputTransfer * (Double)FTBICConfig.MACHINES.ITEM_TRANSFER_EFFICIENCY.get()), false)) > 0.0) {
            this.energy -= e;
            this.active = true;
            this.m_6596_();
        }
        if ((tenergy = Math.min(this.energy, this.maxEnergyOutputTransfer)) <= 0.0) {
            return;
        }
        CachedEnergyStorage[] blocks = this.getConnectedEnergyBlocks();
        int validBlocks = 0;
        for (CachedEnergyStorage storage : blocks) {
            if (storage.isInvalid()) {
                GeneratorBlockEntity.electricNetworkUpdated((LevelAccessor)this.f_58857_, storage.blockEntity.m_58899_());
                continue;
            }
            if (!storage.shouldReceiveEnergy()) continue;
            ++validBlocks;
        }
        if (validBlocks > 0) {
            double e2 = tenergy / (double)validBlocks;
            for (CachedEnergyStorage storage : blocks) {
                if (storage.isInvalid() || !storage.shouldReceiveEnergy()) continue;
                if (storage.origin.cableTier != null && storage.origin.cableTier.transferRate.get() < e2) {
                    this.f_58857_.m_7731_(storage.origin.cablePos, BurntCableBlock.getBurntCable(this.f_58857_.m_8055_(storage.origin.cablePos)), 3);
                    this.f_58857_.m_46796_(1502, storage.origin.cablePos, 0);
                    storage.origin.cableBurnt = true;
                    continue;
                }
                double a = storage.energyHandler.insertEnergy(Math.min(e2, this.energy), false);
                if (a > 0.0) {
                    this.energy -= a;
                    this.active = true;
                    this.m_6596_();
                }
                if (this.energy < e2) break;
            }
        }
    }

    public void handleGeneration() {
    }

    @Override
    public void tick() {
        if (!this.f_58857_.m_5776_()) {
            this.handleGeneration();
        }
        this.handleEnergyOutput();
        this.handleChanges();
    }

    public boolean isValidEnergyOutputSide(Direction direction) {
        return true;
    }

    @Override
    public boolean isValidEnergyInputSide(Direction direction) {
        return false;
    }

    public CachedEnergyStorage[] getConnectedEnergyBlocks() {
        if (this.f_58857_ == null || this.f_58857_.m_5776_()) {
            return CachedEnergyStorage.EMPTY;
        }
        long currentId = GeneratorBlockEntity.getCurrentElectricNetwork((LevelAccessor)this.f_58857_, this.m_58899_());
        if (this.connectedEnergyBlocks == null || this.currentElectricNetwork == -1L || this.currentElectricNetwork != currentId) {
            HashSet<CachedEnergyStorage> set = new HashSet<CachedEnergyStorage>();
            HashSet<BlockPos> traversed = new HashSet<BlockPos>();
            traversed.add(this.f_58858_);
            for (Direction direction : FTBICUtils.DIRECTIONS) {
                if (!this.isValidEnergyOutputSide(direction)) continue;
                CachedEnergyStorageOrigin origin = new CachedEnergyStorageOrigin();
                origin.direction = direction;
                this.find(traversed, set, origin, 0, this.f_58858_, direction);
            }
            this.connectedEnergyBlocks = set.toArray(CachedEnergyStorage.EMPTY);
            this.currentElectricNetwork = currentId;
        }
        return this.connectedEnergyBlocks;
    }

    private void find(Set<BlockPos> traversed, Set<CachedEnergyStorage> set, CachedEnergyStorageOrigin origin, int distance, BlockPos currentPos, Direction direction) {
        if (this.f_58857_ == null || distance > (Integer)FTBICConfig.ENERGY.MAX_CABLE_LENGTH.get()) {
            return;
        }
        BlockPos pos = currentPos.m_121945_(direction);
        if (!traversed.add(pos)) {
            return;
        }
        BlockState state = this.f_58857_.m_8055_(pos);
        Direction[] directionArray = state.m_60734_();
        if (directionArray instanceof CableBlock) {
            CableBlock cableBlock = (CableBlock)directionArray;
            if (origin.cableTier == null || cableBlock.tier.transferRate.get() < origin.cableTier.transferRate.get()) {
                origin.cableTier = cableBlock.tier;
                origin.cablePos = pos;
            }
            for (Direction dir : FTBICUtils.DIRECTIONS) {
                if (!((Boolean)state.m_61143_((Property)CableBlock.CONNECTION[dir.m_122411_()])).booleanValue()) continue;
                this.find(traversed, set, origin, distance + 1, pos, dir);
            }
        } else if (state.m_155947_()) {
            EnergyHandler handler;
            BlockEntity entity = this.f_58857_.m_7702_(pos);
            EnergyHandler energyHandler = handler = entity instanceof EnergyHandler ? (EnergyHandler)entity : null;
            if (handler != null) {
                if (handler != this && handler.getMaxInputEnergy() > 0.0 && !handler.isBurnt() && handler.isValidEnergyInputSide(direction.m_122424_())) {
                    CachedEnergyStorage s = new CachedEnergyStorage();
                    s.origin = origin;
                    s.distance = distance;
                    s.blockEntity = entity;
                    s.energyHandler = handler;
                    set.add(s);
                }
            } else if ((Double)FTBICConfig.ENERGY.ZAP_TO_FE_CONVERSION_RATE.get() > 0.0) {
                if (entity == null) {
                    return;
                }
                LazyOptional energyCap = entity.getCapability(CapabilityEnergy.ENERGY, direction.m_122424_());
                IEnergyStorage feStorage = (IEnergyStorage)energyCap.orElse(null);
                if (feStorage != null && feStorage.canReceive()) {
                    CachedEnergyStorage s = new CachedEnergyStorage();
                    s.origin = origin;
                    s.distance = distance;
                    s.blockEntity = entity;
                    s.energyHandler = new ForgeEnergyHandler((LazyOptional<IEnergyStorage>)energyCap, feStorage);
                    set.add(s);
                }
            }
        }
    }
}

