/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.block.entity.machine;

import dev.ftb.mods.ftbic.FTBICConfig;
import dev.ftb.mods.ftbic.block.FTBICBlocks;
import dev.ftb.mods.ftbic.block.FTBICElectricBlocks;
import dev.ftb.mods.ftbic.block.entity.machine.DiggingBaseBlockEntity;
import dev.ftb.mods.ftbic.screen.PumpMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PumpBlockEntity
extends DiggingBaseBlockEntity
implements IFluidHandler,
IFluidTank {
    private static final float[] LASER_COLOR = new float[]{0.2f, 0.5f, 1.0f};
    public FluidStack fluidStack = FluidStack.EMPTY;
    public Fluid filter = Fluids.f_76191_;

    public PumpBlockEntity(BlockPos pos, BlockState state) {
        super(FTBICElectricBlocks.PUMP, pos, state);
    }

    @Override
    public void initProperties() {
        super.initProperties();
        this.diggingMineTicks = (Long)FTBICConfig.MACHINES.PUMP_MINE_TICKS.get();
        this.diggingMoveTicks = (Long)FTBICConfig.MACHINES.PUMP_MOVE_TICKS.get();
    }

    @Override
    public void writeData(CompoundTag tag) {
        super.writeData(tag);
        tag.m_128365_("Fluid", (Tag)this.fluidStack.writeToNBT(new CompoundTag()));
        tag.m_128359_("Filter", Registry.f_122822_.m_7981_((Object)this.filter).toString());
    }

    @Override
    public void readData(CompoundTag tag) {
        super.readData(tag);
        this.fluidStack = FluidStack.loadFluidStackFromNBT((CompoundTag)tag.m_128469_("Fluid"));
        this.filter = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(tag.m_128461_("Filter")));
    }

    @Override
    public void readNetData(CompoundTag tag) {
        super.readNetData(tag);
        this.fluidStack = FluidStack.loadFluidStackFromNBT((CompoundTag)tag.m_128469_("Fluid"));
        this.filter = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(tag.m_128461_("Filter")));
    }

    @Override
    public void writeNetData(CompoundTag tag) {
        super.writeNetData(tag);
        tag.m_128365_("Fluid", (Tag)this.fluidStack.writeToNBT(new CompoundTag()));
        tag.m_128359_("Filter", Registry.f_122822_.m_7981_((Object)this.filter).toString());
    }

    @Override
    public boolean isValidBlock(BlockState state, BlockPos pos) {
        return state.m_60767_().m_76332_() && state.m_60734_() instanceof BucketPickup && (this.filter == Fluids.f_76191_ || this.filter.m_6212_(state.m_60819_().m_76152_())) && state.m_60819_().m_76170_();
    }

    @Override
    public void digBlock(BlockState state, BlockPos miningPos, double lx, double ly, double lz) {
        Block block = state.m_60734_();
        if (block instanceof BucketPickup) {
            FluidStack fluidStack2;
            BucketPickup bucketPickup = (BucketPickup)block;
            if (this.fluidStack.getAmount() + 1000 <= this.getCapacity() && !(fluidStack2 = FluidUtil.getFluidContained((ItemStack)bucketPickup.m_142598_((LevelAccessor)this.f_58857_, miningPos, state)).orElse(FluidStack.EMPTY)).isEmpty()) {
                if (this.filter == Fluids.f_76191_) {
                    this.filter = fluidStack2.getFluid();
                } else if (this.filter != fluidStack2.getFluid()) {
                    return;
                }
                if (this.fluidStack.isEmpty()) {
                    this.fluidStack = new FluidStack(this.filter, 1000);
                } else {
                    this.fluidStack.setAmount(this.fluidStack.getAmount() + 1000);
                }
                BlockState replaceState = (Boolean)FTBICConfig.MACHINES.PUMP_REPLACE_FLUID_EXFLUID.get() != false ? FTBICBlocks.EXFLUID.get().m_49966_() : Blocks.f_50016_.m_49966_();
                this.f_58857_.m_7731_(miningPos, replaceState, 2);
                this.m_6596_();
            }
        }
    }

    @Override
    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY ? this.getThisOptional().cast() : super.getCapability(cap, side);
    }

    @Override
    public InteractionResult rightClick(Player player, InteractionHand hand, BlockHitResult hit) {
        if (!this.f_58857_.m_5776_()) {
            if (player.m_6047_()) {
                this.paused = !this.paused;
                this.syncBlock();
            } else {
                this.openMenu((ServerPlayer)player, (id, inventory) -> new PumpMenu(id, inventory, this));
            }
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public void writeMenu(ServerPlayer player, FriendlyByteBuf buf) {
        super.writeMenu(player, buf);
        buf.m_130085_(Registry.f_122822_.m_7981_((Object)this.filter));
        this.fluidStack.writeToPacket(buf);
    }

    @Override
    public float[] getLaserColor() {
        return LASER_COLOR;
    }

    @NotNull
    public FluidStack getFluid() {
        return this.fluidStack;
    }

    public int getFluidAmount() {
        return this.fluidStack.getAmount();
    }

    public int getCapacity() {
        return (Integer)FTBICConfig.MACHINES.PUMP_TANK_CAPACITY.get();
    }

    public boolean isFluidValid(FluidStack fluidStack) {
        return false;
    }

    public int getTanks() {
        return 1;
    }

    @NotNull
    public FluidStack getFluidInTank(int i) {
        return this.fluidStack;
    }

    public int getTankCapacity(int i) {
        return (Integer)FTBICConfig.MACHINES.PUMP_TANK_CAPACITY.get();
    }

    public boolean isFluidValid(int i, @NotNull FluidStack fluidStack) {
        return false;
    }

    public int fill(FluidStack fluidStack, IFluidHandler.FluidAction fluidAction) {
        return 0;
    }

    @NotNull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.f_58857_ == null || this.f_58857_.m_5776_() || resource.isEmpty() || !resource.isFluidEqual(this.fluidStack)) {
            return FluidStack.EMPTY;
        }
        return this.drain(resource.getAmount(), action);
    }

    @NotNull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (this.f_58857_ == null || this.f_58857_.m_5776_()) {
            return FluidStack.EMPTY;
        }
        int drained = maxDrain;
        if (this.fluidStack.getAmount() < drained) {
            drained = this.fluidStack.getAmount();
        }
        FluidStack stack = new FluidStack(this.fluidStack, drained);
        if (action.execute() && drained > 0) {
            this.fluidStack.shrink(drained);
            this.m_6596_();
            if (this.fluidStack.isEmpty() && this.paused) {
                this.paused = false;
                this.syncBlock();
            }
        }
        return stack;
    }

    @Override
    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        switch (slot) {
            case 0: {
                if (!stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).isPresent()) break;
                return true;
            }
        }
        return false;
    }

    @Override
    public void handleProcessing() {
        super.handleProcessing();
        IFluidHandlerItem iFluidHandlerItemInput = (IFluidHandlerItem)this.inputItems[0].getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).orElse(null);
        IFluidHandlerItem iFluidHandlerItemOutput = (IFluidHandlerItem)this.outputItems[0].getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).orElse(null);
        boolean hasFilledItem = false;
        if (iFluidHandlerItemInput != null) {
            int itemCapacityInput = iFluidHandlerItemInput.getTankCapacity(0);
            int emptyAmount = iFluidHandlerItemInput.getTankCapacity(0) - iFluidHandlerItemInput.getFluidInTank(0).getAmount();
            boolean isBucket = iFluidHandlerItemInput.getContainer().m_41720_() instanceof BucketItem;
            if (this.drain(emptyAmount, IFluidHandler.FluidAction.SIMULATE).getAmount() == emptyAmount && emptyAmount > 0) {
                if (this.outputItems[0].m_41619_()) {
                    ItemStack resultStack = iFluidHandlerItemInput.getContainer().m_41777_();
                    IFluidHandlerItem newIFluidHandlerOutput = (IFluidHandlerItem)resultStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).orElse(null);
                    if (newIFluidHandlerOutput != null) {
                        iFluidHandlerItemInput.getContainer().m_41774_(1);
                        newIFluidHandlerOutput.getContainer().m_41764_(1);
                        newIFluidHandlerOutput.fill(this.drain(itemCapacityInput, IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
                        this.outputItems[0] = !isBucket ? resultStack : new ItemStack((ItemLike)newIFluidHandlerOutput.getFluidInTank(0).getFluid().m_6859_());
                        hasFilledItem = true;
                    }
                } else if (iFluidHandlerItemOutput != null) {
                    boolean stackFull;
                    int itemCapacityOutput = iFluidHandlerItemOutput.getTankCapacity(0);
                    boolean filledOutput = iFluidHandlerItemOutput.getFluidInTank(0).getAmount() == itemCapacityOutput;
                    boolean fluidMatch = iFluidHandlerItemOutput.getFluidInTank(0).isFluidEqual(this.fluidStack);
                    boolean sameItem = iFluidHandlerItemOutput.getContainer().m_41656_(iFluidHandlerItemInput.getContainer());
                    boolean sameCapacity = itemCapacityInput == itemCapacityOutput;
                    boolean bl = stackFull = iFluidHandlerItemOutput.getContainer().m_41613_() >= iFluidHandlerItemOutput.getContainer().m_41741_();
                    if (sameItem && fluidMatch && filledOutput && sameCapacity && !stackFull) {
                        this.drain(itemCapacityInput, IFluidHandler.FluidAction.EXECUTE);
                        iFluidHandlerItemInput.getContainer().m_41774_(1);
                        iFluidHandlerItemOutput.getContainer().m_41769_(1);
                        hasFilledItem = true;
                    }
                }
            }
        }
        if (hasFilledItem) {
            this.m_6596_();
        }
    }
}

