/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.datagen;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import dev.ftb.mods.ftbic.block.BaseCableBlock;
import dev.ftb.mods.ftbic.block.CableBlock;
import dev.ftb.mods.ftbic.block.ElectricBlock;
import dev.ftb.mods.ftbic.block.ElectricBlockInstance;
import dev.ftb.mods.ftbic.block.FTBICBlocks;
import dev.ftb.mods.ftbic.block.FTBICElectricBlocks;
import dev.ftb.mods.ftbic.block.SprayPaintable;
import dev.ftb.mods.ftbic.datagen.CombinedTextureProvider;
import dev.ftb.mods.ftbic.datagen.FTBICBiomeModifierDataGen;
import dev.ftb.mods.ftbic.datagen.FTBICRecipesGen;
import dev.ftb.mods.ftbic.datagen.recipes.FTBICArmorRecipes;
import dev.ftb.mods.ftbic.datagen.recipes.FTBICBatteryRecipes;
import dev.ftb.mods.ftbic.datagen.recipes.FTBICCableRecipes;
import dev.ftb.mods.ftbic.datagen.recipes.FTBICComponentRecipes;
import dev.ftb.mods.ftbic.datagen.recipes.FTBICCraftingRecipes;
import dev.ftb.mods.ftbic.datagen.recipes.FTBICEnergyStorageRecipes;
import dev.ftb.mods.ftbic.datagen.recipes.FTBICExtrudingRecipes;
import dev.ftb.mods.ftbic.datagen.recipes.FTBICFurnaceRecipes;
import dev.ftb.mods.ftbic.datagen.recipes.FTBICGeneratorFuelRecipes;
import dev.ftb.mods.ftbic.datagen.recipes.FTBICGeneratorRecipes;
import dev.ftb.mods.ftbic.datagen.recipes.FTBICMaceratingRecipes;
import dev.ftb.mods.ftbic.datagen.recipes.FTBICMachineRecipes;
import dev.ftb.mods.ftbic.datagen.recipes.FTBICNuclearRecipes;
import dev.ftb.mods.ftbic.datagen.recipes.FTBICRollingRecipes;
import dev.ftb.mods.ftbic.datagen.recipes.FTBICToolRecipes;
import dev.ftb.mods.ftbic.datagen.recipes.FTBICUpgradeRecipes;
import dev.ftb.mods.ftbic.datagen.recipes.FTBICVanillaRecipes;
import dev.ftb.mods.ftbic.item.FTBICItems;
import dev.ftb.mods.ftbic.item.MaterialItem;
import dev.ftb.mods.ftbic.util.BurntBlockCondition;
import dev.ftb.mods.ftbic.util.FTBICUtils;
import dev.ftb.mods.ftbic.world.ResourceElements;
import dev.ftb.mods.ftbic.world.ResourceType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.loot.BlockLoot;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.tags.BiomeTagsProvider;
import net.minecraft.data.tags.BlockTagsProvider;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockModelProvider;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.client.model.generators.loaders.CompositeModelBuilder;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ftbic", bus=Mod.EventBusSubscriber.Bus.MOD)
public class FTBICDataGenHandler {
    public static final String MODID = "ftbic";

    @SubscribeEvent
    public static void dataGenEvent(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        ExistingFileHelper efh = event.getExistingFileHelper();
        if (event.includeClient()) {
            gen.m_236039_(event.includeServer(), (DataProvider)new FTBICLang(gen, MODID, "en_us"));
            gen.m_236039_(event.includeServer(), (DataProvider)new FTBICTextures(gen, MODID, efh));
            gen.m_236039_(event.includeServer(), (DataProvider)new FTBICBlockModels(gen, MODID, efh));
            gen.m_236039_(event.includeServer(), (DataProvider)new FTBICBlockStates(gen, MODID, efh));
            gen.m_236039_(event.includeServer(), (DataProvider)new FTBICItemModels(gen, MODID, efh));
        }
        if (event.includeServer()) {
            ICBlockTags blockTags = new ICBlockTags(gen, MODID, efh);
            gen.m_236039_(event.includeServer(), (DataProvider)blockTags);
            gen.m_236039_(event.includeServer(), (DataProvider)new FTBICItemTags(gen, blockTags, MODID, efh));
            gen.m_236039_(event.includeServer(), (DataProvider)new ICBiomeTags(gen, MODID, efh));
            gen.m_236039_(event.includeServer(), (DataProvider)new FTBICComponentRecipes(gen));
            gen.m_236039_(event.includeServer(), (DataProvider)new FTBICUpgradeRecipes(gen));
            gen.m_236039_(event.includeServer(), (DataProvider)new FTBICCableRecipes(gen));
            gen.m_236039_(event.includeServer(), (DataProvider)new FTBICBatteryRecipes(gen));
            gen.m_236039_(event.includeServer(), (DataProvider)new FTBICGeneratorRecipes(gen));
            gen.m_236039_(event.includeServer(), (DataProvider)new FTBICMachineRecipes(gen));
            gen.m_236039_(event.includeServer(), (DataProvider)new FTBICEnergyStorageRecipes(gen));
            gen.m_236039_(event.includeServer(), (DataProvider)new FTBICToolRecipes(gen));
            gen.m_236039_(event.includeServer(), (DataProvider)new FTBICArmorRecipes(gen));
            gen.m_236039_(event.includeServer(), (DataProvider)new FTBICNuclearRecipes(gen));
            gen.m_236039_(event.includeServer(), (DataProvider)new FTBICGeneratorFuelRecipes(gen));
            gen.m_236039_(event.includeServer(), (DataProvider)new FTBICVanillaRecipes(gen));
            gen.m_236039_(event.includeServer(), (DataProvider)new FTBICLootTableProvider(gen));
            gen.m_236039_(event.includeServer(), (DataProvider)new FTBICFurnaceRecipes(gen));
            gen.m_236039_(event.includeServer(), (DataProvider)new FTBICMaceratingRecipes(gen));
            gen.m_236039_(event.includeServer(), (DataProvider)new FTBICCraftingRecipes(gen));
            gen.m_236039_(event.includeServer(), (DataProvider)new FTBICRollingRecipes(gen));
            gen.m_236039_(event.includeServer(), (DataProvider)new FTBICExtrudingRecipes(gen));
        }
        gen.m_236039_(event.includeServer(), (DataProvider)new FTBICBiomeModifierDataGen(gen, MODID));
    }

    private static String titleCase(String input) {
        return Character.toUpperCase(input.charAt(0)) + input.substring(1);
    }

    private static class FTBICLang
    extends LanguageProvider {
        public FTBICLang(DataGenerator gen, String modid, String locale) {
            super(gen, modid, locale);
        }

        private void addBlock(Supplier<Block> block) {
            this.addBlockWithSuffix(block, "");
        }

        private void addBlockWithSuffix(Supplier<Block> block, String suffix) {
            this.addBlock(block, Arrays.stream(Registry.f_122824_.m_7981_((Object)block.get()).m_135815_().split("_")).map(FTBICDataGenHandler::titleCase).collect(Collectors.joining(" ")) + suffix);
        }

        private void addItemWithSuffix(Supplier<Item> item, String suffix) {
            this.addItem(item, Arrays.stream(Registry.f_122827_.m_7981_((Object)item.get()).m_135815_().split("_")).map(s -> Character.toUpperCase(s.charAt(0)) + s.substring(1)).collect(Collectors.joining(" ")));
        }

        private void addItem(Supplier<Item> item) {
            this.addItemWithSuffix(item, "");
        }

        protected void addTranslations() {
            this.add("itemGroup.ftbic", "FTB Industrial Contraptions");
            this.addBlock(FTBICBlocks.RUBBER_SHEET);
            this.addBlock(FTBICBlocks.REINFORCED_STONE);
            this.addBlock(FTBICBlocks.REINFORCED_GLASS);
            this.addBlock(FTBICBlocks.MACHINE_BLOCK);
            this.addBlock(FTBICBlocks.ADVANCED_MACHINE_BLOCK);
            this.addBlock(FTBICBlocks.IRON_FURNACE);
            this.addBlock(FTBICBlocks.LV_CABLE, "LV Cable");
            this.addBlock(FTBICBlocks.MV_CABLE, "MV Cable");
            this.addBlock(FTBICBlocks.HV_CABLE, "HV Cable");
            this.addBlock(FTBICBlocks.EV_CABLE, "EV Cable");
            this.addBlock(FTBICBlocks.IV_CABLE, "IV Cable");
            this.addBlock(FTBICBlocks.BURNT_CABLE);
            this.addBlock(FTBICBlocks.LANDMARK);
            this.addBlock(FTBICBlocks.EXFLUID, "Ex-Fluid");
            this.addBlock(FTBICBlocks.NUCLEAR_REACTOR_CHAMBER);
            this.addBlock(FTBICBlocks.NUKE);
            this.addBlock(FTBICBlocks.ACTIVE_NUKE);
            FTBICItems.RESOURCE_TYPE_MAP.forEach((k, v) -> v.forEach((k2, v2) -> this.addItemWithSuffix((Supplier<Item>)v2, " " + FTBICDataGenHandler.titleCase(k.name().toLowerCase(Locale.ENGLISH)))));
            for (ElectricBlockInstance machine : FTBICElectricBlocks.ALL) {
                this.addBlock(machine.block, machine.name);
            }
            for (MaterialItem item : FTBICItems.MATERIALS) {
                this.addItem(item.item, item.name);
            }
            this.addItem(FTBICItems.SINGLE_USE_BATTERY);
            this.addItem(FTBICItems.LV_BATTERY, "LV Battery");
            this.addItem(FTBICItems.MV_BATTERY, "MV Battery");
            this.addItem(FTBICItems.HV_BATTERY, "HV Battery");
            this.addItem(FTBICItems.EV_BATTERY, "EV Battery");
            this.addItem(FTBICItems.CREATIVE_BATTERY);
            this.addItem(FTBICItems.FLUID_CELL);
            this.addItem(FTBICItems.SMALL_COOLANT_CELL);
            this.addItem(FTBICItems.MEDIUM_COOLANT_CELL);
            this.addItem(FTBICItems.LARGE_COOLANT_CELL);
            this.addItem(FTBICItems.URANIUM_FUEL_ROD);
            this.addItem(FTBICItems.DUAL_URANIUM_FUEL_ROD);
            this.addItem(FTBICItems.QUAD_URANIUM_FUEL_ROD);
            this.addItem(FTBICItems.HEAT_VENT);
            this.addItem(FTBICItems.ADVANCED_HEAT_VENT);
            this.addItem(FTBICItems.OVERCLOCKED_HEAT_VENT);
            this.addItem(FTBICItems.REACTOR_HEAT_VENT);
            this.addItem(FTBICItems.COMPONENT_HEAT_VENT);
            this.addItem(FTBICItems.HEAT_EXCHANGER);
            this.addItem(FTBICItems.ADVANCED_HEAT_EXCHANGER);
            this.addItem(FTBICItems.REACTOR_HEAT_EXCHANGER);
            this.addItem(FTBICItems.COMPONENT_HEAT_EXCHANGER);
            this.addItem(FTBICItems.REACTOR_PLATING);
            this.addItem(FTBICItems.CONTAINMENT_REACTOR_PLATING);
            this.addItem(FTBICItems.HEAT_CAPACITY_REACTOR_PLATING, "Heat-Capacity Reactor Plating");
            this.addItem(FTBICItems.NEUTRON_REFLECTOR);
            this.addItem(FTBICItems.THICK_NEUTRON_REFLECTOR);
            this.addItem(FTBICItems.IRIDIUM_NEUTRON_REFLECTOR);
            this.addItem(FTBICItems.CANNED_FOOD);
            this.addItem(FTBICItems.PROTEIN_BAR, "Feed The Beast\u2122 Protein Bar");
            this.addItem(FTBICItems.DARK_SPRAY_PAINT_CAN, "Spray Paint Can (Dark)");
            this.addItem(FTBICItems.LIGHT_SPRAY_PAINT_CAN, "Spray Paint Can (Light)");
            this.addItem(FTBICItems.OVERCLOCKER_UPGRADE);
            this.addItem(FTBICItems.ENERGY_STORAGE_UPGRADE);
            this.addItem(FTBICItems.TRANSFORMER_UPGRADE);
            this.addItem(FTBICItems.EJECTOR_UPGRADE);
            this.addItem(FTBICItems.MECHANICAL_ELYTRA);
            this.addItem(FTBICItems.CARBON_HELMET);
            this.addItem(FTBICItems.CARBON_CHESTPLATE);
            this.addItem(FTBICItems.CARBON_LEGGINGS);
            this.addItem(FTBICItems.CARBON_BOOTS);
            this.addItem(FTBICItems.QUANTUM_HELMET);
            this.addItem(FTBICItems.QUANTUM_CHESTPLATE);
            this.addItem(FTBICItems.QUANTUM_LEGGINGS);
            this.addItem(FTBICItems.QUANTUM_BOOTS);
            this.addItem(FTBICItems.NUKE_ARROW);
            this.add("recipe.ftbic.macerating", "Macerating");
            this.add("recipe.ftbic.separating", "Separating");
            this.add("recipe.ftbic.compressing", "Compressing");
            this.add("recipe.ftbic.reprocessing", "Reprocessing");
            this.add("recipe.ftbic.canning", "Canning");
            this.add("recipe.ftbic.rolling", "Rolling");
            this.add("recipe.ftbic.extruding", "Extruding");
            this.add("recipe.ftbic.reconstructing", "Reconstructing");
            this.add("ftbic.energy_output", "Energy Output: %s");
            this.add("ftbic.energy_capacity", "Energy Capacity: %s");
            this.add("ftbic.energy_usage", "Energy Usage: %s");
            this.add("ftbic.max_input", "Max Input: %s");
            this.add("ftbic.fuse_info", "This machine's fuse has blown! Right-click it with a fresh one to repair it!");
            this.add("ftbic.any_item", "Any Item");
            this.add("ftbic.requires_chestplate", "Requires Chestplate to function");
            this.add("ftbic.zap_to_fe_conversion", "Allows one-way conversion of %1$s to FE (1 %1$s = %2$s FE)");
            this.add("item.ftbic.spray_paint_can.tooltip", "Right-click on a machine to change its theme");
            this.add("block.ftbic.teleporter.perm_error", "Only owner of this teleporter can change it's settings!");
            this.add("block.ftbic.teleporter.load_error", "The destination chunk has to be loaded!");
            this.add("block.ftbic.nuke.broadcast", "%s has launched a Nuke!");
            this.add("block.ftbic.nuclear_reactor.broadcast", "%s forgot to cool their Nuclear Reactor!");
        }
    }

    private static class FTBICTextures
    extends CombinedTextureProvider {
        public static final int WOOD_UNIVERSAL = 0;
        public static final int BASIC_UNIVERSAL = 1;
        public static final int BASIC_TOP = 2;
        public static final int BASIC_BOTTOM = 3;
        public static final int BASIC_SIDE = 4;
        public static final int ADVANCED_UNIVERSAL = 5;
        public static final int ADVANCED_TOP = 6;
        public static final int ADVANCED_BOTTOM = 7;
        public static final int ADVANCED_SIDE = 8;
        public static final String[] TEMPLATES = new String[]{"wood_universal", "basic_universal", "basic_top", "basic_bottom", "basic_side", "advanced_universal", "advanced_top", "advanced_bottom", "advanced_side"};

        public FTBICTextures(DataGenerator g, String mod, ExistingFileHelper efh) {
            super(g, mod, efh);
        }

        private void makeThemedElectric(String path, int texture, String source) {
            CombinedTextureProvider.TextureData lightBase = this.load(this.modLoc("block/electric/light/" + TEMPLATES[texture]));
            CombinedTextureProvider.TextureData darkBase = this.load(this.modLoc("block/electric/dark/" + TEMPLATES[texture]));
            this.make(this.modLoc("block/electric/light/" + path), lightBase.combine(this.load(this.modLoc("block/electric/light/template/" + source))));
            this.make(this.modLoc("block/electric/dark/" + path), darkBase.combine(this.load(this.modLoc("block/electric/dark/template/" + source))));
        }

        private void makeThemedElectric(String path, int texture) {
            this.makeThemedElectric(path, texture, path);
        }

        private void makeThemedElectricOnOff(String path, int texture, String source) {
            this.makeThemedElectric(path + "_on", texture, source + "_on");
            this.makeThemedElectric(path + "_off", texture, source + "_off");
        }

        private void makeThemedElectricOnOff(String path, int texture) {
            this.makeThemedElectricOnOff(path, texture, path);
        }

        @Override
        public void registerTextures() {
            this.makeThemedElectricOnOff("basic_generator_front", 4);
            this.makeThemedElectricOnOff("geothermal_generator_front", 4);
            this.makeThemedElectric("wind_mill_front", 4);
            this.makeThemedElectric("lv_solar_panel_top", 2);
            this.makeThemedElectric("mv_solar_panel_top", 2);
            this.makeThemedElectric("hv_solar_panel_top", 6);
            this.makeThemedElectric("ev_solar_panel_top", 6);
            this.makeThemedElectricOnOff("nuclear_reactor_front", 8);
            this.makeThemedElectric("nuclear_reactor_top", 6);
            this.makeThemedElectricOnOff("powered_furnace_front", 4);
            this.makeThemedElectric("macerator_front", 4);
            this.makeThemedElectricOnOff("macerator_top", 2);
            this.makeThemedElectricOnOff("centrifuge_front", 4);
            this.makeThemedElectric("centrifuge_top", 2);
            this.makeThemedElectricOnOff("compressor_front", 4);
            this.makeThemedElectric("compressor_top", 2);
            this.makeThemedElectricOnOff("reprocessor_front", 4);
            this.makeThemedElectric("reprocessor_top", 2);
            this.makeThemedElectricOnOff("canning_machine_front", 4);
            this.makeThemedElectricOnOff("roller_front", 4);
            this.makeThemedElectricOnOff("extruder_front", 4);
            this.makeThemedElectricOnOff("antimatter_constructor_front", 8);
            this.makeThemedElectric("antimatter_constructor_side", 8);
            this.makeThemedElectricOnOff("advanced_powered_furnace_front", 8, "powered_furnace_front");
            this.makeThemedElectric("advanced_macerator_front", 8, "macerator_front");
            this.makeThemedElectricOnOff("advanced_macerator_top", 6, "macerator_top");
            this.makeThemedElectricOnOff("advanced_centrifuge_front", 8, "centrifuge_front");
            this.makeThemedElectric("advanced_centrifuge_top", 6, "centrifuge_top");
            this.makeThemedElectricOnOff("advanced_compressor_front", 8, "compressor_front");
            this.makeThemedElectric("advanced_compressor_top", 6, "compressor_top");
            this.makeThemedElectricOnOff("teleporter_top", 6, "teleporter_top");
            this.makeThemedElectricOnOff("charge_pad_top", 2, "charge_pad_top");
            this.makeThemedElectric("powered_crafting_table_top", 2, "powered_crafting_table_top");
            this.makeThemedElectricOnOff("quarry_front", 8);
            this.makeThemedElectricOnOff("pump_front", 8);
            this.makeThemedElectric("lv_battery_box_in", 0);
            this.makeThemedElectric("lv_battery_box_out", 0);
            this.makeThemedElectric("lv_transformer_in", 0);
            this.makeThemedElectric("lv_transformer_out", 0);
            this.makeThemedElectric("mv_battery_box_in", 1);
            this.makeThemedElectric("mv_battery_box_out", 1);
            this.makeThemedElectric("mv_transformer_in", 1);
            this.makeThemedElectric("mv_transformer_out", 1);
            this.makeThemedElectric("hv_battery_box_in", 5);
            this.makeThemedElectric("hv_battery_box_out", 5);
            this.makeThemedElectric("hv_transformer_in", 5);
            this.makeThemedElectric("hv_transformer_out", 5);
            this.makeThemedElectric("ev_battery_box_in", 5);
            this.makeThemedElectric("ev_battery_box_out", 5);
            this.makeThemedElectric("ev_transformer_in", 5);
            this.makeThemedElectric("ev_transformer_out", 5);
        }
    }

    private static class FTBICBlockModels
    extends BlockModelProvider {
        public static final String BASIC_TOP = "basic_top";
        public static final String BASIC_BOTTOM = "basic_bottom";
        public static final String BASIC_SIDE = "basic_side";
        public static final String ADVANCED_TOP = "advanced_top";
        public static final String ADVANCED_BOTTOM = "advanced_bottom";
        public static final String ADVANCED_SIDE = "advanced_side";

        public FTBICBlockModels(DataGenerator generator, String modid, ExistingFileHelper existingFileHelper) {
            super(generator, modid, existingFileHelper);
        }

        private void electric(String id, String front, String side, String top, String bottom) {
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent("block/electric/light/" + id, this.modLoc("block/orientable_2d"))).texture("side", this.modLoc("block/electric/light/" + side))).texture("front", this.modLoc("block/electric/light/" + front))).texture("top", this.modLoc("block/electric/light/" + top))).texture("bottom", this.modLoc("block/electric/light/" + bottom));
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent("block/electric/dark/" + id, this.modLoc("block/orientable_2d"))).texture("side", this.modLoc("block/electric/dark/" + side))).texture("front", this.modLoc("block/electric/dark/" + front))).texture("top", this.modLoc("block/electric/dark/" + top))).texture("bottom", this.modLoc("block/electric/dark/" + bottom));
        }

        private void electric3d(String id, String front, String side) {
            ((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent("block/electric/light/" + id, this.modLoc("block/orientable_3d"))).texture("side", this.modLoc("block/electric/light/" + side))).texture("front", this.modLoc("block/electric/light/" + front));
            ((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent("block/electric/dark/" + id, this.modLoc("block/orientable_3d"))).texture("side", this.modLoc("block/electric/dark/" + side))).texture("front", this.modLoc("block/electric/dark/" + front));
        }

        protected void registerModels() {
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent("block/rubber_sheet", "block/block")).texture("texture", this.modLoc("block/rubber_sheet"))).texture("particle", this.modLoc("block/rubber_sheet"))).element().from(0.0f, 0.0f, 0.0f).to(16.0f, 3.0f, 16.0f).face(Direction.DOWN).texture("#texture").cullface(Direction.DOWN).end().face(Direction.UP).texture("#texture").end().face(Direction.NORTH).texture("#texture").cullface(Direction.NORTH).end().face(Direction.SOUTH).texture("#texture").cullface(Direction.SOUTH).end().face(Direction.WEST).texture("#texture").cullface(Direction.WEST).end().face(Direction.EAST).texture("#texture").cullface(Direction.EAST).end().end();
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent("block/machine_block", "block/cube_all")).texture("all", this.modLoc("block/electric/light/basic_side"))).texture("top", this.modLoc("block/electric/light/basic_top"))).texture("bottom", this.modLoc("block/electric/light/basic_bottom"));
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent("block/advanced_machine_block", "block/cube_all")).texture("all", this.modLoc("block/electric/light/advanced_side"))).texture("top", this.modLoc("block/electric/light/advanced_top"))).texture("bottom", this.modLoc("block/electric/light/advanced_bottom"));
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent("block/orientable_2d", "block/block")).texture("particle", "#side")).transforms().transform(ItemTransforms.TransformType.FIRST_PERSON_RIGHT_HAND).rotation(0.0f, 135.0f, 0.0f).translation(0.0f, 0.0f, 0.0f).scale(0.4f, 0.4f, 0.4f).end().end()).element().from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f).face(Direction.DOWN).texture("#bottom").cullface(Direction.DOWN).end().face(Direction.UP).texture("#top").cullface(Direction.UP).rotation(ModelBuilder.FaceRotation.UPSIDE_DOWN).end().face(Direction.NORTH).texture("#front").cullface(Direction.NORTH).end().face(Direction.SOUTH).texture("#side").cullface(Direction.SOUTH).end().face(Direction.WEST).texture("#side").cullface(Direction.WEST).end().face(Direction.EAST).texture("#side").cullface(Direction.EAST).end().end();
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent("block/orientable_3d", "block/block")).texture("particle", "#side")).transforms().transform(ItemTransforms.TransformType.FIRST_PERSON_RIGHT_HAND).rotation(0.0f, 135.0f, 0.0f).translation(0.0f, 0.0f, 0.0f).scale(0.4f, 0.4f, 0.4f).end().end()).element().from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f).face(Direction.DOWN).texture("#side").cullface(Direction.DOWN).rotation(ModelBuilder.FaceRotation.UPSIDE_DOWN).end().face(Direction.UP).texture("#side").cullface(Direction.UP).end().face(Direction.NORTH).texture("#front").cullface(Direction.NORTH).end().face(Direction.SOUTH).texture("#side").cullface(Direction.SOUTH).end().face(Direction.WEST).texture("#side").cullface(Direction.WEST).rotation(ModelBuilder.FaceRotation.COUNTERCLOCKWISE_90).end().face(Direction.EAST).texture("#side").cullface(Direction.EAST).rotation(ModelBuilder.FaceRotation.CLOCKWISE_90).end().end();
            for (Supplier<Block> cable : FTBICBlocks.CABLES) {
                BaseCableBlock block = (BaseCableBlock)cable.get();
                String id = Registry.f_122824_.m_7981_((Object)block).m_135815_();
                ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent("block/" + id + "_base", "block/block")).texture("texture", this.modLoc("block/" + id))).texture("particle", this.modLoc("block/" + id))).element().from((float)block.border, (float)block.border, (float)block.border).to(16.0f - (float)block.border, 16.0f - (float)block.border, 16.0f - (float)block.border).face(Direction.DOWN).texture("#texture").end().face(Direction.UP).texture("#texture").end().face(Direction.NORTH).texture("#texture").end().face(Direction.SOUTH).texture("#texture").end().face(Direction.WEST).texture("#texture").end().face(Direction.EAST).texture("#texture").end().end();
                ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent("block/" + id + "_connection", "block/block")).texture("texture", this.modLoc("block/" + id))).texture("particle", this.modLoc("block/" + id))).element().from((float)block.border, 0.0f, (float)block.border).to(16.0f - (float)block.border, (float)block.border, 16.0f - (float)block.border).face(Direction.DOWN).texture("#texture").cullface(Direction.DOWN).end().face(Direction.NORTH).texture("#texture").end().face(Direction.SOUTH).texture("#texture").end().face(Direction.WEST).texture("#texture").end().face(Direction.EAST).texture("#texture").end().end();
            }
            this.orientable("block/iron_furnace_off", this.modLoc("block/iron_furnace_side"), this.modLoc("block/iron_furnace_front_off"), this.modLoc("block/iron_furnace_top"));
            this.orientable("block/iron_furnace_on", this.modLoc("block/iron_furnace_side"), this.modLoc("block/iron_furnace_front_on"), this.modLoc("block/iron_furnace_top"));
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent("block/landmark", "block/block")).texture("particle", this.modLoc("block/landmark_ns"))).texture("landmark_ns", this.modLoc("block/landmark_ns"))).texture("landmark_we", this.modLoc("block/landmark_we"))).ao(false)).element().from(7.0f, 0.0f, 7.0f).to(9.0f, 7.0f, 9.0f).shade(false).face(Direction.DOWN).texture("#landmark_ns").cullface(Direction.DOWN).end().face(Direction.NORTH).texture("#landmark_ns").end().face(Direction.SOUTH).texture("#landmark_ns").end().face(Direction.WEST).texture("#landmark_we").end().face(Direction.EAST).texture("#landmark_we").end().end()).element().from(6.97f, 6.97f, 6.97f).to(9.03f, 9.03f, 9.03f).shade(false).face(Direction.DOWN).uvs(7.0f, 7.0f, 9.0f, 9.0f).texture("#landmark_ns").end().face(Direction.UP).uvs(7.0f, 7.0f, 9.0f, 9.0f).texture("#landmark_ns").end().face(Direction.NORTH).uvs(7.0f, 7.0f, 9.0f, 9.0f).texture("#landmark_ns").end().face(Direction.SOUTH).uvs(7.0f, 7.0f, 9.0f, 9.0f).texture("#landmark_ns").end().face(Direction.WEST).uvs(7.0f, 7.0f, 9.0f, 9.0f).texture("#landmark_we").end().face(Direction.EAST).uvs(7.0f, 7.0f, 9.0f, 9.0f).texture("#landmark_we").end().end();
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent("block/nuclear_reactor_chamber", "block/cube_bottom_top")).texture("top", this.modLoc("block/electric/light/nuclear_reactor_top"))).texture("bottom", this.modLoc("block/electric/light/advanced_bottom"))).texture("side", this.modLoc("block/electric/light/advanced_side"));
            ((BlockModelBuilder)this.withExistingParent("block/nuke", "block/tnt")).texture("side", this.modLoc("block/nuke_side"));
            ((BlockModelBuilder)this.withExistingParent("block/active_nuke", "block/tnt")).texture("side", this.modLoc("block/nuke_side_active"));
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent("block/tractor_beam", "block/block")).texture("particle", this.modLoc("block/tractor_beam"))).texture("texture", this.modLoc("block/tractor_beam"))).ao(false)).element().from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 0.0f).shade(false).face(Direction.NORTH).cullface(Direction.NORTH).texture("#texture").end().face(Direction.SOUTH).cullface(Direction.NORTH).texture("#texture").end().end()).element().from(0.0f, 0.0f, 16.0f).to(16.0f, 16.0f, 16.0f).shade(false).face(Direction.NORTH).cullface(Direction.SOUTH).texture("#texture").end().face(Direction.SOUTH).cullface(Direction.SOUTH).texture("#texture").end().end()).element().from(0.0f, 0.0f, 0.0f).to(0.0f, 16.0f, 16.0f).shade(false).face(Direction.WEST).cullface(Direction.WEST).texture("#texture").end().face(Direction.EAST).cullface(Direction.WEST).texture("#texture").end().end()).element().from(16.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f).shade(false).face(Direction.WEST).cullface(Direction.EAST).texture("#texture").end().face(Direction.EAST).cullface(Direction.EAST).texture("#texture").end().end();
            this.electric("basic_generator_off", "basic_generator_front_off", BASIC_SIDE, BASIC_TOP, BASIC_BOTTOM);
            this.electric("basic_generator_on", "basic_generator_front_on", BASIC_SIDE, BASIC_TOP, BASIC_BOTTOM);
            this.electric("geothermal_generator_off", "geothermal_generator_front_off", BASIC_SIDE, BASIC_TOP, BASIC_BOTTOM);
            this.electric("geothermal_generator_on", "geothermal_generator_front_on", BASIC_SIDE, BASIC_TOP, BASIC_BOTTOM);
            this.electric("wind_mill", "wind_mill_front", BASIC_SIDE, BASIC_TOP, BASIC_BOTTOM);
            this.electric("lv_solar_panel", BASIC_SIDE, BASIC_SIDE, "lv_solar_panel_top", BASIC_BOTTOM);
            this.electric("mv_solar_panel", BASIC_SIDE, BASIC_SIDE, "mv_solar_panel_top", BASIC_BOTTOM);
            this.electric("hv_solar_panel", ADVANCED_SIDE, ADVANCED_SIDE, "hv_solar_panel_top", ADVANCED_BOTTOM);
            this.electric("ev_solar_panel", ADVANCED_SIDE, ADVANCED_SIDE, "ev_solar_panel_top", ADVANCED_BOTTOM);
            this.electric("nuclear_reactor_off", "nuclear_reactor_front_off", ADVANCED_SIDE, "nuclear_reactor_top", ADVANCED_BOTTOM);
            this.electric("nuclear_reactor_on", "nuclear_reactor_front_on", ADVANCED_SIDE, "nuclear_reactor_top", ADVANCED_BOTTOM);
            this.electric("powered_furnace_off", "powered_furnace_front_off", BASIC_SIDE, BASIC_TOP, BASIC_BOTTOM);
            this.electric("powered_furnace_on", "powered_furnace_front_on", BASIC_SIDE, BASIC_TOP, BASIC_BOTTOM);
            this.electric("macerator_off", "macerator_front", BASIC_SIDE, "macerator_top_off", BASIC_BOTTOM);
            this.electric("macerator_on", "macerator_front", BASIC_SIDE, "macerator_top_on", BASIC_BOTTOM);
            this.electric("centrifuge_off", "centrifuge_front_off", BASIC_SIDE, "centrifuge_top", BASIC_BOTTOM);
            this.electric("centrifuge_on", "centrifuge_front_on", BASIC_SIDE, "centrifuge_top", BASIC_BOTTOM);
            this.electric("compressor_off", "compressor_front_off", BASIC_SIDE, "compressor_top", BASIC_BOTTOM);
            this.electric("compressor_on", "compressor_front_on", BASIC_SIDE, "compressor_top", BASIC_BOTTOM);
            this.electric("reprocessor_off", "reprocessor_front_off", BASIC_SIDE, "reprocessor_top", BASIC_BOTTOM);
            this.electric("reprocessor_on", "reprocessor_front_on", BASIC_SIDE, "reprocessor_top", BASIC_BOTTOM);
            this.electric("canning_machine_off", "canning_machine_front_off", BASIC_SIDE, BASIC_TOP, BASIC_BOTTOM);
            this.electric("canning_machine_on", "canning_machine_front_on", BASIC_SIDE, BASIC_TOP, BASIC_BOTTOM);
            this.electric("roller_off", "roller_front_off", BASIC_SIDE, BASIC_TOP, BASIC_BOTTOM);
            this.electric("roller_on", "roller_front_on", BASIC_SIDE, BASIC_TOP, BASIC_BOTTOM);
            this.electric("extruder_off", "extruder_front_off", BASIC_SIDE, BASIC_TOP, BASIC_BOTTOM);
            this.electric("extruder_on", "extruder_front_on", BASIC_SIDE, BASIC_TOP, BASIC_BOTTOM);
            this.electric("antimatter_constructor_off", "antimatter_constructor_front_off", "antimatter_constructor_side", ADVANCED_TOP, ADVANCED_BOTTOM);
            this.electric("antimatter_constructor_on", "antimatter_constructor_front_on", "antimatter_constructor_side", ADVANCED_TOP, ADVANCED_BOTTOM);
            this.electric("advanced_powered_furnace_off", "advanced_powered_furnace_front_off", ADVANCED_SIDE, ADVANCED_TOP, ADVANCED_BOTTOM);
            this.electric("advanced_powered_furnace_on", "advanced_powered_furnace_front_on", ADVANCED_SIDE, ADVANCED_TOP, ADVANCED_BOTTOM);
            this.electric("advanced_macerator_off", "advanced_macerator_front", ADVANCED_SIDE, "advanced_macerator_top_off", ADVANCED_BOTTOM);
            this.electric("advanced_macerator_on", "advanced_macerator_front", ADVANCED_SIDE, "advanced_macerator_top_on", ADVANCED_BOTTOM);
            this.electric("advanced_centrifuge_off", "advanced_centrifuge_front_off", ADVANCED_SIDE, "advanced_centrifuge_top", ADVANCED_BOTTOM);
            this.electric("advanced_centrifuge_on", "advanced_centrifuge_front_on", ADVANCED_SIDE, "advanced_centrifuge_top", ADVANCED_BOTTOM);
            this.electric("advanced_compressor_off", "advanced_compressor_front_off", ADVANCED_SIDE, "advanced_compressor_top", ADVANCED_BOTTOM);
            this.electric("advanced_compressor_on", "advanced_compressor_front_on", ADVANCED_SIDE, "advanced_compressor_top", ADVANCED_BOTTOM);
            this.electric("teleporter_off", ADVANCED_SIDE, ADVANCED_SIDE, "teleporter_top_off", ADVANCED_BOTTOM);
            this.electric("teleporter_on", ADVANCED_SIDE, ADVANCED_SIDE, "teleporter_top_on", ADVANCED_BOTTOM);
            this.electric("charge_pad_off", BASIC_SIDE, BASIC_SIDE, "charge_pad_top_off", BASIC_BOTTOM);
            this.electric("charge_pad_on", BASIC_SIDE, BASIC_SIDE, "charge_pad_top_on", BASIC_BOTTOM);
            this.electric("powered_crafting_table", BASIC_SIDE, BASIC_SIDE, "powered_crafting_table_top", BASIC_BOTTOM);
            this.electric("quarry_off", "quarry_front_off", ADVANCED_SIDE, ADVANCED_TOP, ADVANCED_BOTTOM);
            this.electric("quarry_on", "quarry_front_on", ADVANCED_SIDE, ADVANCED_TOP, ADVANCED_BOTTOM);
            this.electric("pump_off", "pump_front_off", ADVANCED_SIDE, ADVANCED_TOP, ADVANCED_BOTTOM);
            this.electric("pump_on", "pump_front_on", ADVANCED_SIDE, ADVANCED_TOP, ADVANCED_BOTTOM);
            this.electric3d("lv_battery_box", "lv_battery_box_out", "lv_battery_box_in");
            this.electric3d("lv_transformer", "lv_transformer_in", "lv_transformer_out");
            this.electric3d("mv_battery_box", "mv_battery_box_out", "mv_battery_box_in");
            this.electric3d("mv_transformer", "mv_transformer_in", "mv_transformer_out");
            this.electric3d("hv_battery_box", "hv_battery_box_out", "hv_battery_box_in");
            this.electric3d("hv_transformer", "hv_transformer_in", "hv_transformer_out");
            this.electric3d("ev_battery_box", "ev_battery_box_out", "ev_battery_box_in");
            this.electric3d("ev_transformer", "ev_transformer_in", "ev_transformer_out");
        }
    }

    private static class FTBICBlockStates
    extends BlockStateProvider {
        public FTBICBlockStates(DataGenerator gen, String modid, ExistingFileHelper exFileHelper) {
            super(gen, modid, exFileHelper);
        }

        protected void registerStatesAndModels() {
            this.simpleBlock(FTBICBlocks.RUBBER_SHEET.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/rubber_sheet")));
            this.simpleBlock(FTBICBlocks.REINFORCED_STONE.get());
            this.simpleBlock(FTBICBlocks.REINFORCED_GLASS.get());
            this.simpleBlock(FTBICBlocks.MACHINE_BLOCK.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/machine_block")));
            this.simpleBlock(FTBICBlocks.ADVANCED_MACHINE_BLOCK.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/advanced_machine_block")));
            this.getVariantBuilder(FTBICBlocks.IRON_FURNACE.get()).forAllStatesExcept(state -> {
                boolean lit = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_);
                Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
                return ConfiguredModel.builder().modelFile((ModelFile)this.models().getExistingFile(this.modLoc(lit ? "block/iron_furnace_on" : "block/iron_furnace_off"))).rotationY(((facing.m_122416_() & 3) * 90 + 180) % 360).build();
            }, new Property[0]);
            for (Supplier<Block> cable : FTBICBlocks.CABLES) {
                BaseCableBlock block = (BaseCableBlock)cable.get();
                String id = Registry.f_122824_.m_7981_((Object)block).m_135815_();
                MultiPartBlockStateBuilder builder = this.getMultipartBuilder(cable.get());
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("block/" + id + "_base"))).addModel()).end();
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("block/" + id + "_connection"))).rotationX(0).rotationY(0).addModel()).condition((Property)CableBlock.CONNECTION[0], (Comparable[])new Boolean[]{true}).end();
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("block/" + id + "_connection"))).rotationX(180).rotationY(0).addModel()).condition((Property)CableBlock.CONNECTION[1], (Comparable[])new Boolean[]{true}).end();
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("block/" + id + "_connection"))).rotationX(90).rotationY(180).addModel()).condition((Property)CableBlock.CONNECTION[2], (Comparable[])new Boolean[]{true}).end();
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("block/" + id + "_connection"))).rotationX(90).rotationY(0).addModel()).condition((Property)CableBlock.CONNECTION[3], (Comparable[])new Boolean[]{true}).end();
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("block/" + id + "_connection"))).rotationX(90).rotationY(90).addModel()).condition((Property)CableBlock.CONNECTION[4], (Comparable[])new Boolean[]{true}).end();
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("block/" + id + "_connection"))).rotationX(90).rotationY(270).addModel()).condition((Property)CableBlock.CONNECTION[5], (Comparable[])new Boolean[]{true}).end();
            }
            this.simpleBlock(FTBICBlocks.LANDMARK.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/landmark")));
            this.simpleBlock(FTBICBlocks.EXFLUID.get(), new ConfiguredModel[]{new ConfiguredModel((ModelFile)this.models().getExistingFile(this.mcLoc("block/dead_horn_coral_block"))), new ConfiguredModel((ModelFile)this.models().getExistingFile(this.mcLoc("block/dead_fire_coral_block"))), new ConfiguredModel((ModelFile)this.models().getExistingFile(this.mcLoc("block/dead_bubble_coral_block"))), new ConfiguredModel((ModelFile)this.models().getExistingFile(this.mcLoc("block/dead_brain_coral_block"))), new ConfiguredModel((ModelFile)this.models().getExistingFile(this.mcLoc("block/dead_tube_coral_block")))});
            this.simpleBlock(FTBICBlocks.NUCLEAR_REACTOR_CHAMBER.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/nuclear_reactor_chamber")));
            this.simpleBlock(FTBICBlocks.NUKE.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/nuke")));
            this.simpleBlock(FTBICBlocks.ACTIVE_NUKE.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/active_nuke")));
            FTBICBlocks.RESOURCE_BLOCKS_OF.values().forEach(e -> this.simpleBlock((Block)e.get()));
            FTBICBlocks.RESOURCE_ORES.forEach((key, value) -> {
                ResourceLocation registryName = Registry.f_122824_.m_7981_((Object)((Block)value.get()));
                String overlayTexture = "block/ore_overlays/" + key.getName().replace("deepslate_", "");
                ((CompositeModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(registryName.m_135815_())).parent((ModelFile)new ModelFile.UncheckedModelFile(this.mcLoc("block/block")))).texture("particle", this.modLoc(overlayTexture))).transforms().transform(ItemTransforms.TransformType.THIRD_PERSON_LEFT_HAND).rotation(75.0f, 45.0f, 0.0f).translation(0.0f, 2.5f, 0.0f).scale(0.375f, 0.375f, 0.375f).end().transform(ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND).rotation(75.0f, 45.0f, 0.0f).translation(0.0f, 2.5f, 0.0f).scale(0.375f, 0.375f, 0.375f).end().end()).customLoader(CompositeModelBuilder::begin)).child("solid", (ModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().nested()).parent((ModelFile)this.models().getExistingFile(key.getName().contains("deepslate") ? this.mcLoc("block/deepslate") : this.mcLoc("block/stone")))).renderType("solid"))).child("translucent", (ModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().nested()).parent((ModelFile)this.models().getExistingFile(this.mcLoc("block/cube_all")))).texture("all", this.modLoc(overlayTexture))).renderType("translucent"))).end();
                this.simpleBlock((Block)value.get(), (ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/" + registryName.m_135815_())));
            });
            for (ElectricBlockInstance machine : FTBICElectricBlocks.ALL) {
                if (machine.noModel) continue;
                this.getVariantBuilder(machine.block.get()).forAllStatesExcept(state -> {
                    boolean on = machine.canBeActive && (Boolean)state.m_61143_((Property)ElectricBlock.ACTIVE) != false;
                    boolean dark = (Boolean)state.m_61143_((Property)SprayPaintable.DARK);
                    ModelFile.ExistingModelFile modelFile = this.models().getExistingFile(this.modLoc("block/electric/" + (dark ? "dark" : "light") + "/" + machine.id + (machine.canBeActive ? (on ? "_on" : "_off") : "")));
                    if (machine.facingProperty == null) {
                        return ConfiguredModel.builder().modelFile((ModelFile)modelFile).build();
                    }
                    if (machine.facingProperty == BlockStateProperties.f_61374_) {
                        Direction facing = (Direction)state.m_61143_((Property)machine.facingProperty);
                        return ConfiguredModel.builder().modelFile((ModelFile)modelFile).rotationY(((facing.m_122416_() & 3) * 90 + 180) % 360).build();
                    }
                    Direction facing = (Direction)state.m_61143_((Property)machine.facingProperty);
                    return ConfiguredModel.builder().modelFile((ModelFile)modelFile).rotationX(facing == Direction.DOWN ? 90 : (facing.m_122434_().m_122479_() ? 0 : 270)).rotationY(facing.m_122434_().m_122478_() ? 0 : ((facing.m_122416_() & 3) * 90 + 180) % 360).build();
                }, new Property[0]);
            }
        }
    }

    private static class FTBICItemModels
    extends ItemModelProvider {
        public FTBICItemModels(DataGenerator generator, String modid, ExistingFileHelper existingFileHelper) {
            super(generator, modid, existingFileHelper);
        }

        private void basicItem(Supplier<? extends Item> item) {
            String id = Registry.f_122827_.m_7981_((Object)item.get()).m_135815_();
            this.singleTexture(id, this.mcLoc("item/generated"), "layer0", this.modLoc("item/" + id));
        }

        private void handheldItem(Supplier<? extends Item> item) {
            String id = Registry.f_122827_.m_7981_((Object)item.get()).m_135815_();
            this.singleTexture(id, this.mcLoc("item/handheld"), "layer0", this.modLoc("item/" + id));
        }

        private void basicBlockItem(Supplier<Block> block) {
            String id = Registry.f_122824_.m_7981_((Object)block.get()).m_135815_();
            this.withExistingParent(id, this.modLoc("block/" + id));
        }

        protected void registerModels() {
            this.basicBlockItem(FTBICBlocks.RUBBER_SHEET);
            this.basicBlockItem(FTBICBlocks.REINFORCED_STONE);
            this.basicBlockItem(FTBICBlocks.REINFORCED_GLASS);
            this.basicBlockItem(FTBICBlocks.MACHINE_BLOCK);
            this.basicBlockItem(FTBICBlocks.ADVANCED_MACHINE_BLOCK);
            this.withExistingParent(Registry.f_122824_.m_7981_((Object)FTBICBlocks.IRON_FURNACE.get()).m_135815_(), this.modLoc("block/iron_furnace_off"));
            for (Supplier<Block> cable : FTBICBlocks.CABLES) {
                String id = Registry.f_122824_.m_7981_((Object)cable.get()).m_135815_();
                int b0 = ((BaseCableBlock)cable.get()).border;
                int b1 = 16 - b0;
                ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent("item/" + id, "block/block")).texture("particle", this.modLoc("block/" + id))).texture("cable", this.modLoc("block/" + id))).transforms().transform(ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND).rotation(75.0f, 45.0f, 0.0f).translation(0.0f, 1.5f, 0.0f).scale(0.375f, 0.375f, 0.375f).end().transform(ItemTransforms.TransformType.THIRD_PERSON_LEFT_HAND).rotation(75.0f, 45.0f, 0.0f).translation(0.0f, 1.5f, 0.0f).scale(0.375f, 0.375f, 0.375f).end().transform(ItemTransforms.TransformType.FIRST_PERSON_RIGHT_HAND).rotation(0.0f, 45.0f, 0.0f).scale(0.4f, 0.4f, 0.4f).end().transform(ItemTransforms.TransformType.FIRST_PERSON_LEFT_HAND).rotation(0.0f, 225.0f, 0.0f).scale(0.4f, 0.4f, 0.4f).end().transform(ItemTransforms.TransformType.GROUND).translation(0.0f, 3.0f, 0.0f).scale(0.25f, 0.25f, 0.25f).end().transform(ItemTransforms.TransformType.GUI).rotation(45.0f, 45.0f, 90.0f).translation(1.75f, 1.0f, 0.0f).scale(0.625f, 0.625f, 0.625f).end().transform(ItemTransforms.TransformType.FIXED).translation(0.0f, -1.5f, 0.0f).scale(0.5f, 0.5f, 0.5f).end().end()).element().from((float)b0, 0.0f, (float)b0).to((float)b1, (float)b1, (float)b1).face(Direction.NORTH).texture("#cable").uvs((float)b0, (float)b0, (float)b1, 16.0f).rotation(ModelBuilder.FaceRotation.UPSIDE_DOWN).end().face(Direction.EAST).texture("#cable").uvs((float)b0, (float)b0, (float)b1, 16.0f).rotation(ModelBuilder.FaceRotation.UPSIDE_DOWN).end().face(Direction.SOUTH).texture("#cable").uvs((float)b0, (float)b0, (float)b1, 16.0f).rotation(ModelBuilder.FaceRotation.UPSIDE_DOWN).end().face(Direction.WEST).texture("#cable").uvs((float)b0, (float)b0, (float)b1, 16.0f).rotation(ModelBuilder.FaceRotation.UPSIDE_DOWN).end().face(Direction.UP).texture("#cable").uvs((float)b0, (float)b0, (float)b1, (float)b1).end().face(Direction.DOWN).texture("#cable").uvs((float)b0, (float)b0, (float)b1, (float)b1).end().end()).element().from((float)b0, (float)b1, (float)b0).to((float)b1, (float)(b1 * 2), (float)b1).face(Direction.NORTH).texture("#cable").uvs((float)b1, 16.0f, (float)b0, (float)b0).rotation(ModelBuilder.FaceRotation.UPSIDE_DOWN).end().face(Direction.EAST).texture("#cable").uvs((float)b1, 16.0f, (float)b0, (float)b0).rotation(ModelBuilder.FaceRotation.UPSIDE_DOWN).end().face(Direction.SOUTH).texture("#cable").uvs((float)b1, 16.0f, (float)b0, (float)b0).rotation(ModelBuilder.FaceRotation.UPSIDE_DOWN).end().face(Direction.WEST).texture("#cable").uvs((float)b1, 16.0f, (float)b0, (float)b0).rotation(ModelBuilder.FaceRotation.UPSIDE_DOWN).end().face(Direction.UP).texture("#cable").uvs((float)b1, (float)b1, (float)b0, (float)b0).end().face(Direction.DOWN).texture("#cable").uvs((float)b1, (float)b1, (float)b0, (float)b0).end().end();
            }
            this.singleTexture("landmark", this.mcLoc("item/generated"), "layer0", this.modLoc("block/landmark_ns"));
            this.withExistingParent(Registry.f_122824_.m_7981_((Object)FTBICBlocks.EXFLUID.get()).m_135815_(), this.mcLoc("block/dead_horn_coral_block"));
            this.basicBlockItem(FTBICBlocks.NUCLEAR_REACTOR_CHAMBER);
            this.basicBlockItem(FTBICBlocks.NUKE);
            this.basicBlockItem(FTBICBlocks.ACTIVE_NUKE);
            for (ElectricBlockInstance machine : FTBICElectricBlocks.ALL) {
                if (machine.noModel) continue;
                this.withExistingParent(machine.id, this.modLoc("block/electric/light/" + machine.id + (machine.canBeActive ? "_off" : "")));
            }
            for (MaterialItem item : FTBICItems.MATERIALS) {
                this.basicItem(item.item);
            }
            this.basicItem(FTBICItems.SINGLE_USE_BATTERY);
            this.basicItem(FTBICItems.LV_BATTERY);
            this.basicItem(FTBICItems.MV_BATTERY);
            this.basicItem(FTBICItems.HV_BATTERY);
            this.basicItem(FTBICItems.EV_BATTERY);
            this.basicItem(FTBICItems.CREATIVE_BATTERY);
            this.basicItem(FTBICItems.SMALL_COOLANT_CELL);
            this.basicItem(FTBICItems.MEDIUM_COOLANT_CELL);
            this.basicItem(FTBICItems.LARGE_COOLANT_CELL);
            this.basicItem(FTBICItems.URANIUM_FUEL_ROD);
            this.basicItem(FTBICItems.DUAL_URANIUM_FUEL_ROD);
            this.basicItem(FTBICItems.QUAD_URANIUM_FUEL_ROD);
            this.basicItem(FTBICItems.HEAT_VENT);
            this.basicItem(FTBICItems.ADVANCED_HEAT_VENT);
            this.basicItem(FTBICItems.OVERCLOCKED_HEAT_VENT);
            this.basicItem(FTBICItems.REACTOR_HEAT_VENT);
            this.basicItem(FTBICItems.COMPONENT_HEAT_VENT);
            this.basicItem(FTBICItems.HEAT_EXCHANGER);
            this.basicItem(FTBICItems.ADVANCED_HEAT_EXCHANGER);
            this.basicItem(FTBICItems.REACTOR_HEAT_EXCHANGER);
            this.basicItem(FTBICItems.COMPONENT_HEAT_EXCHANGER);
            this.basicItem(FTBICItems.REACTOR_PLATING);
            this.basicItem(FTBICItems.CONTAINMENT_REACTOR_PLATING);
            this.basicItem(FTBICItems.HEAT_CAPACITY_REACTOR_PLATING);
            this.basicItem(FTBICItems.NEUTRON_REFLECTOR);
            this.basicItem(FTBICItems.THICK_NEUTRON_REFLECTOR);
            this.basicItem(FTBICItems.IRIDIUM_NEUTRON_REFLECTOR);
            this.basicItem(FTBICItems.CANNED_FOOD);
            this.basicItem(FTBICItems.PROTEIN_BAR);
            this.basicItem(FTBICItems.DARK_SPRAY_PAINT_CAN);
            this.basicItem(FTBICItems.LIGHT_SPRAY_PAINT_CAN);
            this.basicItem(FTBICItems.OVERCLOCKER_UPGRADE);
            this.basicItem(FTBICItems.ENERGY_STORAGE_UPGRADE);
            this.basicItem(FTBICItems.TRANSFORMER_UPGRADE);
            this.basicItem(FTBICItems.EJECTOR_UPGRADE);
            this.basicItem(FTBICItems.MECHANICAL_ELYTRA);
            this.basicItem(FTBICItems.CARBON_HELMET);
            this.basicItem(FTBICItems.CARBON_CHESTPLATE);
            this.basicItem(FTBICItems.CARBON_LEGGINGS);
            this.basicItem(FTBICItems.CARBON_BOOTS);
            this.basicItem(FTBICItems.QUANTUM_HELMET);
            this.basicItem(FTBICItems.QUANTUM_CHESTPLATE);
            this.basicItem(FTBICItems.QUANTUM_LEGGINGS);
            this.basicItem(FTBICItems.QUANTUM_BOOTS);
            this.basicItem(FTBICItems.NUKE_ARROW);
            FTBICBlocks.RESOURCE_ORES.values().forEach(this::basicBlockItem);
            FTBICBlocks.RESOURCE_BLOCKS_OF.values().forEach(this::basicBlockItem);
            FTBICItems.RESOURCE_TYPE_MAP.forEach((k, v) -> {
                if (k.equals((Object)ResourceType.ORE) || k.equals((Object)ResourceType.BLOCK)) {
                    return;
                }
                v.forEach((k2, v2) -> this.basicItem((Supplier<? extends Item>)v2));
            });
        }
    }

    private static class ICBlockTags
    extends BlockTagsProvider {
        public ICBlockTags(DataGenerator generatorIn, String modId, ExistingFileHelper existingFileHelper) {
            super(generatorIn, modId, existingFileHelper);
        }

        protected void m_6577_() {
            this.m_206424_(FTBICUtils.REINFORCED).m_126584_((Object[])new Block[]{FTBICBlocks.REINFORCED_STONE.get(), FTBICBlocks.REINFORCED_GLASS.get(), Blocks.f_50752_, Blocks.f_50375_, Blocks.f_50272_});
            this.m_206424_(BlockTags.f_13069_).m_126584_((Object[])new Block[]{FTBICBlocks.REINFORCED_STONE.get(), FTBICBlocks.REINFORCED_GLASS.get()});
            this.m_206424_(BlockTags.f_13070_).m_126584_((Object[])new Block[]{FTBICBlocks.REINFORCED_STONE.get(), FTBICBlocks.REINFORCED_GLASS.get()});
            Object[] resourceOres = (Block[])FTBICBlocks.RESOURCE_ORES.values().stream().map(Supplier::get).toArray(Block[]::new);
            Object[] blockOfResources = (Block[])FTBICBlocks.RESOURCE_BLOCKS_OF.values().stream().map(Supplier::get).toArray(Block[]::new);
            this.m_206424_(BlockTags.f_144282_).m_126584_(resourceOres);
            this.m_206424_(BlockTags.f_144282_).m_126584_(blockOfResources);
            this.m_206424_(BlockTags.f_144282_).m_126584_((Object[])new Block[]{FTBICBlocks.ADVANCED_MACHINE_BLOCK.get(), FTBICBlocks.MACHINE_BLOCK.get(), FTBICBlocks.REINFORCED_GLASS.get(), FTBICBlocks.REINFORCED_STONE.get(), FTBICBlocks.IRON_FURNACE.get(), FTBICBlocks.NUCLEAR_REACTOR_CHAMBER.get(), FTBICBlocks.RUBBER_SHEET.get(), FTBICBlocks.BURNT_CABLE.get(), FTBICBlocks.LANDMARK.get(), FTBICBlocks.EXFLUID.get(), FTBICBlocks.NUKE.get()});
            Object[] cables = (Block[])FTBICBlocks.CABLES.stream().map(Supplier::get).toArray(Block[]::new);
            this.m_206424_(BlockTags.f_144282_).m_126584_(cables);
            Object[] blocks = (Block[])FTBICElectricBlocks.ALL.stream().map(e -> e.block.get()).toArray(Block[]::new);
            this.m_206424_(BlockTags.f_144282_).m_126584_(blocks);
            FTBICBlocks.RESOURCE_ORES.forEach((k, v) -> {
                String name = k.getName().replace("deepslate_", "");
                this.m_206424_(TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)new ResourceLocation("forge", "ores/" + name))).m_126582_((Object)FTBICBlocks.RESOURCE_ORES.get(k).get());
            });
            this.m_206424_(Tags.Blocks.ORES).m_126584_(resourceOres);
        }
    }

    private static class FTBICItemTags
    extends ItemTagsProvider {
        public FTBICItemTags(DataGenerator dataGenerator, BlockTagsProvider blockTagProvider, String modId, ExistingFileHelper existingFileHelper) {
            super(dataGenerator, blockTagProvider, modId, existingFileHelper);
        }

        protected void m_6577_() {
            this.m_206424_(FTBICUtils.UNCANNABLE_FOOD).m_126584_((Object[])new Item[]{FTBICItems.CANNED_FOOD.get(), FTBICItems.PROTEIN_BAR.get()});
            this.m_206424_(ItemTags.f_13161_).m_126582_((Object)FTBICItems.NUKE_ARROW.get());
            this.m_206424_(FTBICRecipesGen.TIN_INGOT).m_126582_((Object)FTBICItems.getResourceFromType(ResourceElements.TIN, ResourceType.INGOT).orElseThrow().get());
            this.m_206424_(FTBICRecipesGen.LEAD_INGOT).m_126582_((Object)FTBICItems.getResourceFromType(ResourceElements.LEAD, ResourceType.INGOT).orElseThrow().get());
            this.m_206424_(FTBICRecipesGen.URANIUM_INGOT).m_126582_((Object)FTBICItems.getResourceFromType(ResourceElements.URANIUM, ResourceType.INGOT).orElseThrow().get());
            this.m_206424_(FTBICRecipesGen.IRIDIUM_INGOT).m_126582_((Object)FTBICItems.getResourceFromType(ResourceElements.IRIDIUM, ResourceType.INGOT).orElseThrow().get());
            this.m_206424_(FTBICRecipesGen.ENDERIUM_INGOT).m_126582_((Object)FTBICItems.getResourceFromType(ResourceElements.ENDERIUM, ResourceType.INGOT).orElseThrow().get());
            this.m_206424_(FTBICRecipesGen.ALUMINUM_INGOT).m_126582_((Object)FTBICItems.getResourceFromType(ResourceElements.ALUMINUM, ResourceType.INGOT).orElseThrow().get());
            this.m_206424_(FTBICRecipesGen.BRONZE_INGOT).m_126582_((Object)FTBICItems.getResourceFromType(ResourceElements.BRONZE, ResourceType.INGOT).orElseThrow().get());
            this.m_206424_(Tags.Items.INGOTS).m_206428_(FTBICRecipesGen.TIN_INGOT);
            this.m_206424_(Tags.Items.INGOTS).m_206428_(FTBICRecipesGen.LEAD_INGOT);
            this.m_206424_(Tags.Items.INGOTS).m_206428_(FTBICRecipesGen.URANIUM_INGOT);
            this.m_206424_(Tags.Items.INGOTS).m_206428_(FTBICRecipesGen.IRIDIUM_INGOT);
            this.m_206424_(Tags.Items.INGOTS).m_206428_(FTBICRecipesGen.ENDERIUM_INGOT);
            this.m_206424_(Tags.Items.INGOTS).m_206428_(FTBICRecipesGen.ALUMINUM_INGOT);
            this.m_206424_(Tags.Items.INGOTS).m_206428_(FTBICRecipesGen.BRONZE_INGOT);
            this.m_206424_(FTBICRecipesGen.TIN_BLOCK).m_126582_((Object)FTBICItems.getResourceFromType(ResourceElements.TIN, ResourceType.BLOCK).orElseThrow().get());
            this.m_206424_(FTBICRecipesGen.LEAD_BLOCK).m_126582_((Object)FTBICItems.getResourceFromType(ResourceElements.LEAD, ResourceType.BLOCK).orElseThrow().get());
            this.m_206424_(FTBICRecipesGen.URANIUM_BLOCK).m_126582_((Object)FTBICItems.getResourceFromType(ResourceElements.URANIUM, ResourceType.BLOCK).orElseThrow().get());
            this.m_206424_(FTBICRecipesGen.IRIDIUM_BLOCK).m_126582_((Object)FTBICItems.getResourceFromType(ResourceElements.IRIDIUM, ResourceType.BLOCK).orElseThrow().get());
            this.m_206424_(FTBICRecipesGen.ENDERIUM_BLOCK).m_126582_((Object)FTBICItems.getResourceFromType(ResourceElements.ENDERIUM, ResourceType.BLOCK).orElseThrow().get());
            this.m_206424_(FTBICRecipesGen.ALUMINUM_BLOCK).m_126582_((Object)FTBICItems.getResourceFromType(ResourceElements.ALUMINUM, ResourceType.BLOCK).orElseThrow().get());
            this.m_206424_(FTBICRecipesGen.BRONZE_BLOCK).m_126582_((Object)FTBICItems.getResourceFromType(ResourceElements.BRONZE, ResourceType.BLOCK).orElseThrow().get());
            this.m_206424_(Tags.Items.STORAGE_BLOCKS).m_206428_(FTBICRecipesGen.TIN_BLOCK);
            this.m_206424_(Tags.Items.STORAGE_BLOCKS).m_206428_(FTBICRecipesGen.LEAD_BLOCK);
            this.m_206424_(Tags.Items.STORAGE_BLOCKS).m_206428_(FTBICRecipesGen.URANIUM_BLOCK);
            this.m_206424_(Tags.Items.STORAGE_BLOCKS).m_206428_(FTBICRecipesGen.IRIDIUM_BLOCK);
            this.m_206424_(Tags.Items.STORAGE_BLOCKS).m_206428_(FTBICRecipesGen.ENDERIUM_BLOCK);
            this.m_206424_(Tags.Items.STORAGE_BLOCKS).m_206428_(FTBICRecipesGen.ALUMINUM_BLOCK);
            this.m_206424_(Tags.Items.STORAGE_BLOCKS).m_206428_(FTBICRecipesGen.BRONZE_BLOCK);
            this.m_206424_(FTBICRecipesGen.TIN_CHUNK).m_126582_((Object)FTBICItems.getResourceFromType(ResourceElements.TIN, ResourceType.CHUNK).orElseThrow().get());
            this.m_206424_(FTBICRecipesGen.LEAD_CHUNK).m_126582_((Object)FTBICItems.getResourceFromType(ResourceElements.LEAD, ResourceType.CHUNK).orElseThrow().get());
            this.m_206424_(FTBICRecipesGen.URANIUM_CHUNK).m_126582_((Object)FTBICItems.getResourceFromType(ResourceElements.URANIUM, ResourceType.CHUNK).orElseThrow().get());
            this.m_206424_(FTBICRecipesGen.IRIDIUM_CHUNK).m_126582_((Object)FTBICItems.getResourceFromType(ResourceElements.IRIDIUM, ResourceType.CHUNK).orElseThrow().get());
            this.m_206424_(FTBICRecipesGen.ALUMINUM_CHUNK).m_126582_((Object)FTBICItems.getResourceFromType(ResourceElements.ALUMINUM, ResourceType.CHUNK).orElseThrow().get());
            this.m_206424_(Tags.Items.RAW_MATERIALS).m_206428_(FTBICRecipesGen.TIN_CHUNK);
            this.m_206424_(Tags.Items.RAW_MATERIALS).m_206428_(FTBICRecipesGen.LEAD_CHUNK);
            this.m_206424_(Tags.Items.RAW_MATERIALS).m_206428_(FTBICRecipesGen.URANIUM_CHUNK);
            this.m_206424_(Tags.Items.RAW_MATERIALS).m_206428_(FTBICRecipesGen.IRIDIUM_CHUNK);
            this.m_206424_(Tags.Items.RAW_MATERIALS).m_206428_(FTBICRecipesGen.ALUMINUM_CHUNK);
            this.m_206424_(FTBICRecipesGen.TIN_DUST).m_126582_((Object)FTBICItems.getResourceFromType(ResourceElements.TIN, ResourceType.DUST).orElseThrow().get());
            this.m_206424_(FTBICRecipesGen.LEAD_DUST).m_126582_((Object)FTBICItems.getResourceFromType(ResourceElements.LEAD, ResourceType.DUST).orElseThrow().get());
            this.m_206424_(FTBICRecipesGen.URANIUM_DUST).m_126582_((Object)FTBICItems.getResourceFromType(ResourceElements.URANIUM, ResourceType.DUST).orElseThrow().get());
            this.m_206424_(FTBICRecipesGen.IRIDIUM_DUST).m_126582_((Object)FTBICItems.getResourceFromType(ResourceElements.IRIDIUM, ResourceType.DUST).orElseThrow().get());
            this.m_206424_(FTBICRecipesGen.ENDERIUM_DUST).m_126582_((Object)FTBICItems.getResourceFromType(ResourceElements.ENDERIUM, ResourceType.DUST).orElseThrow().get());
            this.m_206424_(FTBICRecipesGen.ALUMINUM_DUST).m_126582_((Object)FTBICItems.getResourceFromType(ResourceElements.ALUMINUM, ResourceType.DUST).orElseThrow().get());
            this.m_206424_(FTBICRecipesGen.DIAMOND_DUST).m_126582_((Object)FTBICItems.getResourceFromType(ResourceElements.DIAMOND, ResourceType.DUST).orElseThrow().get());
            this.m_206424_(FTBICRecipesGen.IRON_DUST).m_126582_((Object)FTBICItems.getResourceFromType(ResourceElements.IRON, ResourceType.DUST).orElseThrow().get());
            this.m_206424_(FTBICRecipesGen.COPPER_DUST).m_126582_((Object)FTBICItems.getResourceFromType(ResourceElements.COPPER, ResourceType.DUST).orElseThrow().get());
            this.m_206424_(FTBICRecipesGen.GOLD_DUST).m_126582_((Object)FTBICItems.getResourceFromType(ResourceElements.GOLD, ResourceType.DUST).orElseThrow().get());
            this.m_206424_(FTBICRecipesGen.BRONZE_DUST).m_126582_((Object)FTBICItems.getResourceFromType(ResourceElements.BRONZE, ResourceType.DUST).orElseThrow().get());
            this.m_206424_(FTBICRecipesGen.OBSIDIAN_DUST).m_126582_((Object)FTBICItems.getResourceFromType(ResourceElements.OBSIDIAN, ResourceType.DUST).orElseThrow().get());
            this.m_206424_(FTBICRecipesGen.COAL_DUST).m_126582_((Object)FTBICItems.getResourceFromType(ResourceElements.COAL, ResourceType.DUST).orElseThrow().get());
            this.m_206424_(FTBICRecipesGen.CHARCOAL_DUST).m_126582_((Object)FTBICItems.getResourceFromType(ResourceElements.CHARCOAL, ResourceType.DUST).orElseThrow().get());
            this.m_206424_(FTBICRecipesGen.ENDER_DUST).m_126582_((Object)FTBICItems.getResourceFromType(ResourceElements.ENDER, ResourceType.DUST).orElseThrow().get());
            this.m_206424_(Tags.Items.DUSTS).m_206428_(FTBICRecipesGen.TIN_DUST);
            this.m_206424_(Tags.Items.DUSTS).m_206428_(FTBICRecipesGen.LEAD_DUST);
            this.m_206424_(Tags.Items.DUSTS).m_206428_(FTBICRecipesGen.URANIUM_DUST);
            this.m_206424_(Tags.Items.DUSTS).m_206428_(FTBICRecipesGen.IRIDIUM_DUST);
            this.m_206424_(Tags.Items.DUSTS).m_206428_(FTBICRecipesGen.ENDERIUM_DUST);
            this.m_206424_(Tags.Items.DUSTS).m_206428_(FTBICRecipesGen.ALUMINUM_DUST);
            this.m_206424_(Tags.Items.DUSTS).m_206428_(FTBICRecipesGen.DIAMOND_DUST);
            this.m_206424_(Tags.Items.DUSTS).m_206428_(FTBICRecipesGen.IRON_DUST);
            this.m_206424_(Tags.Items.DUSTS).m_206428_(FTBICRecipesGen.COPPER_DUST);
            this.m_206424_(Tags.Items.DUSTS).m_206428_(FTBICRecipesGen.GOLD_DUST);
            this.m_206424_(Tags.Items.DUSTS).m_206428_(FTBICRecipesGen.BRONZE_DUST);
            this.m_206424_(Tags.Items.DUSTS).m_206428_(FTBICRecipesGen.OBSIDIAN_DUST);
            this.m_206424_(Tags.Items.DUSTS).m_206428_(FTBICRecipesGen.COAL_DUST);
            this.m_206424_(Tags.Items.DUSTS).m_206428_(FTBICRecipesGen.CHARCOAL_DUST);
            this.m_206424_(Tags.Items.DUSTS).m_206428_(FTBICRecipesGen.ENDER_DUST);
            this.m_206424_(FTBICRecipesGen.TIN_PLATE).m_126582_((Object)FTBICItems.getResourceFromType(ResourceElements.TIN, ResourceType.PLATE).orElseThrow().get());
            this.m_206424_(FTBICRecipesGen.LEAD_PLATE).m_126582_((Object)FTBICItems.getResourceFromType(ResourceElements.LEAD, ResourceType.PLATE).orElseThrow().get());
            this.m_206424_(FTBICRecipesGen.URANIUM_PLATE).m_126582_((Object)FTBICItems.getResourceFromType(ResourceElements.URANIUM, ResourceType.PLATE).orElseThrow().get());
            this.m_206424_(FTBICRecipesGen.IRIDIUM_PLATE).m_126582_((Object)FTBICItems.getResourceFromType(ResourceElements.IRIDIUM, ResourceType.PLATE).orElseThrow().get());
            this.m_206424_(FTBICRecipesGen.ENDERIUM_PLATE).m_126582_((Object)FTBICItems.getResourceFromType(ResourceElements.ENDERIUM, ResourceType.PLATE).orElseThrow().get());
            this.m_206424_(FTBICRecipesGen.ALUMINUM_PLATE).m_126582_((Object)FTBICItems.getResourceFromType(ResourceElements.ALUMINUM, ResourceType.PLATE).orElseThrow().get());
            this.m_206424_(FTBICRecipesGen.IRON_PLATE).m_126582_((Object)FTBICItems.getResourceFromType(ResourceElements.IRON, ResourceType.PLATE).orElseThrow().get());
            this.m_206424_(FTBICRecipesGen.GOLD_PLATE).m_126582_((Object)FTBICItems.getResourceFromType(ResourceElements.GOLD, ResourceType.PLATE).orElseThrow().get());
            this.m_206424_(FTBICRecipesGen.COPPER_PLATE).m_126582_((Object)FTBICItems.getResourceFromType(ResourceElements.COPPER, ResourceType.PLATE).orElseThrow().get());
            this.m_206424_(FTBICRecipesGen.BRONZE_PLATE).m_126582_((Object)FTBICItems.getResourceFromType(ResourceElements.BRONZE, ResourceType.PLATE).orElseThrow().get());
            this.m_206424_(FTBICRecipesGen.PLATES).m_206428_(FTBICRecipesGen.TIN_PLATE);
            this.m_206424_(FTBICRecipesGen.PLATES).m_206428_(FTBICRecipesGen.LEAD_PLATE);
            this.m_206424_(FTBICRecipesGen.PLATES).m_206428_(FTBICRecipesGen.URANIUM_PLATE);
            this.m_206424_(FTBICRecipesGen.PLATES).m_206428_(FTBICRecipesGen.IRIDIUM_PLATE);
            this.m_206424_(FTBICRecipesGen.PLATES).m_206428_(FTBICRecipesGen.ENDERIUM_PLATE);
            this.m_206424_(FTBICRecipesGen.PLATES).m_206428_(FTBICRecipesGen.ALUMINUM_PLATE);
            this.m_206424_(FTBICRecipesGen.PLATES).m_206428_(FTBICRecipesGen.IRON_PLATE);
            this.m_206424_(FTBICRecipesGen.PLATES).m_206428_(FTBICRecipesGen.GOLD_PLATE);
            this.m_206424_(FTBICRecipesGen.PLATES).m_206428_(FTBICRecipesGen.COPPER_PLATE);
            this.m_206424_(FTBICRecipesGen.PLATES).m_206428_(FTBICRecipesGen.BRONZE_PLATE);
            this.m_206424_(FTBICRecipesGen.TIN_NUGGET).m_126582_((Object)FTBICItems.getResourceFromType(ResourceElements.TIN, ResourceType.NUGGET).orElseThrow().get());
            this.m_206424_(FTBICRecipesGen.LEAD_NUGGET).m_126582_((Object)FTBICItems.getResourceFromType(ResourceElements.LEAD, ResourceType.NUGGET).orElseThrow().get());
            this.m_206424_(FTBICRecipesGen.URANIUM_NUGGET).m_126582_((Object)FTBICItems.getResourceFromType(ResourceElements.URANIUM, ResourceType.NUGGET).orElseThrow().get());
            this.m_206424_(FTBICRecipesGen.IRIDIUM_NUGGET).m_126582_((Object)FTBICItems.getResourceFromType(ResourceElements.IRIDIUM, ResourceType.NUGGET).orElseThrow().get());
            this.m_206424_(FTBICRecipesGen.ENDERIUM_NUGGET).m_126582_((Object)FTBICItems.getResourceFromType(ResourceElements.ENDERIUM, ResourceType.NUGGET).orElseThrow().get());
            this.m_206424_(FTBICRecipesGen.ALUMINUM_NUGGET).m_126582_((Object)FTBICItems.getResourceFromType(ResourceElements.ALUMINUM, ResourceType.NUGGET).orElseThrow().get());
            this.m_206424_(FTBICRecipesGen.COPPER_NUGGET).m_126582_((Object)FTBICItems.getResourceFromType(ResourceElements.COPPER, ResourceType.NUGGET).orElseThrow().get());
            this.m_206424_(FTBICRecipesGen.BRONZE_NUGGET).m_126582_((Object)FTBICItems.getResourceFromType(ResourceElements.BRONZE, ResourceType.NUGGET).orElseThrow().get());
            this.m_206424_(Tags.Items.NUGGETS).m_206428_(FTBICRecipesGen.TIN_NUGGET);
            this.m_206424_(Tags.Items.NUGGETS).m_206428_(FTBICRecipesGen.LEAD_NUGGET);
            this.m_206424_(Tags.Items.NUGGETS).m_206428_(FTBICRecipesGen.URANIUM_NUGGET);
            this.m_206424_(Tags.Items.NUGGETS).m_206428_(FTBICRecipesGen.IRIDIUM_NUGGET);
            this.m_206424_(Tags.Items.NUGGETS).m_206428_(FTBICRecipesGen.ENDERIUM_NUGGET);
            this.m_206424_(Tags.Items.NUGGETS).m_206428_(FTBICRecipesGen.ALUMINUM_NUGGET);
            this.m_206424_(Tags.Items.NUGGETS).m_206428_(FTBICRecipesGen.COPPER_NUGGET);
            this.m_206424_(Tags.Items.NUGGETS).m_206428_(FTBICRecipesGen.BRONZE_NUGGET);
            this.m_206424_(FTBICRecipesGen.TIN_ROD).m_126582_((Object)FTBICItems.getResourceFromType(ResourceElements.TIN, ResourceType.ROD).orElseThrow().get());
            this.m_206424_(FTBICRecipesGen.LEAD_ROD).m_126582_((Object)FTBICItems.getResourceFromType(ResourceElements.LEAD, ResourceType.ROD).orElseThrow().get());
            this.m_206424_(FTBICRecipesGen.URANIUM_ROD).m_126582_((Object)FTBICItems.getResourceFromType(ResourceElements.URANIUM, ResourceType.ROD).orElseThrow().get());
            this.m_206424_(FTBICRecipesGen.IRIDIUM_ROD).m_126582_((Object)FTBICItems.getResourceFromType(ResourceElements.IRIDIUM, ResourceType.ROD).orElseThrow().get());
            this.m_206424_(FTBICRecipesGen.ENDERIUM_ROD).m_126582_((Object)FTBICItems.getResourceFromType(ResourceElements.ENDERIUM, ResourceType.ROD).orElseThrow().get());
            this.m_206424_(FTBICRecipesGen.ALUMINUM_ROD).m_126582_((Object)FTBICItems.getResourceFromType(ResourceElements.ALUMINUM, ResourceType.ROD).orElseThrow().get());
            this.m_206424_(FTBICRecipesGen.IRON_ROD).m_126582_((Object)FTBICItems.getResourceFromType(ResourceElements.IRON, ResourceType.ROD).orElseThrow().get());
            this.m_206424_(FTBICRecipesGen.COPPER_ROD).m_126582_((Object)FTBICItems.getResourceFromType(ResourceElements.COPPER, ResourceType.ROD).orElseThrow().get());
            this.m_206424_(FTBICRecipesGen.GOLD_ROD).m_126582_((Object)FTBICItems.getResourceFromType(ResourceElements.GOLD, ResourceType.ROD).orElseThrow().get());
            this.m_206424_(FTBICRecipesGen.BRONZE_ROD).m_126582_((Object)FTBICItems.getResourceFromType(ResourceElements.BRONZE, ResourceType.ROD).orElseThrow().get());
            this.m_206424_(FTBICRecipesGen.RODS).m_206428_(FTBICRecipesGen.TIN_ROD);
            this.m_206424_(FTBICRecipesGen.RODS).m_206428_(FTBICRecipesGen.LEAD_ROD);
            this.m_206424_(FTBICRecipesGen.RODS).m_206428_(FTBICRecipesGen.URANIUM_ROD);
            this.m_206424_(FTBICRecipesGen.RODS).m_206428_(FTBICRecipesGen.IRIDIUM_ROD);
            this.m_206424_(FTBICRecipesGen.RODS).m_206428_(FTBICRecipesGen.ENDERIUM_ROD);
            this.m_206424_(FTBICRecipesGen.RODS).m_206428_(FTBICRecipesGen.ALUMINUM_ROD);
            this.m_206424_(FTBICRecipesGen.RODS).m_206428_(FTBICRecipesGen.IRON_ROD);
            this.m_206424_(FTBICRecipesGen.RODS).m_206428_(FTBICRecipesGen.COPPER_ROD);
            this.m_206424_(FTBICRecipesGen.RODS).m_206428_(FTBICRecipesGen.GOLD_ROD);
            this.m_206424_(FTBICRecipesGen.RODS).m_206428_(FTBICRecipesGen.BRONZE_ROD);
            this.m_206424_(FTBICRecipesGen.TIN_GEAR).m_126582_((Object)FTBICItems.getResourceFromType(ResourceElements.TIN, ResourceType.GEAR).orElseThrow().get());
            this.m_206424_(FTBICRecipesGen.LEAD_GEAR).m_126582_((Object)FTBICItems.getResourceFromType(ResourceElements.LEAD, ResourceType.GEAR).orElseThrow().get());
            this.m_206424_(FTBICRecipesGen.URANIUM_GEAR).m_126582_((Object)FTBICItems.getResourceFromType(ResourceElements.URANIUM, ResourceType.GEAR).orElseThrow().get());
            this.m_206424_(FTBICRecipesGen.IRIDIUM_GEAR).m_126582_((Object)FTBICItems.getResourceFromType(ResourceElements.IRIDIUM, ResourceType.GEAR).orElseThrow().get());
            this.m_206424_(FTBICRecipesGen.ENDERIUM_GEAR).m_126582_((Object)FTBICItems.getResourceFromType(ResourceElements.ENDERIUM, ResourceType.GEAR).orElseThrow().get());
            this.m_206424_(FTBICRecipesGen.ALUMINUM_GEAR).m_126582_((Object)FTBICItems.getResourceFromType(ResourceElements.ALUMINUM, ResourceType.GEAR).orElseThrow().get());
            this.m_206424_(FTBICRecipesGen.IRON_GEAR).m_126582_((Object)FTBICItems.getResourceFromType(ResourceElements.IRON, ResourceType.GEAR).orElseThrow().get());
            this.m_206424_(FTBICRecipesGen.GOLD_GEAR).m_126582_((Object)FTBICItems.getResourceFromType(ResourceElements.GOLD, ResourceType.GEAR).orElseThrow().get());
            this.m_206424_(FTBICRecipesGen.COPPER_GEAR).m_126582_((Object)FTBICItems.getResourceFromType(ResourceElements.COPPER, ResourceType.GEAR).orElseThrow().get());
            this.m_206424_(FTBICRecipesGen.BRONZE_GEAR).m_126582_((Object)FTBICItems.getResourceFromType(ResourceElements.BRONZE, ResourceType.GEAR).orElseThrow().get());
            this.m_206424_(FTBICRecipesGen.GEARS).m_206428_(FTBICRecipesGen.TIN_GEAR);
            this.m_206424_(FTBICRecipesGen.GEARS).m_206428_(FTBICRecipesGen.LEAD_GEAR);
            this.m_206424_(FTBICRecipesGen.GEARS).m_206428_(FTBICRecipesGen.URANIUM_GEAR);
            this.m_206424_(FTBICRecipesGen.GEARS).m_206428_(FTBICRecipesGen.IRIDIUM_GEAR);
            this.m_206424_(FTBICRecipesGen.GEARS).m_206428_(FTBICRecipesGen.ENDERIUM_GEAR);
            this.m_206424_(FTBICRecipesGen.GEARS).m_206428_(FTBICRecipesGen.ALUMINUM_GEAR);
            this.m_206424_(FTBICRecipesGen.GEARS).m_206428_(FTBICRecipesGen.IRON_GEAR);
            this.m_206424_(FTBICRecipesGen.GEARS).m_206428_(FTBICRecipesGen.GOLD_GEAR);
            this.m_206424_(FTBICRecipesGen.GEARS).m_206428_(FTBICRecipesGen.COPPER_GEAR);
            this.m_206424_(FTBICRecipesGen.GEARS).m_206428_(FTBICRecipesGen.BRONZE_GEAR);
            this.m_206424_(FTBICRecipesGen.TIN_ORE).m_126582_((Object)FTBICItems.getResourceFromType(ResourceElements.TIN, ResourceType.ORE).orElseThrow().get());
            this.m_206424_(FTBICRecipesGen.TIN_ORE).m_126582_((Object)FTBICItems.getResourceFromType(ResourceElements.DEEPSLATE_TIN, ResourceType.ORE).orElseThrow().get());
            this.m_206424_(FTBICRecipesGen.LEAD_ORE).m_126582_((Object)FTBICItems.getResourceFromType(ResourceElements.LEAD, ResourceType.ORE).orElseThrow().get());
            this.m_206424_(FTBICRecipesGen.LEAD_ORE).m_126582_((Object)FTBICItems.getResourceFromType(ResourceElements.DEEPSLATE_LEAD, ResourceType.ORE).orElseThrow().get());
            this.m_206424_(FTBICRecipesGen.URANIUM_ORE).m_126582_((Object)FTBICItems.getResourceFromType(ResourceElements.URANIUM, ResourceType.ORE).orElseThrow().get());
            this.m_206424_(FTBICRecipesGen.URANIUM_ORE).m_126582_((Object)FTBICItems.getResourceFromType(ResourceElements.DEEPSLATE_URANIUM, ResourceType.ORE).orElseThrow().get());
            this.m_206424_(FTBICRecipesGen.IRIDIUM_ORE).m_126582_((Object)FTBICItems.getResourceFromType(ResourceElements.IRIDIUM, ResourceType.ORE).orElseThrow().get());
            this.m_206424_(FTBICRecipesGen.IRIDIUM_ORE).m_126582_((Object)FTBICItems.getResourceFromType(ResourceElements.DEEPSLATE_IRIDIUM, ResourceType.ORE).orElseThrow().get());
            this.m_206424_(FTBICRecipesGen.ALUMINUM_ORE).m_126582_((Object)FTBICItems.getResourceFromType(ResourceElements.ALUMINUM, ResourceType.ORE).orElseThrow().get());
            this.m_206424_(FTBICRecipesGen.ALUMINUM_ORE).m_126582_((Object)FTBICItems.getResourceFromType(ResourceElements.DEEPSLATE_ALUMINUM, ResourceType.ORE).orElseThrow().get());
            this.m_206424_(Tags.Items.ORES).m_206428_(FTBICRecipesGen.TIN_ORE);
            this.m_206424_(Tags.Items.ORES).m_206428_(FTBICRecipesGen.LEAD_ORE);
            this.m_206424_(Tags.Items.ORES).m_206428_(FTBICRecipesGen.URANIUM_ORE);
            this.m_206424_(Tags.Items.ORES).m_206428_(FTBICRecipesGen.IRIDIUM_ORE);
            this.m_206424_(Tags.Items.ORES).m_206428_(FTBICRecipesGen.ALUMINUM_ORE);
            this.m_206424_(FTBICRecipesGen.SILICON).m_126582_((Object)FTBICRecipesGen.SILICON_ITEM.get());
        }
    }

    private static class ICBiomeTags
    extends BiomeTagsProvider {
        public ICBiomeTags(DataGenerator generatorIn, String modId, ExistingFileHelper existingFileHelper) {
            super(generatorIn, modId, existingFileHelper);
        }

        protected void m_6577_() {
            this.m_206424_(dev.ftb.mods.ftbic.world.ICBiomeTags.ORE_SPAWN_BLACKLIST).addTags(new TagKey[]{BiomeTags.f_215818_, BiomeTags.f_207612_});
        }
    }

    private static class FTBICLootTableProvider
    extends LootTableProvider {
        private final List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> lootTables = Lists.newArrayList((Object[])new Pair[]{Pair.of(FTBICBlockLootTableProvider::new, (Object)LootContextParamSets.f_81421_)});

        public FTBICLootTableProvider(DataGenerator dataGeneratorIn) {
            super(dataGeneratorIn);
        }

        protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext validationtracker) {
        }

        protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> getTables() {
            return this.lootTables;
        }
    }

    public static class FTBICBlockLootTableProvider
    extends BlockLoot {
        private final Map<ResourceLocation, LootTable.Builder> tables = Maps.newHashMap();

        protected void addTables() {
            this.m_124288_(FTBICBlocks.RUBBER_SHEET.get());
            this.m_124288_(FTBICBlocks.REINFORCED_STONE.get());
            this.m_124288_(FTBICBlocks.REINFORCED_GLASS.get());
            this.m_124288_(FTBICBlocks.MACHINE_BLOCK.get());
            this.m_124288_(FTBICBlocks.ADVANCED_MACHINE_BLOCK.get());
            this.m_124288_(FTBICBlocks.IRON_FURNACE.get());
            for (Supplier<Block> cable : FTBICBlocks.CABLES) {
                this.m_124288_(cable.get());
            }
            this.m_124288_(FTBICBlocks.LANDMARK.get());
            this.m_124288_(FTBICBlocks.NUCLEAR_REACTOR_CHAMBER.get());
            this.m_124288_(FTBICBlocks.NUKE.get());
            FTBICBlocks.RESOURCE_BLOCKS_OF.forEach((k, v) -> this.m_124288_((Block)v.get()));
            FTBICBlocks.RESOURCE_ORES.forEach((k, v) -> ResourceElements.getNonDeepslateVersion(k).ifPresent(arg_0 -> this.lambda$addTables$1((Supplier)v, arg_0)));
            for (ElectricBlockInstance machine : FTBICElectricBlocks.ALL) {
                if (machine.canBurn) {
                    this.m_124165_(machine.block.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79080_(new BurntBlockCondition.Builder().m_81807_()).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)machine.item.get())))).m_79161_(LootPool.m_79043_().m_79080_((LootItemCondition.Builder)new BurntBlockCondition.Builder()).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)(machine.advanced ? (ItemLike)FTBICItems.ADVANCED_MACHINE_BLOCK.get() : (ItemLike)FTBICItems.MACHINE_BLOCK.get())))));
                    continue;
                }
                this.m_124288_(machine.block.get());
            }
        }

        public void accept(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
            this.addTables();
            for (ResourceLocation rs : new ArrayList<ResourceLocation>(this.tables.keySet())) {
                if (rs == BuiltInLootTables.f_78712_) continue;
                LootTable.Builder builder = this.tables.remove(rs);
                if (builder == null) {
                    throw new IllegalStateException(String.format("Missing loottable '%s'", rs));
                }
                consumer.accept(rs, builder);
            }
            if (!this.tables.isEmpty()) {
                throw new IllegalStateException("Created block loot tables for non-blocks: " + this.tables.keySet());
            }
        }

        protected void m_124165_(Block blockIn, LootTable.Builder table) {
            this.tables.put(blockIn.m_60589_(), table);
        }

        private /* synthetic */ void lambda$addTables$1(Supplier v, ResourceElements e) {
            if (e.requirements().has(ResourceType.CHUNK)) {
                this.m_124165_((Block)v.get(), FTBICBlockLootTableProvider.m_124139_((Block)((Block)v.get()), (Item)FTBICItems.getResourceFromType(e, ResourceType.CHUNK).orElseThrow().get()));
            }
        }
    }
}

