/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.datagen.recipes;

import dev.ftb.mods.ftbic.datagen.FTBICRecipesGen;
import dev.ftb.mods.ftbic.datagen.recipes.MachineRecipeBuilder;
import dev.ftb.mods.ftbic.item.FTBICItems;
import dev.ftb.mods.ftbic.world.ResourceElements;
import dev.ftb.mods.ftbic.world.ResourceType;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class FTBICMaceratingRecipes
extends FTBICRecipesGen {
    public FTBICMaceratingRecipes(DataGenerator generator) {
        super(generator);
    }

    @Override
    public void add(Consumer<FinishedRecipe> consumer) {
        FTBICMaceratingRecipes.oreProcessing((TagKey<Item>)TIN_ORE, (TagKey<Item>)TIN_CHUNK, ResourceElements.TIN, consumer);
        FTBICMaceratingRecipes.oreProcessing((TagKey<Item>)LEAD_ORE, (TagKey<Item>)LEAD_CHUNK, ResourceElements.LEAD, consumer);
        FTBICMaceratingRecipes.oreProcessing((TagKey<Item>)IRIDIUM_ORE, (TagKey<Item>)IRIDIUM_CHUNK, ResourceElements.IRIDIUM, consumer);
        FTBICMaceratingRecipes.oreProcessing((TagKey<Item>)URANIUM_ORE, (TagKey<Item>)URANIUM_CHUNK, ResourceElements.URANIUM, consumer);
        FTBICMaceratingRecipes.oreProcessing((TagKey<Item>)ALUMINUM_ORE, (TagKey<Item>)ALUMINUM_CHUNK, ResourceElements.ALUMINUM, consumer);
        FTBICMaceratingRecipes.oreProcessing((TagKey<Item>)IRON_ORE, (TagKey<Item>)IRON_RAW, ResourceElements.IRON, consumer);
        FTBICMaceratingRecipes.oreProcessing((TagKey<Item>)GOLD_ORE, (TagKey<Item>)GOLD_RAW, ResourceElements.GOLD, consumer);
        FTBICMaceratingRecipes.oreProcessing((TagKey<Item>)COPPER_ORE, (TagKey<Item>)COPPER_RAW, ResourceElements.COPPER, consumer);
        FTBICMaceratingRecipes.resourceBreakDown(List.of(TIN_INGOT), ResourceElements.TIN, ResourceType.DUST, 1, consumer);
        FTBICMaceratingRecipes.resourceBreakDown(List.of(LEAD_INGOT), ResourceElements.LEAD, ResourceType.DUST, 1, consumer);
        FTBICMaceratingRecipes.resourceBreakDown(List.of(IRIDIUM_INGOT), ResourceElements.IRIDIUM, ResourceType.DUST, 1, consumer);
        FTBICMaceratingRecipes.resourceBreakDown(List.of(URANIUM_INGOT), ResourceElements.URANIUM, ResourceType.DUST, 1, consumer);
        FTBICMaceratingRecipes.resourceBreakDown(List.of(ALUMINUM_INGOT), ResourceElements.ALUMINUM, ResourceType.DUST, 1, consumer);
        FTBICMaceratingRecipes.resourceBreakDown(List.of(ENDERIUM_INGOT), ResourceElements.ENDERIUM, ResourceType.DUST, 1, consumer);
        FTBICMaceratingRecipes.resourceBreakDown(List.of(IRON_INGOT), ResourceElements.IRON, ResourceType.DUST, 1, consumer);
        FTBICMaceratingRecipes.resourceBreakDown(List.of(GOLD_INGOT), ResourceElements.GOLD, ResourceType.DUST, 1, consumer);
        FTBICMaceratingRecipes.resourceBreakDown(List.of(COPPER_INGOT), ResourceElements.COPPER, ResourceType.DUST, 1, consumer);
        FTBICMaceratingRecipes.resourceBreakDown(List.of(BRONZE_INGOT), ResourceElements.BRONZE, ResourceType.DUST, 1, consumer);
        FTBICMaceratingRecipes.resourceBreakDown(List.of(DIAMOND), ResourceElements.DIAMOND, ResourceType.DUST, 1, consumer);
    }

    private static void oreProcessing(TagKey<Item> oreTag, TagKey<Item> chunkTag, ResourceElements element, Consumer<FinishedRecipe> consumer) {
        Item dust = FTBICItems.getResourceFromType(element, ResourceType.DUST).orElseThrow().get();
        MachineRecipeBuilder.macerating().unlockedBy("has_item", (CriterionTriggerInstance)FTBICMaceratingRecipes.m_206406_(oreTag)).inputItem(Ingredient.m_204132_(oreTag)).outputItem(new ItemStack((ItemLike)dust, 2)).save(consumer, FTBICMaceratingRecipes.maceratingLoc("%s_to_dust".formatted(oreTag.f_203868_().m_135815_())));
        MachineRecipeBuilder.macerating().unlockedBy("has_item", (CriterionTriggerInstance)FTBICMaceratingRecipes.m_206406_(chunkTag)).inputItem(Ingredient.m_204132_(chunkTag)).outputItem(new ItemStack((ItemLike)dust)).outputItem(new ItemStack((ItemLike)dust), 0.35).save(consumer, FTBICMaceratingRecipes.maceratingLoc("%s_to_dust".formatted(chunkTag.f_203868_().m_135815_())));
    }

    private static void resourceBreakDown(List<TagKey<Item>> input, ResourceElements element, ResourceType type, int count, Consumer<FinishedRecipe> consumer) {
        for (TagKey<Item> item : input) {
            MachineRecipeBuilder.macerating().unlockedBy("has_item", (CriterionTriggerInstance)FTBICMaceratingRecipes.m_206406_(item)).inputItem(Ingredient.m_204132_(item)).outputItem(new ItemStack((ItemLike)FTBICItems.getResourceFromType(element, type).orElseThrow().get(), count)).save(consumer, FTBICMaceratingRecipes.maceratingLoc(item.f_203868_().m_135815_() + "_to_" + type.name().toLowerCase(Locale.ENGLISH)));
        }
    }

    private static void resourceBreakDown(List<TagKey<Item>> input, Item output, int count, Consumer<FinishedRecipe> consumer) {
        for (TagKey<Item> item : input) {
            MachineRecipeBuilder.macerating().unlockedBy("has_item", (CriterionTriggerInstance)FTBICMaceratingRecipes.m_206406_(item)).inputItem(Ingredient.m_204132_(item)).outputItem(new ItemStack((ItemLike)output, count)).save(consumer, FTBICMaceratingRecipes.maceratingLoc(item.f_203868_().m_135815_() + "_to_" + output));
        }
    }
}

