/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.item;

import dev.ftb.mods.ftbic.item.BatteryType;
import dev.ftb.mods.ftbic.item.ElectricItem;
import dev.ftb.mods.ftbic.util.EnergyItemHandler;
import dev.ftb.mods.ftbic.util.EnergyTier;
import java.util.function.Supplier;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.Nullable;

public class BatteryItem
extends ElectricItem {
    public final BatteryType batteryType;

    public BatteryItem(BatteryType b, EnergyTier t, Supplier<Double> cap) {
        super(t, cap);
        this.batteryType = b;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        CompoundTag t;
        if (this.batteryType.singleUse && !(t = stack.m_41784_()).m_128441_("Energy")) {
            t.m_128347_("Energy", ((Double)this.capacity.get()).doubleValue());
        }
        return null;
    }

    public boolean m_5812_(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128471_("Active");
    }

    @Override
    public boolean canInsertEnergy() {
        return !this.batteryType.singleUse;
    }

    @Override
    public boolean canExtractEnergy() {
        return true;
    }

    @Override
    public boolean isCreativeEnergyItem() {
        return this.batteryType.creative;
    }

    @Override
    public double extractEnergy(ItemStack stack, double maxExtract, boolean simulate) {
        double d = super.extractEnergy(stack, maxExtract, simulate);
        if (!simulate && this.getEnergy(stack) <= 0.0) {
            if (this.batteryType.singleUse) {
                stack.m_41774_(1);
            } else {
                stack.m_41749_("Energy");
            }
        }
        return d;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41782_() && stack.m_41783_().m_128471_("Active")) {
            stack.m_41749_("Active");
        } else {
            stack.m_41700_("Active", (Tag)ByteTag.m_128273_((boolean)true));
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean bl) {
        if (entity instanceof LivingEntity && stack.m_41782_() && stack.m_41783_().m_128471_("Active") && this.getEnergy(stack) > 0.0) {
            for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
                Item item;
                ItemStack is = ((LivingEntity)entity).m_6844_(equipmentSlot);
                if (is == stack || !((item = is.m_41720_()) instanceof EnergyItemHandler)) continue;
                EnergyItemHandler handler = (EnergyItemHandler)item;
                double e = this.getEnergy(stack);
                if (!(e > 0.0)) break;
                double d = handler.insertEnergy(is, e, false);
                this.extractEnergy(stack, d, false);
            }
        }
    }
}

