/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.jei;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.ftb.mods.ftbic.FTBICConfig;
import dev.ftb.mods.ftbic.block.ElectricBlockInstance;
import dev.ftb.mods.ftbic.jei.FTBICJEIPlugin;
import dev.ftb.mods.ftbic.recipe.MachineRecipe;
import dev.ftb.mods.ftbic.recipe.MachineRecipeSerializer;
import dev.ftb.mods.ftbic.screen.MachineScreen;
import dev.ftb.mods.ftbic.util.IngredientWithCount;
import dev.ftb.mods.ftbic.util.StackWithChance;
import java.util.function.Supplier;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class MachineRecipeCategory
implements IRecipeCategory<MachineRecipe> {
    public final MachineRecipeSerializer serializer;
    public final ElectricBlockInstance electricBlockInstance;
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable arrowOff;
    private final IDrawable arrowOn;
    private final IDrawable powerOff;
    private final IDrawable powerOn;
    private final IDrawable slot;
    private final IDrawable largeSlot;

    public MachineRecipeCategory(Supplier<MachineRecipeSerializer> s, IGuiHelper guiHelper, ElectricBlockInstance item) {
        this.serializer = s.get();
        this.electricBlockInstance = item;
        this.background = guiHelper.createBlankDrawable(this.serializer.guiWidth, this.serializer.guiHeight);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)item.item.get()));
        this.arrowOff = guiHelper.drawableBuilder(MachineScreen.BASE_TEXTURE, 87, 167, 24, 17).setTextureSize(256, 256).build();
        this.arrowOn = guiHelper.drawableBuilder(MachineScreen.BASE_TEXTURE, 87, 185, 24, 17).setTextureSize(256, 256).buildAnimated(Mth.m_14165_((double)((Double)FTBICConfig.MACHINES.MACHINE_RECIPE_BASE_TICKS.get())), IDrawableAnimated.StartDirection.LEFT, false);
        this.powerOff = guiHelper.drawableBuilder(MachineScreen.BASE_TEXTURE, 1, 240, 14, 14).setTextureSize(256, 256).build();
        this.powerOn = guiHelper.drawableBuilder(MachineScreen.BASE_TEXTURE, 16, 240, 14, 14).setTextureSize(256, 256).buildAnimated(84, IDrawableAnimated.StartDirection.TOP, true);
        this.slot = guiHelper.drawableBuilder(MachineScreen.BASE_TEXTURE, 1, 167, 18, 18).setTextureSize(256, 256).build();
        this.largeSlot = (this.serializer.outputSlots > 1 ? guiHelper.drawableBuilder(MachineScreen.BASE_TEXTURE, 1, 213, 47, 26) : guiHelper.drawableBuilder(MachineScreen.BASE_TEXTURE, 1, 186, 26, 26)).setTextureSize(256, 256).build();
    }

    public RecipeType<MachineRecipe> getRecipeType() {
        return FTBICJEIPlugin.getMachineRecipeType(this.serializer);
    }

    public Component getTitle() {
        return this.serializer.getDescriptionId();
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(MachineRecipe recipe, IRecipeSlotsView slots, PoseStack poseStack, double mouseX, double mouseY) {
        this.arrowOff.draw(poseStack, this.serializer.progressX, this.serializer.progressY);
        this.arrowOn.draw(poseStack, this.serializer.progressX, this.serializer.progressY);
        this.powerOff.draw(poseStack, this.serializer.energyX, this.serializer.energyY);
        this.powerOn.draw(poseStack, this.serializer.energyX, this.serializer.energyY);
        for (int i = 0; i < this.serializer.inputSlots; ++i) {
            this.slot.draw(poseStack, i * 18, 0);
        }
        this.slot.draw(poseStack, this.serializer.batteryX, this.serializer.batteryY);
        this.largeSlot.draw(poseStack, this.serializer.outputX, this.serializer.outputY);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, MachineRecipe recipe, IFocusGroup focuses) {
        int i;
        for (i = 0; i < recipe.inputFluids.size(); ++i) {
            builder.addSlot(RecipeIngredientRole.INPUT, 2 + i * 18, 2).addIngredient((IIngredientType)ForgeTypes.FLUID_STACK, (Object)recipe.inputFluids.get(i));
        }
        for (i = 0; i < recipe.inputItems.size(); ++i) {
            IngredientWithCount input = recipe.inputItems.get(i);
            IRecipeSlotBuilder slot2 = builder.addSlot(RecipeIngredientRole.INPUT, 1 + (i + recipe.inputFluids.size()) * 18, 1);
            for (ItemStack stack : input.ingredient.m_43908_()) {
                slot2.addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)((ItemStack)Util.m_137469_((Object)stack.m_41777_(), s -> s.m_41764_(input.count))));
            }
        }
        for (i = 0; i < recipe.outputFluids.size(); ++i) {
            builder.addSlot(RecipeIngredientRole.OUTPUT, this.serializer.outputX + 6 + i * 25, this.serializer.outputY + 6).addIngredient((IIngredientType)ForgeTypes.FLUID_STACK, (Object)recipe.outputFluids.get(i));
        }
        for (i = 0; i < recipe.outputItems.size(); ++i) {
            StackWithChance output = recipe.outputItems.get(i);
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, this.serializer.outputX + 5 + (i + recipe.outputFluids.size()) * 25, this.serializer.outputY + 5).addItemStack(output.stack)).addTooltipCallback((slot, tooltip) -> {
                double chance = output.chance;
                if (chance < 1.0) {
                    String s = String.valueOf(chance * 100.0);
                    tooltip.add(Component.m_237113_((String)"Chance: ").m_7220_((Component)Component.m_237113_((String)((s.endsWith(".0") ? s.substring(0, s.length() - 2) : s) + "%")).m_130940_(ChatFormatting.YELLOW)).m_130940_(ChatFormatting.GRAY));
                }
            });
        }
    }
}

