/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.recipe.machines;

import dev.ftb.mods.ftbic.FTBICConfig;
import dev.ftb.mods.ftbic.recipe.FTBICRecipes;
import dev.ftb.mods.ftbic.recipe.MachineRecipe;
import dev.ftb.mods.ftbic.recipe.MachineRecipeSerializer;
import dev.ftb.mods.ftbic.recipe.SimpleMachineRecipeResults;
import dev.ftb.mods.ftbic.util.CraftingMaterial;
import dev.ftb.mods.ftbic.util.FTBICUtils;
import dev.ftb.mods.ftbic.util.IngredientWithCount;
import dev.ftb.mods.ftbic.util.StackWithChance;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class RollingRecipeResults
extends SimpleMachineRecipeResults {
    public RollingRecipeResults() {
        super((Supplier<MachineRecipeSerializer>)FTBICRecipes.ROLLING);
    }

    @Override
    protected void addAdditionalRecipes(Level level, List<MachineRecipe> list) {
        for (CraftingMaterial m : FTBICConfig.MATERIALS.values()) {
            MachineRecipe recipe;
            ResourceLocation id;
            Item plate = FTBICConfig.getItemFromTag(m.plate.getTag());
            Item gear = FTBICConfig.getItemFromTag(m.gear.getTag());
            if (((Boolean)FTBICConfig.RECIPES.ADD_PLATE_RECIPES.get()).booleanValue() && plate != Items.f_41852_ && (id = Registry.f_122827_.m_7981_((Object)plate)) != null && !plate.m_204114_().m_203656_(FTBICUtils.NO_AUTO_RECIPE)) {
                if (!m.ingot.getValues().isEmpty()) {
                    recipe = new MachineRecipe((MachineRecipeSerializer)this.recipeSerializer.get(), new ResourceLocation("ftbic", "rolling/generated/plate_from_ingot/" + id.m_135827_() + "/" + id.m_135815_()));
                    recipe.inputItems.add(new IngredientWithCount(Ingredient.m_204132_(m.ingot.getTag()), 1));
                    recipe.outputItems.add(new StackWithChance(new ItemStack((ItemLike)plate, 2), 1.0));
                    list.add(recipe);
                }
                if (!m.gem.getValues().isEmpty()) {
                    recipe = new MachineRecipe((MachineRecipeSerializer)this.recipeSerializer.get(), new ResourceLocation("ftbic", "rolling/generated/plate_from_gem/" + id.m_135827_() + "/" + id.m_135815_()));
                    recipe.inputItems.add(new IngredientWithCount(Ingredient.m_204132_(m.gem.getTag()), 1));
                    recipe.outputItems.add(new StackWithChance(new ItemStack((ItemLike)plate, 2), 1.0));
                    list.add(recipe);
                }
            }
            if (!((Boolean)FTBICConfig.RECIPES.ADD_GEAR_RECIPES.get()).booleanValue() || gear == Items.f_41852_ || (id = Registry.f_122827_.m_7981_((Object)gear)) == null || gear.m_204114_().m_203656_(FTBICUtils.NO_AUTO_RECIPE)) continue;
            if (!m.plate.getValues().isEmpty()) {
                recipe = new MachineRecipe((MachineRecipeSerializer)this.recipeSerializer.get(), new ResourceLocation("ftbic", "rolling/generated/gear_from_plate/" + id.m_135827_() + "/" + id.m_135815_()));
                recipe.inputItems.add(new IngredientWithCount(Ingredient.m_204132_(m.plate.getTag()), 4));
                recipe.outputItems.add(new StackWithChance(new ItemStack((ItemLike)gear), 1.0));
                list.add(recipe);
                continue;
            }
            if (m.gem.getValues().isEmpty()) continue;
            recipe = new MachineRecipe((MachineRecipeSerializer)this.recipeSerializer.get(), new ResourceLocation("ftbic", "rolling/generated/gear_from_gem/" + id.m_135827_() + "/" + id.m_135815_()));
            recipe.inputItems.add(new IngredientWithCount(Ingredient.m_204132_(m.gem.getTag()), 2));
            recipe.outputItems.add(new StackWithChance(new ItemStack((ItemLike)gear), 1.0));
            list.add(recipe);
        }
    }
}

