/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.util;

import dev.ftb.mods.ftbic.FTBICConfig;
import dev.ftb.mods.ftbic.util.EnergyHandler;
import net.minecraft.util.Mth;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;

public class ForgeEnergyHandler
implements EnergyHandler {
    public final LazyOptional<IEnergyStorage> optional;
    public final IEnergyStorage storage;

    public ForgeEnergyHandler(LazyOptional<IEnergyStorage> o, IEnergyStorage s) {
        this.optional = o;
        this.storage = s;
    }

    @Override
    public boolean isEnergyHandlerInvalid() {
        return !this.optional.isPresent();
    }

    @Override
    public double getEnergyCapacity() {
        return (double)this.storage.getMaxEnergyStored() / (Double)FTBICConfig.ENERGY.ZAP_TO_FE_CONVERSION_RATE.get();
    }

    @Override
    public double getEnergy() {
        return (double)this.storage.getEnergyStored() / (Double)FTBICConfig.ENERGY.ZAP_TO_FE_CONVERSION_RATE.get();
    }

    @Override
    public void setEnergyRaw(double e) {
        if (this.storage.getEnergyStored() <= 0 || this.storage.extractEnergy(this.storage.getEnergyStored(), false) > 0) {
            this.storage.receiveEnergy(Mth.m_14165_((double)(e * (Double)FTBICConfig.ENERGY.ZAP_TO_FE_CONVERSION_RATE.get())), false);
        }
    }

    @Override
    public double insertEnergy(double maxInsert, boolean simulate) {
        return (double)this.storage.receiveEnergy(Mth.m_14165_((double)(maxInsert * (Double)FTBICConfig.ENERGY.ZAP_TO_FE_CONVERSION_RATE.get())), simulate) / (Double)FTBICConfig.ENERGY.ZAP_TO_FE_CONVERSION_RATE.get();
    }
}

