/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.crafting.CraftingHelper;

public class StackWithChance {
    public static final StackWithChance EMPTY = new StackWithChance(ItemStack.f_41583_, 0.0);
    public final ItemStack stack;
    public final double chance;

    public StackWithChance(ItemStack s, double c) {
        this.stack = s;
        this.chance = c;
    }

    public StackWithChance(JsonElement element) {
        JsonObject json = element.getAsJsonObject();
        this.stack = CraftingHelper.getItemStack((JsonObject)json, (boolean)true);
        this.chance = json.has("chance") ? json.get("chance").getAsDouble() : 1.0;
    }

    public StackWithChance(FriendlyByteBuf buf) {
        this.stack = buf.m_130267_();
        this.chance = buf.readDouble();
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("item", Registry.f_122827_.m_7981_((Object)this.stack.m_41720_()).toString());
        if (this.stack.m_41613_() > 1) {
            json.addProperty("count", (Number)this.stack.m_41613_());
        }
        if (this.stack.m_41782_()) {
            CompoundTag tag = this.stack.m_41783_().m_6426_();
            tag.m_128473_("Damage");
            if (!tag.m_128456_()) {
                json.addProperty("nbt", tag.toString());
            }
        }
        if (this.chance != 1.0) {
            json.addProperty("chance", (Number)this.chance);
        }
        return json;
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130055_(this.stack);
        buf.writeDouble(this.chance);
    }
}

