/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.api.item;

import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.OverrideOnly
public interface MediaHolderItem {
    public int getMedia(ItemStack var1);

    public int getMaxMedia(ItemStack var1);

    public void setMedia(ItemStack var1, int var2);

    public boolean canProvideMedia(ItemStack var1);

    public boolean canRecharge(ItemStack var1);

    default public float getMediaFullness(ItemStack stack) {
        int max = this.getMaxMedia(stack);
        if (max == 0) {
            return 0.0f;
        }
        return (float)this.getMedia(stack) / (float)max;
    }

    default public int withdrawMedia(ItemStack stack, int cost, boolean simulate) {
        int mediaHere = this.getMedia(stack);
        if (cost < 0) {
            cost = mediaHere;
        }
        if (!simulate) {
            int mediaLeft = mediaHere - cost;
            this.setMedia(stack, mediaLeft);
        }
        return Math.min(cost, mediaHere);
    }

    default public int insertMedia(ItemStack stack, int amount, boolean simulate) {
        int mediaHere = this.getMedia(stack);
        int emptySpace = this.getMaxMedia(stack) - mediaHere;
        if (emptySpace <= 0) {
            return 0;
        }
        if (amount < 0) {
            amount = emptySpace;
        }
        int inserting = Math.min(amount, emptySpace);
        if (!simulate) {
            int newMedia = mediaHere + inserting;
            this.setMedia(stack, newMedia);
        }
        return inserting;
    }
}

