/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.items.magic;

import at.petrak.hexcasting.api.item.MediaHolderItem;
import at.petrak.hexcasting.api.utils.MediaHelper;
import at.petrak.hexcasting.api.utils.NBTHelper;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public abstract class ItemMediaHolder
extends Item
implements MediaHolderItem {
    public static final String TAG_MEDIA = "hexcasting:media";
    public static final String TAG_MAX_MEDIA = "hexcasting:start_media";
    public static final TextColor HEX_COLOR = TextColor.m_131266_((int)11767539);
    private static final DecimalFormat PERCENTAGE = new DecimalFormat("####");
    private static final DecimalFormat DUST_AMOUNT;

    public ItemMediaHolder(Item.Properties pProperties) {
        super(pProperties);
    }

    public static ItemStack withMedia(ItemStack stack, int media, int maxMedia) {
        Item item = stack.m_41720_();
        if (item instanceof ItemMediaHolder) {
            NBTHelper.putInt(stack, TAG_MEDIA, media);
            NBTHelper.putInt(stack, TAG_MAX_MEDIA, maxMedia);
        }
        return stack;
    }

    @Override
    public int getMedia(ItemStack stack) {
        return NBTHelper.getInt(stack, TAG_MEDIA);
    }

    @Override
    public int getMaxMedia(ItemStack stack) {
        return NBTHelper.getInt(stack, TAG_MAX_MEDIA);
    }

    @Override
    public void setMedia(ItemStack stack, int media) {
        NBTHelper.putInt(stack, TAG_MEDIA, Mth.m_14045_((int)media, (int)0, (int)this.getMaxMedia(stack)));
    }

    public boolean m_142522_(ItemStack pStack) {
        return this.getMaxMedia(pStack) > 0;
    }

    public int m_142159_(ItemStack pStack) {
        int media = this.getMedia(pStack);
        int maxMedia = this.getMaxMedia(pStack);
        return MediaHelper.mediaBarColor(media, maxMedia);
    }

    public int m_142158_(ItemStack pStack) {
        int media = this.getMedia(pStack);
        int maxMedia = this.getMaxMedia(pStack);
        return MediaHelper.mediaBarWidth(media, maxMedia);
    }

    public boolean m_41465_() {
        return false;
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        int maxMedia = this.getMaxMedia(pStack);
        if (maxMedia > 0) {
            int media = this.getMedia(pStack);
            float fullness = this.getMediaFullness(pStack);
            TextColor color = TextColor.m_131266_((int)MediaHelper.mediaBarColor(media, maxMedia));
            MutableComponent mediamount = Component.m_237113_((String)DUST_AMOUNT.format((float)media / 10000.0f));
            MutableComponent percentFull = Component.m_237113_((String)(PERCENTAGE.format(100.0f * fullness) + "%"));
            MutableComponent maxCapacity = Component.m_237110_((String)"hexcasting.tooltip.media", (Object[])new Object[]{DUST_AMOUNT.format((float)maxMedia / 10000.0f)});
            mediamount.m_130938_(style -> style.m_131148_(HEX_COLOR));
            maxCapacity.m_130938_(style -> style.m_131148_(HEX_COLOR));
            percentFull.m_130938_(style -> style.m_131148_(color));
            pTooltipComponents.add((Component)Component.m_237110_((String)"hexcasting.tooltip.media_amount.advanced", (Object[])new Object[]{mediamount, maxCapacity, percentFull}));
        }
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }

    static {
        PERCENTAGE.setRoundingMode(RoundingMode.DOWN);
        DUST_AMOUNT = new DecimalFormat("###,###.##");
    }
}

