/*
 * Decompiled with CFR 0.152.
 */
package me.tepis.integratednbt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.Tag;
import org.apache.commons.lang3.ArrayUtils;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeDouble;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeInteger;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeList;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeLong;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeNbt;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeString;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;

public abstract class NBTValueConverter {
    public static IValueType<? extends IValue> mapNBTToValueType(Tag nbt) {
        return NBTValueConverter.mapNBTIDToValueType(nbt.m_7060_());
    }

    public static IValueType<?> mapNBTIDToValueType(int nbtId) {
        switch (nbtId) {
            case 1: 
            case 2: 
            case 3: {
                return ValueTypes.INTEGER;
            }
            case 4: {
                return ValueTypes.LONG;
            }
            case 5: 
            case 6: {
                return ValueTypes.DOUBLE;
            }
            case 7: 
            case 9: 
            case 11: 
            case 12: {
                return ValueTypes.LIST;
            }
            case 8: {
                return ValueTypes.STRING;
            }
            case 10: {
                return ValueTypes.NBT;
            }
        }
        throw new RuntimeException("Unexpected NBT id:" + nbtId);
    }

    public static String getDefaultValueDisplayText(int nbtId) {
        String formatCode = NBTValueConverter.getDefaultValue(nbtId).getType().getDisplayColorFormat().toString();
        switch (nbtId) {
            default: {
                return formatCode + "0";
            }
            case 7: 
            case 9: 
            case 11: 
            case 12: {
                return formatCode + "[]";
            }
            case 8: {
                return formatCode + "\"\"";
            }
            case 10: 
        }
        return formatCode + "{}";
    }

    public static IValue getDefaultValue(int nbtId) {
        switch (nbtId) {
            case 1: 
            case 2: 
            case 3: {
                return ValueTypeInteger.ValueInteger.of((int)0);
            }
            case 4: {
                return ValueTypeLong.ValueLong.of((long)0L);
            }
            case 5: 
            case 6: {
                return ValueTypeDouble.ValueDouble.of((double)0.0);
            }
            case 7: 
            case 11: 
            case 12: {
                return ValueTypeList.ValueList.ofList((IValueType)ValueTypes.INTEGER, new ArrayList());
            }
            case 8: {
                return ValueTypeString.ValueString.of((String)"");
            }
            case 9: {
                return ValueTypeList.ValueList.ofList((IValueType)ValueTypes.CATEGORY_ANY, new ArrayList());
            }
        }
        return ValueTypeNbt.ValueNbt.of((Tag)new CompoundTag());
    }

    public static IValue mapNBTToValue(Tag nbt) {
        switch (nbt.m_7060_()) {
            case 1: {
                return ValueTypeInteger.ValueInteger.of((int)((ByteTag)nbt).m_7047_());
            }
            case 2: {
                return ValueTypeInteger.ValueInteger.of((int)((ShortTag)nbt).m_7047_());
            }
            case 3: {
                return ValueTypeInteger.ValueInteger.of((int)((IntTag)nbt).m_7047_());
            }
            case 4: {
                return ValueTypeLong.ValueLong.of((long)((LongTag)nbt).m_7046_());
            }
            case 5: {
                return ValueTypeDouble.ValueDouble.of((double)((FloatTag)nbt).m_7061_());
            }
            case 6: {
                return ValueTypeDouble.ValueDouble.of((double)((DoubleTag)nbt).m_7061_());
            }
            case 7: {
                return ValueTypeList.ValueList.ofList((IValueType)ValueTypes.INTEGER, Arrays.stream(ArrayUtils.toObject((byte[])((ByteArrayTag)nbt).m_128227_())).map(ValueTypeInteger.ValueInteger::of).collect(Collectors.toList()));
            }
            case 8: {
                return ValueTypeString.ValueString.of((String)nbt.m_7916_());
            }
            case 9: {
                return ValueTypeList.ValueList.ofAll((IValue[])((IValue[])((ListTag)nbt).stream().map(NBTValueConverter::mapNBTToValue).toArray(IValue[]::new)));
            }
            case 10: {
                return ValueTypeNbt.ValueNbt.of((Tag)nbt);
            }
            case 11: {
                return ValueTypeList.ValueList.ofList((IValueType)ValueTypes.INTEGER, Arrays.stream(ArrayUtils.toObject((int[])((IntArrayTag)nbt).m_128648_())).map(ValueTypeInteger.ValueInteger::of).collect(Collectors.toList()));
            }
            case 12: {
                return ValueTypeList.ValueList.ofList((IValueType)ValueTypes.LONG, Arrays.stream(ArrayUtils.toObject((long[])((LongArrayTag)nbt).m_128851_())).map(ValueTypeLong.ValueLong::of).collect(Collectors.toList()));
            }
        }
        return null;
    }
}

