/*
 * Decompiled with CFR 0.152.
 */
package org.anti_ad.embedded.ca.solostudios.fuzzykt;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.anti_ad.embedded.ca.solostudios.stringsimilarity.NormalizedLevenshtein;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tJ\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tJ\u0016\u0010\r\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/anti_ad/embedded/ca/solostudios/fuzzykt/FuzzyKt;", "", "()V", "normalizedLevenshtein", "Lorg/anti_ad/embedded/ca/solostudios/stringsimilarity/NormalizedLevenshtein;", "longestCommonSubstring", "Lkotlin/Pair;", "", "s1", "", "s2", "partialRatio", "", "ratio", "kt-fuzzy"})
public final class FuzzyKt {
    @NotNull
    public static final FuzzyKt INSTANCE = new FuzzyKt();
    @NotNull
    private static final NormalizedLevenshtein normalizedLevenshtein = new NormalizedLevenshtein();

    private FuzzyKt() {
    }

    public final double ratio(@NotNull String s1, @NotNull String s2) {
        Intrinsics.checkNotNullParameter((Object)s1, (String)"s1");
        Intrinsics.checkNotNullParameter((Object)s2, (String)"s2");
        return normalizedLevenshtein.similarity(s1, s2);
    }

    public final double partialRatio(@NotNull String s1, @NotNull String s2) {
        Intrinsics.checkNotNullParameter((Object)s1, (String)"s1");
        Intrinsics.checkNotNullParameter((Object)s2, (String)"s2");
        Pair pair = s1.length() > s2.length() ? TuplesKt.to((Object)s2, (Object)s1) : TuplesKt.to((Object)s1, (Object)s2);
        String shorter = (String)pair.component1();
        String longer = (String)pair.component2();
        Pair<Integer, Integer> pair2 = this.longestCommonSubstring(s1, s2);
        int start = ((Number)pair2.component1()).intValue();
        int n = start + shorter.length();
        int n2 = longer.length();
        boolean bl = false;
        int upperBound = Math.min(n, n2);
        int lowerBound = upperBound - shorter.length();
        String string = longer;
        boolean bl2 = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(lowerBound, upperBound);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String splitString = string3;
        return normalizedLevenshtein.similarity(splitString, shorter);
    }

    @NotNull
    public final Pair<Integer, Integer> longestCommonSubstring(@NotNull String s1, @NotNull String s2) {
        Intrinsics.checkNotNullParameter((Object)s1, (String)"s1");
        Intrinsics.checkNotNullParameter((Object)s2, (String)"s2");
        int max = 0;
        int n = 0;
        int n2 = s1.length();
        int[][] nArrayArray = new int[n2][];
        while (n < n2) {
            int n3 = n++;
            nArrayArray[n3] = new int[s2.length()];
        }
        int[][] dp = nArrayArray;
        int endIndex = -1;
        n2 = 0;
        int n4 = s1.length() + -1;
        if (n2 <= n4) {
            do {
                int i = n2++;
                int n5 = 0;
                int n6 = s2.length() + -1;
                if (n5 > n6) continue;
                do {
                    int j = n5++;
                    if (s1.charAt(i) != s2.charAt(j)) continue;
                    dp[i][j] = i == 0 || j == 0 ? 1 : dp[i - 1][j - 1] + 1;
                    if (max >= dp[i][j]) continue;
                    max = dp[i][j];
                    endIndex = i;
                } while (n5 <= n6);
            } while (n2 <= n4);
        }
        return TuplesKt.to((Object)(endIndex - max + 1), (Object)(endIndex + 1));
    }
}

