/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.block.dock;

import dev.murad.shipping.block.IVesselLoader;
import dev.murad.shipping.block.dock.AbstractDockTileEntity;
import dev.murad.shipping.block.dock.DockingBlockStates;
import dev.murad.shipping.util.InventoryUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractTailDockTileEntity<T extends Entity>
extends AbstractDockTileEntity<T> {
    public AbstractTailDockTileEntity(BlockEntityType<?> t, BlockPos pos, BlockState state) {
        super(t, pos, state);
    }

    protected boolean handleItemHopper(T bargeEntity, HopperBlockEntity hopper) {
        if (!(bargeEntity instanceof Container)) {
            return false;
        }
        if (this.isExtract().booleanValue()) {
            return InventoryUtils.mayMoveIntoInventory((Container)hopper, (Container)bargeEntity);
        }
        return InventoryUtils.mayMoveIntoInventory((Container)bargeEntity, (Container)hopper);
    }

    protected Boolean isExtract() {
        return (Boolean)this.m_58900_().m_61143_((Property)DockingBlockStates.INVERTED);
    }

    @Override
    public boolean hold(T vessel, Direction direction) {
        if (this.checkBadDirCondition(direction)) {
            return false;
        }
        for (BlockPos p : this.getTargetBlockPos()) {
            if (!this.checkInterface(vessel, p).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private Boolean checkInterface(T vessel, BlockPos p) {
        return this.getHopper(p).map(h -> this.handleItemHopper(vessel, (HopperBlockEntity)h)).orElse(this.getVesselLoader(p).map(l -> l.hold(vessel, this.isExtract() != false ? IVesselLoader.Mode.IMPORT : IVesselLoader.Mode.EXPORT)).orElse(false));
    }

    protected abstract boolean checkBadDirCondition(Direction var1);
}

