/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.network;

import dev.murad.shipping.entity.custom.HeadVehicle;
import dev.murad.shipping.network.EnrollVehiclePacket;
import dev.murad.shipping.network.SetEnginePacket;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class VehiclePacketHandler {
    private static final Logger LOGGER = LogManager.getLogger(VehiclePacketHandler.class);
    public static final ResourceLocation LOCATION = new ResourceLocation("littlelogistics", "locomotive_channel");
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)LOCATION, () -> "1", "1"::equals, "1"::equals);
    private static int id = 0;

    public static void register() {
        INSTANCE.registerMessage(id++, SetEnginePacket.class, SetEnginePacket::encode, SetEnginePacket::new, VehiclePacketHandler::handleSetEngine);
        INSTANCE.registerMessage(id++, EnrollVehiclePacket.class, EnrollVehiclePacket::encode, EnrollVehiclePacket::new, VehiclePacketHandler::handleEnrollVehicle);
    }

    public static void handleSetEngine(SetEnginePacket operation, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> Optional.of((NetworkEvent.Context)ctx.get()).map(NetworkEvent.Context::getSender).ifPresent(serverPlayer -> {
            Entity loco = serverPlayer.f_19853_.m_6815_(operation.locoId);
            if (loco != null && loco.m_20270_((Entity)serverPlayer) < 6.0f && loco instanceof HeadVehicle) {
                HeadVehicle l = (HeadVehicle)loco;
                l.setEngineOn(operation.state);
            }
        }));
        ctx.get().setPacketHandled(true);
    }

    public static void handleEnrollVehicle(EnrollVehiclePacket operation, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> Optional.of((NetworkEvent.Context)ctx.get()).map(NetworkEvent.Context::getSender).ifPresent(serverPlayer -> {
            Entity loco = serverPlayer.f_19853_.m_6815_(operation.locoId);
            if (loco != null && loco.m_20270_((Entity)serverPlayer) < 6.0f && loco instanceof HeadVehicle) {
                HeadVehicle l = (HeadVehicle)loco;
                l.enroll(serverPlayer.m_20148_());
            }
        }));
        ctx.get().setPacketHandled(true);
    }
}

