/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.item.spells.secret;

import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import stepsword.mahoutsukai.capability.scrollmahou.IScrollMahou;
import stepsword.mahoutsukai.capability.scrollmahou.ScrollMahouStorage;
import stepsword.mahoutsukai.entity.mahoujin.FallenDownBeamEntity;
import stepsword.mahoutsukai.entity.mahoujin.FallenDownEntity;
import stepsword.mahoutsukai.item.FaeEssence;
import stepsword.mahoutsukai.item.spells.SpellScroll;
import stepsword.mahoutsukai.util.Utils;

public class FallenDownSpellScroll
extends SpellScroll {
    public static HashMap<UUID, FallenDownUserStorage> storages = new HashMap();
    private String MODE_TAG = "MAHOUTSUKAI_BEAM_MODE_ON";

    public FallenDownSpellScroll() {
        super("fallen_down");
    }

    @Override
    public int getInitialManaCost() {
        return 0;
    }

    public void setBeamMode(ItemStack scroll, int mode) {
        IScrollMahou mahou = Utils.getScrollMahou(scroll);
        if (mahou != null) {
            CompoundTag nbt = mahou.getSpellStorage();
            if (nbt == null) {
                nbt = new CompoundTag();
            }
            nbt.m_128405_(this.MODE_TAG, mode);
            mahou.setSpellStorage(nbt);
        }
    }

    public int getBeamMode(ItemStack scroll) {
        CompoundTag nbt;
        IScrollMahou mahou = Utils.getScrollMahou(scroll);
        if (mahou != null && (nbt = mahou.getSpellStorage()) != null && nbt.m_128441_(this.MODE_TAG)) {
            return nbt.m_128451_(this.MODE_TAG);
        }
        return 0;
    }

    @Override
    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(@Nonnull Level world, Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player.m_20163_()) {
            if (!world.f_46443_) {
                this.setBeamMode(stack, (this.getBeamMode(stack) + 1) % 2);
                int mode = this.getBeamMode(stack);
                MutableComponent tt = mode == 0 ? Component.m_237115_((String)"mahoutsukai.fallendown.burial") : Component.m_237115_((String)"mahoutsukai.fallendown.beam");
                player.m_5661_((Component)tt, true);
            }
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        player.m_6672_(hand);
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public void onUsingTick(ItemStack stack, LivingEntity player, int count) {
        if (!player.f_19853_.f_46443_) {
            if (storages.containsKey(player.m_20148_())) {
                FallenDownUserStorage storage = storages.get(player.m_20148_());
            } else if (this.getBeamMode(stack) == 0) {
                FallenDownUserStorage storage = new FallenDownUserStorage();
                storages.put(player.m_20148_(), storage);
                storage.fd = new FallenDownEntity(player.f_19853_, player);
                storage.fd.m_6034_(player.m_20185_(), player.m_20186_(), player.m_20189_());
                player.f_19853_.m_7967_((Entity)storage.fd);
            } else {
                FallenDownUserStorage storage = new FallenDownUserStorage();
                storages.put(player.m_20148_(), storage);
                storage.beam = new FallenDownBeamEntity(player.f_19853_, player);
                storage.beam.m_6034_(player.m_20185_(), player.m_20186_(), player.m_20189_());
                player.f_19853_.m_7967_((Entity)storage.beam);
            }
        }
    }

    @Override
    public void useAction(ItemStack stack, Level worldIn, LivingEntity entityLiving, boolean consume) {
        if (!worldIn.f_46443_) {
            IScrollMahou scrollMahou = this.getCapability(stack);
            if (entityLiving instanceof Player && Utils.getPlayerMahou((Player)entityLiving) != null) {
                Player user = (Player)entityLiving;
                if (scrollMahou != null && (user.m_20148_().equals(scrollMahou.getCasterUUID()) || scrollMahou.getCasterUUID() == null || scrollMahou.getCasterUUID().equals(FaeEssence.faeID) || scrollMahou.getCasterUUID().equals(new UUID(0L, 0L)) || user.m_7500_())) {
                    if (this.shouldConsume(user, scrollMahou, consume)) {
                        stack.m_41774_(1);
                    }
                    stack.m_41751_((CompoundTag)ScrollMahouStorage.writeNBT(scrollMahou));
                }
            }
        }
    }

    @Override
    public boolean doSpell(Player user, IScrollMahou scrollMahou) {
        if (storages.containsKey(user.m_20148_())) {
            FallenDownUserStorage storage = storages.get(user.m_20148_());
            if (storage.fd != null) {
                storage.fd.m_146870_();
            }
            if (storage.beam != null) {
                storage.beam.m_146870_();
            }
            storages.remove(user.m_20148_());
            return true;
        }
        return false;
    }

    public class FallenDownUserStorage {
        FallenDownEntity fd;
        FallenDownBeamEntity beam;
    }
}

