/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.networking;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.EncoderException;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraftforge.network.NetworkEvent;
import stepsword.mahoutsukai.networking.ClientPacketHandler;
import stepsword.mahoutsukai.util.Utils;

public class DataManagerPacket {
    public BlockPos pos;
    public List<SynchedEntityData.DataItem<?>> dataManagerEntries;

    public DataManagerPacket() {
    }

    public DataManagerPacket(BlockPos pos, List<SynchedEntityData.DataItem<?>> dataManagerEntries) {
        this.pos = pos;
        this.dataManagerEntries = dataManagerEntries;
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        FriendlyByteBuf buffer = new FriendlyByteBuf(buf);
        try {
            this.dataManagerEntries = SynchedEntityData.m_135361_((FriendlyByteBuf)buffer);
        }
        catch (Exception e) {
            Utils.err(e.toString());
        }
    }

    public void toBytes(ByteBuf buf) {
        FriendlyByteBuf buffer = new FriendlyByteBuf(buf);
        buf.writeInt(this.pos.m_123341_());
        buf.writeInt(this.pos.m_123342_());
        buf.writeInt(this.pos.m_123343_());
        for (SynchedEntityData.DataItem<?> entry : this.dataManagerEntries) {
            EntityDataAccessor dataparameter = entry.m_135396_();
            int i = EntityDataSerializers.m_135052_((EntityDataSerializer)dataparameter.m_135016_());
            if (i < 0) {
                throw new EncoderException("Unknown serializer type " + dataparameter.m_135016_());
            }
            buffer.writeByte(dataparameter.m_135015_());
            buffer.m_130130_(i);
            dataparameter.m_135016_().m_6856_(buffer, entry.m_135403_());
        }
        buffer.writeByte(255);
    }

    public static void encode(DataManagerPacket msg, FriendlyByteBuf buf) {
        msg.toBytes((ByteBuf)buf);
    }

    public static DataManagerPacket decode(FriendlyByteBuf buf) {
        DataManagerPacket msg = new DataManagerPacket();
        msg.fromBytes((ByteBuf)buf);
        return msg;
    }

    public static void handle(DataManagerPacket message, Supplier<NetworkEvent.Context> context) {
        ClientPacketHandler.updateTE(message);
        context.get().setPacketHandled(true);
    }
}

