/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.networking;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;
import stepsword.mahoutsukai.capability.settingsmahou.ISettingsMahou;
import stepsword.mahoutsukai.util.Utils;

public class SettingsUpdatePacket {
    int spell;
    List<Integer> valuesInt;

    public SettingsUpdatePacket() {
    }

    public SettingsUpdatePacket(int spell, List<Integer> valuesInt) {
        this.spell = spell;
        this.valuesInt = valuesInt;
    }

    public void fromBytes(FriendlyByteBuf buf) {
        this.spell = buf.readInt();
        int sz = buf.readInt();
        this.valuesInt = new ArrayList<Integer>();
        for (int i = 0; i < sz; ++i) {
            this.valuesInt.add(buf.readInt());
        }
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.spell);
        buf.writeInt(this.valuesInt.size());
        for (int i = 0; i < this.valuesInt.size(); ++i) {
            buf.writeInt(this.valuesInt.get(i).intValue());
        }
    }

    public static void encode(SettingsUpdatePacket msg, FriendlyByteBuf buf) {
        msg.toBytes(buf);
    }

    public static SettingsUpdatePacket decode(FriendlyByteBuf buf) {
        SettingsUpdatePacket msg = new SettingsUpdatePacket();
        msg.fromBytes(buf);
        return msg;
    }

    public static void handle(final SettingsUpdatePacket message, final Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(new Runnable(){

            @Override
            public void run() {
                ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
                ISettingsMahou mahou = Utils.getSettingsMahou((LivingEntity)player);
                if (mahou != null) {
                    mahou.setIntSettings(message.spell, message.valuesInt);
                }
            }
        });
        context.get().setPacketHandled(true);
    }
}

