/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.potion;

import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import stepsword.mahoutsukai.block.BlockBase;
import stepsword.mahoutsukai.block.ModBlocks;
import stepsword.mahoutsukai.capability.mahou.IMahou;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.handlers.ServerHandler;
import stepsword.mahoutsukai.networking.BlackFirePacket;
import stepsword.mahoutsukai.networking.PacketHandler;
import stepsword.mahoutsukai.potion.EyesPotion;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class BlackFlameEyesPotion
extends EyesPotion {
    protected BlackFlameEyesPotion() {
        super(ModEffects.getColorNumber(116, 232, 0));
    }

    public static void blackFlameEyesPotionFinish(LivingEntity player) {
        IMahou mahou;
        if (player instanceof Player && (mahou = Utils.getPlayerMahou((Player)player)) != null) {
            mahou.setPlayerPrevYaw(0.0f);
            mahou.setPlayerPrevPitch(0.0f);
            mahou.setPlayerPrevEyePos(null);
        }
    }

    public static void blackFlameEyesPlayerTick(Player player) {
        IMahou mahou = Utils.getPlayerMahou(player);
        if (mahou != null && EffectUtil.hasBuff((LivingEntity)player, ModEffects.BLACK_FLAME_EYES)) {
            Entity e = Utils.selectEntityNearCursor(player, MTConfig.GLOBAL_LOOK_RANGE, player.f_19853_, a -> Utils.getPredicate(Utils.MAHOU_SELECTION.WEAPON_NO_NEAR, a, player), Utils.nearAllowed(Utils.MAHOU_SELECTION.WEAPON_NO_NEAR));
            if (e instanceof LivingEntity) {
                EffectUtil.buff((LivingEntity)e, ModEffects.BLACK_BURNING, false, MTConfig.BLACK_FLAME_DEBUFF_TIME);
                BlackFlameEyesPotion.notifyIfBurning((LivingEntity)e);
            } else {
                float prevYaw = mahou.getPlayerPrevYaw();
                float prevPitch = mahou.getPlayerPrevPitch();
                Vec3 prevEye = mahou.getPlayerPrevEyePos();
                if (prevYaw == 0.0f) {
                    prevYaw = player.f_19857_;
                }
                if (prevPitch == 0.0f) {
                    prevPitch = player.f_19858_;
                }
                if (prevEye == null) {
                    prevEye = player.m_20299_(1.0f);
                }
                float yawDistance = player.f_19857_ - prevYaw;
                float pitchDistance = player.f_19858_ - prevPitch;
                Vec3 eyeDistance = player.m_20299_(1.0f).m_82546_(prevEye);
                for (int i = 1; i < 21; ++i) {
                    Direction hit;
                    BlockPos pos;
                    BlockHitResult result = BlackFlameEyesPotion.rayTrace(MTConfig.BLACK_FLAME_RANGE_FROM_USER, player, eyeDistance.m_82490_((double)((float)i / 20.0f)).m_82549_(prevEye), yawDistance * (float)i / 20.0f + prevYaw, pitchDistance * (float)i / 20.0f + prevPitch);
                    if (result == null || result.m_6662_() == HitResult.Type.MISS || !Utils.isBlockAir(player.f_19853_, (pos = result.m_82425_()).m_121945_(hit = result.m_82434_())) || player.f_19853_.m_8055_(pos).m_60734_() == ModBlocks.blackFireBlock.get()) continue;
                    EffectUtil.tryChangeBlockState(false, pos.m_121945_(hit), ((BlockBase)((Object)ModBlocks.blackFireBlock.get())).m_49966_(), player.f_19853_, player);
                }
                mahou.setPlayerPrevYaw(player.f_19857_);
                mahou.setPlayerPrevPitch(player.f_19858_);
                mahou.setPlayerPrevEyePos(player.m_20299_(1.0f));
            }
        }
    }

    public static void blackFlameEyesLivingUpdate(LivingEntity entity) {
        if (entity != null && entity.m_6084_() && !entity.f_19853_.f_46443_ && ServerHandler.tickCounter % 20L == 0L && EffectUtil.hasBuff(entity, ModEffects.BLACK_BURNING)) {
            entity.m_6469_(DamageSource.f_19320_, (float)MTConfig.BLACK_FLAME_DAMAGE);
            entity.f_20889_ = 100;
        }
    }

    public static boolean isFlammableWithin(AABB bb, Level world) {
        int j1;
        int i = Mth.m_14107_((double)bb.f_82288_);
        int j = Mth.m_14165_((double)bb.f_82291_);
        int k = Mth.m_14107_((double)bb.f_82289_);
        int l = Mth.m_14165_((double)bb.f_82292_);
        int i1 = Mth.m_14107_((double)bb.f_82290_);
        if (world.m_46812_(i, k, i1, j, l, j1 = Mth.m_14165_((double)bb.f_82293_))) {
            BlockPos.MutableBlockPos blockpos$pooledmutable = new BlockPos.MutableBlockPos();
            for (int k1 = i; k1 < j; ++k1) {
                for (int l1 = k; l1 < l; ++l1) {
                    for (int i2 = i1; i2 < j1; ++i2) {
                        BlockState state = world.m_8055_((BlockPos)blockpos$pooledmutable.m_122178_(k1, l1, i2));
                        if (state.m_60734_() != ModBlocks.blackFireBlock.get()) continue;
                        boolean flag = true;
                        return flag;
                    }
                }
            }
            return false;
        }
        return false;
    }

    public static final Vec3 getVectorForRotation(float pitch, float yaw) {
        float f = Mth.m_14089_((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f1 = Mth.m_14031_((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f2 = -Mth.m_14089_((float)(-pitch * ((float)Math.PI / 180)));
        float f3 = Mth.m_14031_((float)(-pitch * ((float)Math.PI / 180)));
        return new Vec3((double)(f1 * f2), (double)f3, (double)(f * f2));
    }

    public static BlockHitResult rayTrace(double blockReachDistance, Player player, Vec3 v, float yaw, float pitch) {
        HitResult zz = player.m_19907_(blockReachDistance, 1.0f, false);
        Object pos = null;
        if (zz instanceof BlockHitResult) {
            return (BlockHitResult)zz;
        }
        return null;
    }

    public static void notifyIfBurning(LivingEntity e) {
        ArrayList<LivingEntity> lst = new ArrayList<LivingEntity>();
        lst.add(e);
        if (EffectUtil.hasBuff(e, ModEffects.BLACK_BURNING)) {
            BlackFlameEyesPotion.notifyTracking(lst, true, e.f_19853_);
        }
    }

    public static void notifyNotBurning(LivingEntity e) {
        ArrayList<LivingEntity> lst = new ArrayList<LivingEntity>();
        lst.add(e);
        BlackFlameEyesPotion.notifyTracking(lst, false, e.f_19853_);
    }

    public static void notifyTracking(ArrayList<LivingEntity> entities, boolean r, Level world) {
        if (world instanceof ServerLevel) {
            for (LivingEntity e : entities) {
                PacketHandler.sendTracking((Entity)e, new BlackFirePacket(e.m_19879_(), r));
            }
        }
    }
}

