/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.potion;

import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.event.level.BlockEvent;
import stepsword.mahoutsukai.advancements.ModTriggers;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.entity.ModEntities;
import stepsword.mahoutsukai.entity.butterfly.ButterflyEntity;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.util.EffectUtil;

public class ForesightPotion
extends MobEffect {
    protected ForesightPotion() {
        super(MobEffectCategory.NEUTRAL, ModEffects.getColorNumber(252, 45, 45));
    }

    public static boolean checkBlockAndChunk(BlockPos p, Level level) {
        LevelChunk c = (LevelChunk)level.m_46865_(p);
        ChunkPos cp = c.m_7697_();
        AABB aabb = new AABB((double)cp.m_45604_(), (double)level.m_141937_(), (double)cp.m_45605_(), (double)cp.m_45608_(), (double)level.m_151558_(), (double)cp.m_45609_());
        List lst = level.m_142425_((EntityTypeTest)ModEntities.BUTTERFLY.get(), aabb, Objects::nonNull);
        int numBlock = 0;
        int numChunk = 0;
        for (ButterflyEntity be : lst) {
            if (be.origPos.equals((Object)p)) {
                ++numBlock;
            }
            ++numChunk;
            if (numBlock >= MTConfig.BUTTERFLY_EFFECT_BLOCK_LIMIT) {
                return false;
            }
            if (numChunk < MTConfig.BUTTERFLY_EFFECT_CHUNK_LIMIT) continue;
            return false;
        }
        return true;
    }

    public static void butterflyPlaceBlock(BlockEvent.EntityPlaceEvent event) {
        if (event.getEntity() instanceof Player) {
            Player player = (Player)event.getEntity();
            if (!player.f_19853_.f_46443_ && EffectUtil.hasBuff((LivingEntity)player, ModEffects.FORESIGHT) && !event.getPlacedBlock().m_155947_() && player.m_21205_().m_41720_() instanceof BlockItem) {
                ButterflyEntity butterfly = new ButterflyEntity(event.getEntity().f_19853_, player, player.m_217043_().m_188503_(6000000), player.m_217043_().m_188501_() * 0.5f + 0.2f);
                HitResult result = player.m_19907_(8.0, 1.0f, false);
                if (result instanceof BlockHitResult) {
                    BlockHitResult r = (BlockHitResult)result;
                    butterfly.setPlaceEffect(event.getPos(), r.m_82434_(), event.getPlacedBlock(), player.m_21205_().m_41620_(1));
                    if (ForesightPotion.checkBlockAndChunk(butterfly.origPos, player.f_19853_)) {
                        player.f_19853_.m_7967_((Entity)butterfly);
                        ModTriggers.BUTTERFLY.trigger((ServerPlayer)player);
                        event.setCanceled(true);
                        if (MTConfig.BUTTERFLY_EFFECT_SINGLE_USE) {
                            EffectUtil.debuff((LivingEntity)player, ModEffects.FORESIGHT);
                        }
                    }
                }
            }
        }
    }

    public static void butterflyBreakBlock(BlockEvent.BreakEvent event) {
        HitResult result;
        if (!event.getPlayer().f_19853_.f_46443_ && event.getPlayer() != null && event.getState().m_60767_() != Material.f_76296_ && !event.getState().m_155947_() && EffectUtil.hasBuff((LivingEntity)event.getPlayer(), ModEffects.FORESIGHT) && (result = event.getPlayer().m_19907_(8.0, 1.0f, false)) instanceof BlockHitResult) {
            BlockHitResult r = (BlockHitResult)result;
            ButterflyEntity butterfly = new ButterflyEntity(event.getPlayer().f_19853_, event.getPlayer(), event.getPlayer().m_217043_().m_188503_(6000000), event.getPlayer().m_217043_().m_188501_() * 0.5f + 0.2f);
            butterfly.setBreakEffect(event.getPos(), r.m_82434_(), event.getState());
            if (ForesightPotion.checkBlockAndChunk(butterfly.origPos, event.getPlayer().f_19853_)) {
                ModTriggers.BUTTERFLY.trigger((ServerPlayer)event.getPlayer());
                event.getPlayer().f_19853_.m_7967_((Entity)butterfly);
                event.setCanceled(true);
                if (MTConfig.BUTTERFLY_EFFECT_SINGLE_USE) {
                    EffectUtil.debuff((LivingEntity)event.getPlayer(), ModEffects.FORESIGHT);
                }
            }
        }
    }

    public static void butterflyHit(Player player) {
        if (player != null && !player.f_19853_.f_46443_ && EffectUtil.hasBuff((LivingEntity)player, ModEffects.FORESIGHT)) {
            ButterflyEntity butterfly = new ButterflyEntity(player.f_19853_, player, player.m_217043_().m_188503_(6000000), player.m_217043_().m_188501_() * 0.5f + 0.2f);
            butterfly.setHitEffect(player, player.m_21205_(), player.m_21206_());
            if (ForesightPotion.checkBlockAndChunk(butterfly.origPos, player.f_19853_)) {
                player.f_19853_.m_7967_((Entity)butterfly);
                ModTriggers.BUTTERFLY.trigger((ServerPlayer)player);
                if (MTConfig.BUTTERFLY_EFFECT_SINGLE_USE) {
                    EffectUtil.debuff((LivingEntity)player, ModEffects.FORESIGHT);
                }
            }
        }
    }
}

