/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.overlay;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.potion.ClairvoyanceEyesPotion;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.render.ColorRenderTypeBuffer;
import stepsword.mahoutsukai.render.CullWrappedRenderLayer;
import stepsword.mahoutsukai.render.GlowRenderLayer;
import stepsword.mahoutsukai.render.MahoujinRenderType;
import stepsword.mahoutsukai.render.RenderUtils;
import stepsword.mahoutsukai.util.EffectUtil;

public class RenderClairvoyance {
    static ResourceLocation loc = new ResourceLocation("mahoutsukai", "textures/particle/white_magic_particle1.png");

    public static void renderPrediction(PoseStack matrix, Entity camera, float partialTicks) {
        Player player;
        if (camera instanceof Player && EffectUtil.hasBuff((LivingEntity)(player = (Player)camera), ModEffects.CLAIRVOYANCE)) {
            ClairvoyanceEyesPotion.iterator = ((ConcurrentHashMap.KeySetView)ClairvoyanceEyesPotion.predictionMap.keySet()).iterator();
            while (ClairvoyanceEyesPotion.iterator.hasNext()) {
                Vec3 b;
                PathfinderMob e = ClairvoyanceEyesPotion.iterator.next();
                Vec3 a = e.m_20182_();
                if (a.m_82554_(b = camera.m_20182_()) < (double)MTConfig.CLAIRVOYANCE_RANGE && e.m_6084_()) {
                    Path path = ClairvoyanceEyesPotion.predictionMap.get(e);
                    CompoundTag nbt = new CompoundTag();
                    if (!ClairvoyanceEyesPotion.entityNBTMap.containsKey(e)) {
                        e.m_20240_(nbt);
                        nbt.m_128359_("id", EntityType.m_20613_((EntityType)e.m_6095_()).toString());
                        ClairvoyanceEyesPotion.entityNBTMap.put(e, nbt);
                    } else {
                        nbt = ClairvoyanceEyesPotion.entityNBTMap.get(e);
                    }
                    try {
                        Entity tmp = (Entity)EntityType.m_20642_((CompoundTag)nbt, (Level)e.f_19853_).get();
                        PathfinderMob pred = null;
                        if (tmp instanceof PathfinderMob) {
                            pred = (PathfinderMob)tmp;
                        }
                        if (path == null || pred == null) continue;
                        pred.f_19857_ = e.f_19857_;
                        if (path.m_77392_() || path.m_77398_() <= path.m_77399_() + 1) continue;
                        int plength = path.m_77398_();
                        for (int i = path.m_77399_(); i < plength; ++i) {
                            Node point = path.m_77375_(i);
                            pred.m_6034_((double)point.f_77271_, (double)point.f_77272_, (double)point.f_77273_);
                            if (a.m_82554_(pred.m_20182_()) < 1.0) {
                                path.m_77393_(i);
                            }
                            if (path.m_77392_() || path.m_77398_() <= path.m_77399_() + 1) continue;
                            RenderClairvoyance.renderEntityStatic(pred, point.f_77271_, point.f_77272_, point.f_77273_, 0.0f, 0.0f, matrix, new ColorRenderTypeBuffer((MultiBufferSource)Minecraft.m_91087_().m_91269_().m_110104_(), 1.0f, 0.0f, 0.0f, 0.5f), 240);
                        }
                        continue;
                    }
                    catch (Exception exception) {
                        continue;
                    }
                }
                ClairvoyanceEyesPotion.iterator.remove();
                ClairvoyanceEyesPotion.entityNBTMap.remove(e);
            }
            ClairvoyanceEyesPotion.iterator = null;
        }
    }

    public static void renderPathPoint(Vec3 currv, Vec3 prevv, Vec3 nextv, float partialTicks, PoseStack matrixStackIn, MultiBufferSource.BufferSource buf, int packedLightIn, float sz1, float sz2) {
        Vec3 v = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        float s1 = Math.min(sz1, 0.3f);
        float s2 = Math.min(sz2, 0.3f);
        Vec3 tmpv = currv;
        Vec3 diff = currv.m_82546_(prevv);
        float d = (float)diff.m_82553_();
        diff = diff.m_82541_();
        float[] rgba = new float[]{1.0f, 0.0f, 0.0f, 0.7f};
        float r = rgba[0];
        float g = rgba[1];
        float b = rgba[2];
        float a = rgba[3];
        GlowRenderLayer rt = new GlowRenderLayer(new CullWrappedRenderLayer(MahoujinRenderType.createMahoujinRenderType(loc, 0, false)), rgba, 0.4f, false);
        float step = 0.05f;
        for (float i = 0.0f; i < d; i += step) {
            tmpv = prevv.m_82549_(diff.m_82490_((double)i));
            double t = i / d;
            tmpv = RenderUtils.bezier(t, prevv, currv, nextv);
            float sz = s1 + (s2 - s1) * i / (d / step);
            double d2 = tmpv.f_82479_ - v.f_82479_;
            double d3 = tmpv.f_82480_ - v.f_82480_ + 0.5;
            double d0 = tmpv.f_82481_ - v.f_82481_;
            matrixStackIn.m_85836_();
            matrixStackIn.m_85837_(d2, d3, d0);
            RenderUtils.billboard(matrixStackIn, 0.0f, partialTicks);
            matrixStackIn.m_85841_(sz, sz, sz);
            Matrix4f m = matrixStackIn.m_85850_().m_85861_();
            VertexConsumer bb = buf.m_6299_((RenderType)rt);
            float xx = 0.5f;
            float bxx = -xx;
            float yy = 0.0f;
            bb.m_85982_(m, bxx, yy, bxx).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_7120_(240, 240).m_5752_();
            bb.m_85982_(m, bxx, yy, xx).m_85950_(r, g, b, a).m_7421_(0.0f, 1.0f).m_7120_(240, 240).m_5752_();
            bb.m_85982_(m, xx, yy, xx).m_85950_(r, g, b, a).m_7421_(1.0f, 1.0f).m_7120_(240, 240).m_5752_();
            bb.m_85982_(m, xx, yy, bxx).m_85950_(r, g, b, a).m_7421_(1.0f, 0.0f).m_7120_(240, 240).m_5752_();
            buf.m_109912_((RenderType)rt);
            matrixStackIn.m_85849_();
        }
    }

    public static <E extends Entity> void renderEntityStatic(E entityIn, double xIn, double yIn, double zIn, float rotationYawIn, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        try {
            Vec3 v = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
            EntityRenderer entityRenderer = Minecraft.m_91087_().m_91290_().m_114382_(entityIn);
            Vec3 Vec32 = entityRenderer.m_7860_(entityIn, partialTicks);
            double d2 = xIn + Vec32.m_7096_() - v.f_82479_;
            double d3 = yIn + Vec32.m_7098_() - v.f_82480_;
            double d0 = zIn + Vec32.m_7094_() - v.f_82481_;
            matrixStackIn.m_85836_();
            matrixStackIn.m_85837_(d2, d3, d0);
            entityRenderer.m_7392_(entityIn, rotationYawIn, partialTicks, matrixStackIn, bufferIn, packedLightIn);
            matrixStackIn.m_85837_(-d2, -d3, -d0);
            matrixStackIn.m_85849_();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

