/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.datagen;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import mcjty.lib.crafting.IRecipeBuilder;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.Tags;

public class BaseRecipeProvider
extends RecipeProvider {
    private final Map<Character, Ingredient> defaultIngredients = new HashMap<Character, Ingredient>();
    private String group = "";

    protected BaseRecipeProvider group(String group) {
        this.group = group;
        return this;
    }

    protected BaseRecipeProvider add(char c, TagKey<Item> itemTag) {
        this.defaultIngredients.put(Character.valueOf(c), Ingredient.m_204132_(itemTag));
        return this;
    }

    protected BaseRecipeProvider add(char c, ItemLike itemProvider) {
        this.defaultIngredients.put(Character.valueOf(c), Ingredient.m_43929_((ItemLike[])new ItemLike[]{itemProvider}));
        return this;
    }

    protected BaseRecipeProvider add(char c, Ingredient ingredient) {
        this.defaultIngredients.put(Character.valueOf(c), ingredient);
        return this;
    }

    private void buildIntern(Consumer<FinishedRecipe> consumer, Consumer<String> lineConsumer, BiConsumer<Character, Ingredient> ingredientConsumer, String ... lines) {
        HashSet characters = new HashSet();
        for (String line : lines) {
            lineConsumer.accept(line);
            line.chars().forEach(value -> characters.add(Character.valueOf((char)value)));
        }
        for (Character c : characters) {
            if (!this.defaultIngredients.containsKey(c)) continue;
            ingredientConsumer.accept(c, this.defaultIngredients.get(c));
        }
    }

    protected void build(Consumer<FinishedRecipe> consumer, IRecipeBuilder<?> builder, String ... lines) {
        this.buildIntern(consumer, builder::patternLine, builder::define, lines);
        builder.setGroup(this.group).build(consumer);
    }

    protected void build(Consumer<FinishedRecipe> consumer, ShapedRecipeBuilder builder, String ... lines) {
        this.buildIntern(consumer, arg_0 -> ((ShapedRecipeBuilder)builder).m_126130_(arg_0), (arg_0, arg_1) -> ((ShapedRecipeBuilder)builder).m_126124_(arg_0, arg_1), lines);
        builder.m_126145_(this.group).m_176498_(consumer);
    }

    protected void build(Consumer<FinishedRecipe> consumer, ShapelessRecipeBuilder builder) {
        builder.m_126145_(this.group).m_176498_(consumer);
    }

    protected void build(Consumer<FinishedRecipe> consumer, ResourceLocation id, ShapelessRecipeBuilder builder) {
        builder.m_126145_(this.group).m_126140_(consumer, id);
    }

    protected void build(Consumer<FinishedRecipe> consumer, ResourceLocation id, IRecipeBuilder<?> builder, String ... lines) {
        this.buildIntern(consumer, builder::patternLine, builder::define, lines);
        builder.setGroup(this.group).build(consumer, id);
    }

    protected void build(Consumer<FinishedRecipe> consumer, ResourceLocation id, ShapedRecipeBuilder builder, String ... lines) {
        this.buildIntern(consumer, arg_0 -> ((ShapedRecipeBuilder)builder).m_126130_(arg_0), (arg_0, arg_1) -> ((ShapedRecipeBuilder)builder).m_126124_(arg_0, arg_1), lines);
        builder.m_126145_(this.group).m_126140_(consumer, id);
    }

    public BaseRecipeProvider(DataGenerator datagen) {
        super(datagen);
        this.add('d', (ItemLike)Items.f_42415_);
        this.add('e', (ItemLike)Items.f_42616_);
        this.add('o', (TagKey<Item>)Tags.Items.ENDER_PEARLS);
        this.add('r', (ItemLike)Items.f_42451_);
        this.add('R', (ItemLike)Items.f_42153_);
        this.add('i', (TagKey<Item>)Tags.Items.INGOTS_IRON);
        this.add('p', (ItemLike)Items.f_42516_);
        this.add('c', (TagKey<Item>)ItemTags.f_13160_);
        this.add('B', (ItemLike)Blocks.f_50076_);
        this.add('W', (ItemLike)Items.f_42447_);
        this.add('L', (ItemLike)Items.f_42448_);
        this.add('b', (ItemLike)Items.f_42446_);
        this.add('T', (ItemLike)Items.f_41978_);
        this.add('D', (ItemLike)Blocks.f_50493_);
        this.add('G', (TagKey<Item>)Tags.Items.GLASS);
        this.add('O', (ItemLike)Blocks.f_50080_);
    }
}

