/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.megacells.item;

import appeng.api.config.FuzzyMode;
import appeng.api.stacks.AEItemKey;
import appeng.api.storage.AEKeyFilter;
import appeng.api.storage.cells.ICellHandler;
import appeng.api.storage.cells.ICellWorkbenchItem;
import appeng.api.storage.cells.ISaveProvider;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.UpgradeInventories;
import appeng.core.localization.Tooltips;
import appeng.items.AEBaseItem;
import appeng.items.contents.CellConfig;
import appeng.util.ConfigInventory;
import gripe._90.megacells.definition.MEGATranslations;
import gripe._90.megacells.item.cell.BulkCellInventory;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MEGABulkCell
extends AEBaseItem
implements ICellWorkbenchItem {
    public static final Handler HANDLER = new Handler();

    public MEGABulkCell(Item.Properties properties) {
        super(properties.m_41487_(1));
    }

    public ConfigInventory getConfigInventory(ItemStack is) {
        return CellConfig.create((AEKeyFilter)AEItemKey.filter(), (ItemStack)is, (int)1);
    }

    public void m_7373_(ItemStack is, Level level, @NotNull List<Component> lines, @NotNull TooltipFlag adv) {
        BulkCellInventory inv = HANDLER.getCellInventory(is, null);
        if (inv != null) {
            AEItemKey storedItem = inv.getStoredItem();
            AEItemKey filterItem = inv.getFilterItem();
            if (storedItem != null) {
                lines.add((Component)Tooltips.of((Component)MEGATranslations.Contains.text(new Object[]{storedItem.getDisplayName()})));
                long quantity = inv.getStoredQuantity();
                lines.add((Component)Tooltips.of((Component)MEGATranslations.Quantity.text(new Object[]{quantity < Long.MAX_VALUE ? Tooltips.ofNumber((long)quantity) : MEGATranslations.ALot.text().m_130948_(Tooltips.NUMBER_TEXT)})));
            } else {
                lines.add((Component)Tooltips.of((Component)MEGATranslations.Empty.text()));
            }
            if (filterItem != null) {
                if (storedItem == null) {
                    lines.add((Component)Tooltips.of((Component)MEGATranslations.PartitionedFor.text(new Object[]{filterItem.getDisplayName()})));
                } else if (!storedItem.equals((Object)filterItem)) {
                    lines.add((Component)MEGATranslations.MismatchedFilter.text().m_130940_(ChatFormatting.DARK_RED));
                }
            } else if (storedItem != null) {
                lines.add((Component)MEGATranslations.MismatchedFilter.text().m_130940_(ChatFormatting.DARK_RED));
            } else {
                lines.add((Component)MEGATranslations.NotPartitioned.text());
            }
            lines.add((Component)Tooltips.of((Component)MEGATranslations.Compression.text(new Object[]{inv.compressionEnabled ? MEGATranslations.Enabled.text().m_130940_(ChatFormatting.GREEN) : MEGATranslations.Disabled.text().m_130940_(ChatFormatting.RED)})));
        }
    }

    public IUpgradeInventory getUpgrades(ItemStack is) {
        return UpgradeInventories.forItem((ItemStack)is, (int)1);
    }

    public FuzzyMode getFuzzyMode(ItemStack itemStack) {
        return null;
    }

    public void setFuzzyMode(ItemStack itemStack, FuzzyMode fuzzyMode) {
    }

    public static class Handler
    implements ICellHandler {
        private Handler() {
        }

        public boolean isCell(ItemStack is) {
            return is != null && is.m_41720_() instanceof MEGABulkCell;
        }

        @Nullable
        public BulkCellInventory getCellInventory(ItemStack is, @Nullable ISaveProvider container) {
            Objects.requireNonNull(is, "Cannot create cell inventory for null itemstack");
            return this.isCell(is) ? new BulkCellInventory((MEGABulkCell)is.m_41720_(), is, container) : null;
        }
    }
}

