/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.megacells.item.cell;

import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.cells.CellState;
import appeng.api.storage.cells.ISaveProvider;
import appeng.api.storage.cells.StorageCell;
import appeng.util.ConfigInventory;
import appeng.util.prioritylist.IPartitionList;
import gripe._90.megacells.definition.MEGAItems;
import gripe._90.megacells.item.MEGABulkCell;
import gripe._90.megacells.service.CompressionService;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.math.BigInteger;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public class BulkCellInventory
implements StorageCell {
    private static final String KEY = "key";
    private static final String UNIT_COUNT = "smallestUnitCount";
    private final ISaveProvider container;
    private final ItemStack i;
    private AEItemKey storedItem;
    private final AEItemKey filterItem;
    private final IPartitionList partitionList;
    private final Object2IntMap<AEItemKey> compressed;
    private final Object2IntMap<AEItemKey> decompressed;
    private BigInteger unitCount;
    private AEItemKey highestCompressed;
    private final long unitFactor;
    public final boolean compressionEnabled;
    private boolean isPersisted = true;

    public BulkCellInventory(MEGABulkCell cell, ItemStack o, ISaveProvider container) {
        this.i = o;
        this.container = container;
        ConfigInventory config = cell.getConfigInventory(this.i);
        this.filterItem = (AEItemKey)config.getKey(0);
        IPartitionList.Builder builder = IPartitionList.builder();
        builder.addAll((Iterable)config.keySet());
        this.partitionList = builder.build();
        this.compressed = CompressionService.INSTANCE.getVariants(this.filterItem, false);
        this.decompressed = CompressionService.INSTANCE.getVariants(this.filterItem, true);
        this.unitFactor = this.decompressed.values().intStream().asLongStream().reduce(1L, Math::multiplyExact);
        this.storedItem = this.getTag().m_128441_(KEY) ? AEItemKey.fromTag((CompoundTag)this.getTag().m_128469_(KEY)) : null;
        this.unitCount = this.retrieveUnitCount();
        this.highestCompressed = this.storedItem;
        this.compressionEnabled = cell.getUpgrades(this.i).isInstalled(MEGAItems.COMPRESSION_CARD);
    }

    private BigInteger retrieveUnitCount() {
        if (this.getTag().m_128441_("count")) {
            return BigInteger.valueOf(this.getTag().m_128454_("count")).multiply(BigInteger.valueOf(this.unitFactor));
        }
        return !this.getTag().m_128461_(UNIT_COUNT).equals("") ? new BigInteger(this.getTag().m_128461_(UNIT_COUNT)) : BigInteger.ZERO;
    }

    private long clampedLong(BigInteger toClamp, long limit) {
        return toClamp.min(BigInteger.valueOf(limit)).longValue();
    }

    private CompoundTag getTag() {
        return this.i.m_41784_();
    }

    public CellState getStatus() {
        if (this.unitCount.signum() == 0) {
            return CellState.EMPTY;
        }
        if (!this.storedItem.equals((Object)this.filterItem)) {
            return CellState.FULL;
        }
        return CellState.NOT_EMPTY;
    }

    public AEItemKey getStoredItem() {
        return this.storedItem;
    }

    public long getStoredQuantity() {
        return this.clampedLong(this.unitCount.divide(BigInteger.valueOf(this.unitFactor)), Long.MAX_VALUE);
    }

    public AEItemKey getHighestCompressed() {
        return this.highestCompressed;
    }

    public AEItemKey getFilterItem() {
        return this.filterItem;
    }

    public double getIdleDrain() {
        return 10.0;
    }

    public long insert(AEKey what, long amount, Actionable mode, IActionSource source) {
        if (amount == 0L || !(what instanceof AEItemKey)) {
            return 0L;
        }
        AEItemKey item = (AEItemKey)what;
        if (!(this.compressionEnabled || this.partitionList.isListed(what) && (this.storedItem == null || this.storedItem.equals((Object)what)))) {
            return 0L;
        }
        if (this.compressionEnabled && !this.partitionList.isListed(what) && !this.compressed.containsKey((Object)item) && !this.decompressed.containsKey((Object)item)) {
            return 0L;
        }
        BigInteger units = BigInteger.valueOf(amount).multiply(this.compressedTransferFactor(item));
        if (mode == Actionable.MODULATE) {
            if (this.storedItem == null) {
                this.storedItem = this.filterItem;
            }
            this.unitCount = this.unitCount.add(units);
            this.saveChanges();
        }
        return amount;
    }

    public long extract(AEKey what, long amount, Actionable mode, IActionSource source) {
        if (this.unitCount.signum() < 1 || !(what instanceof AEItemKey)) {
            return 0L;
        }
        AEItemKey item = (AEItemKey)what;
        BigInteger itemCount = this.unitCount.divide(BigInteger.valueOf(this.unitFactor));
        if (!(this.compressionEnabled || itemCount.signum() >= 1 && this.storedItem.equals((Object)what))) {
            return 0L;
        }
        if (!(!this.compressionEnabled || this.storedItem.equals((Object)what) || this.filterItem.equals((Object)what) || this.compressed.containsKey((Object)item) || this.decompressed.containsKey((Object)item))) {
            return 0L;
        }
        BigInteger extractionFactor = this.compressedTransferFactor(item);
        BigInteger currentUnitCount = this.unitCount;
        BigInteger units = BigInteger.valueOf(amount).multiply(extractionFactor);
        if (currentUnitCount.compareTo(units) <= 0) {
            if (mode == Actionable.MODULATE) {
                this.storedItem = null;
                this.unitCount = BigInteger.ZERO;
                this.saveChanges();
            }
            return this.clampedLong(currentUnitCount.divide(extractionFactor), Long.MAX_VALUE);
        }
        if (mode == Actionable.MODULATE) {
            this.unitCount = this.unitCount.subtract(units);
            this.saveChanges();
        }
        return this.clampedLong(units.divide(extractionFactor), Long.MAX_VALUE);
    }

    private BigInteger compressedTransferFactor(AEItemKey what) {
        if (this.compressed.getInt((Object)what) > 0) {
            return this.compressedTransferFactor(this.compressed, this.unitFactor, keys -> Pair.of((Object)0, (Object)(keys.indexOf(what) + 1)));
        }
        if (this.decompressed.getInt((Object)what) > 0) {
            return this.compressedTransferFactor(this.decompressed, 1L, keys -> Pair.of((Object)(keys.indexOf(what) + 1), (Object)keys.size()));
        }
        return BigInteger.valueOf(this.unitFactor);
    }

    private BigInteger compressedTransferFactor(Object2IntMap<AEItemKey> variants, long baseFactor, Function<List<?>, Pair<Integer, Integer>> subLister) {
        LinkedList variantKeys = new LinkedList(variants.keySet());
        Object2IntLinkedOpenHashMap toStored = new Object2IntLinkedOpenHashMap(variants);
        Pair<Integer, Integer> range = subLister.apply(variantKeys);
        toStored.keySet().retainAll(variantKeys.subList((Integer)range.first(), (Integer)range.second()));
        for (Integer i : toStored.values()) {
            baseFactor *= (long)i.intValue();
        }
        return BigInteger.valueOf(baseFactor);
    }

    private void saveChanges() {
        this.isPersisted = false;
        if (this.container != null) {
            this.container.saveChanges();
        } else {
            this.persist();
        }
    }

    public void persist() {
        if (this.isPersisted) {
            return;
        }
        if (this.storedItem == null || this.unitCount.signum() == -1) {
            this.getTag().m_128473_(KEY);
            this.getTag().m_128473_(UNIT_COUNT);
        } else {
            this.getTag().m_128365_(KEY, (Tag)this.storedItem.toTagGeneric());
            this.getTag().m_128359_(UNIT_COUNT, this.unitCount.toString());
        }
        this.getTag().m_128473_("count");
        this.isPersisted = true;
    }

    public void getAvailableStacks(KeyCounter out) {
        if (this.storedItem != null) {
            long stackLimit = (long)Math.pow(2.0, 42.0);
            if (this.compressionEnabled && this.storedItem.equals((Object)this.filterItem)) {
                Object2IntLinkedOpenHashMap allVariants = new Object2IntLinkedOpenHashMap();
                if (!this.decompressed.isEmpty()) {
                    LinkedList decompressedKeys = new LinkedList(this.decompressed.keySet());
                    Collections.reverse(decompressedKeys);
                    decompressedKeys.forEach(k -> allVariants.put(k, this.decompressed.getInt(k)));
                    allVariants.put((Object)this.storedItem, this.decompressed.getInt(decompressedKeys.getLast()));
                    allVariants.putAll(this.compressed);
                } else if (!this.compressed.isEmpty()) {
                    allVariants.put((Object)this.storedItem, this.compressed.values().intStream().findFirst().orElseThrow());
                    allVariants.putAll(this.compressed);
                } else {
                    allVariants.put((Object)this.storedItem, 1);
                }
                BigInteger count = this.unitCount;
                for (AEItemKey variant : allVariants.keySet()) {
                    BigInteger compressionFactor = BigInteger.valueOf(allVariants.getInt((Object)variant));
                    if (count.divide(compressionFactor).signum() == 1 && variant != allVariants.lastKey()) {
                        out.add((AEKey)variant, this.clampedLong(count.remainder(compressionFactor), stackLimit));
                        count = count.divide(compressionFactor);
                        continue;
                    }
                    out.add((AEKey)variant, this.clampedLong(count, stackLimit));
                    this.highestCompressed = variant;
                    break;
                }
            } else {
                out.add((AEKey)this.storedItem, this.clampedLong(this.unitCount.divide(BigInteger.valueOf(this.unitFactor)), stackLimit));
            }
        }
    }

    public boolean isPreferredStorageFor(AEKey what, IActionSource source) {
        AEItemKey item;
        return what instanceof AEItemKey && (this.partitionList.isListed((AEKey)(item = (AEItemKey)what)) || this.compressed.containsKey((Object)item) || this.decompressed.containsKey((Object)item));
    }

    public Component getDescription() {
        return this.i.m_41786_();
    }
}

