/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.fields.plantation;

import com.minecolonies.api.colony.fields.modules.IFieldModule;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.util.constant.ToolType;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IPlantationModule
extends IFieldModule {
    public String getFieldTag();

    public String getWorkTag();

    public Item getItem();

    public int getPlantsToRequest();

    public ResourceLocation getRequiredResearchEffect();

    public PlantationModuleResult.Builder decideFieldWork(Level var1, @NotNull BlockPos var2);

    @Nullable
    public BlockPos getNextWorkingPosition(Level var1);

    public List<BlockPos> getValidWorkingPositions(@NotNull Level var1, List<BlockPos> var2);

    public int getActionLimit();

    public List<Item> getValidBonemeal();

    public BlockPos getPositionToWalkTo(Level var1, BlockPos var2);

    public BlockState getPlantingBlockState(Level var1, BlockPos var2, BlockState var3);

    public void applyBonemeal(AbstractEntityCitizen var1, BlockPos var2, ItemStack var3, Player var4);

    public List<ItemStack> getRequiredItemsForOperation();

    public ToolType getRequiredTool();

    public int hashCode();

    public boolean equals(Object var1);

    public static class PlantationModuleResult {
        public static final Builder NONE = new Builder().pickNewField();
        private final IPlantationModule module;
        private final BlockPos workingPosition;
        private final ActionToPerform action;
        @Nullable
        private final BlockPos actionPosition;
        private final PlanterAIModuleResultResetState resetState;

        private PlantationModuleResult(IPlantationModule module, BlockPos workingPosition, ActionToPerform action, @Nullable BlockPos actionPosition, PlanterAIModuleResultResetState resetState) {
            this.module = module;
            this.workingPosition = workingPosition;
            this.action = action;
            this.actionPosition = actionPosition;
            this.resetState = resetState;
        }

        public IPlantationModule getModule() {
            return this.module;
        }

        public BlockPos getWorkingPosition() {
            return this.workingPosition;
        }

        public ActionToPerform getAction() {
            return this.action;
        }

        @Nullable
        public BlockPos getActionPosition() {
            return this.actionPosition;
        }

        public boolean shouldResetWorkingPosition() {
            return this.resetState == PlanterAIModuleResultResetState.POSITION || this.resetState == PlanterAIModuleResultResetState.FIELD;
        }

        public boolean shouldResetCurrentField() {
            return this.resetState == PlanterAIModuleResultResetState.FIELD;
        }

        public static class Builder {
            private ActionToPerform action = ActionToPerform.NONE;
            @Nullable
            private BlockPos actionPosition;
            private PlanterAIModuleResultResetState resetState = PlanterAIModuleResultResetState.NONE;

            public Builder pickNewField() {
                this.resetState = PlanterAIModuleResultResetState.FIELD;
                return this;
            }

            public Builder pickNewPosition() {
                this.resetState = PlanterAIModuleResultResetState.POSITION;
                return this;
            }

            public Builder plant(BlockPos position) {
                this.action = ActionToPerform.PLANT;
                this.actionPosition = position;
                return this;
            }

            public Builder bonemeal(BlockPos position) {
                this.action = ActionToPerform.BONEMEAL;
                this.actionPosition = position;
                return this;
            }

            public Builder harvest(BlockPos position) {
                this.action = ActionToPerform.HARVEST;
                this.actionPosition = position;
                return this;
            }

            public Builder clear(BlockPos position) {
                this.action = ActionToPerform.CLEAR;
                this.actionPosition = position;
                return this;
            }

            public PlantationModuleResult build(IPlantationModule module, BlockPos workingPosition) {
                return new PlantationModuleResult(module, workingPosition, this.action, this.actionPosition, this.resetState);
            }
        }
    }

    public static enum ActionToPerform {
        NONE(false),
        PLANT(true),
        BONEMEAL(true),
        HARVEST(true),
        CLEAR(false);

        private final boolean increasesActionCount;

        private ActionToPerform(boolean increasesActionCount) {
            this.increasesActionCount = increasesActionCount;
        }

        public boolean increasesActionCount() {
            return this.increasesActionCount;
        }
    }

    public static enum PlanterAIModuleResultResetState {
        NONE,
        POSITION,
        FIELD;

    }
}

