/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.permissions;

import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.util.Utils;
import java.util.Objects;

public class Rank {
    private boolean isSubscriber;
    private String name;
    private int id;
    private boolean isInitial;
    private boolean isColonyManager;
    private boolean isHostile;
    private long permissionData = 0L;

    public Rank(int id, long permissionData, String name, boolean isSubscriber, boolean isInitial, boolean isColonyManager, boolean isHostile) {
        this.id = id;
        this.permissionData = permissionData;
        this.name = name;
        this.isSubscriber = isSubscriber;
        this.isInitial = isInitial;
        this.isColonyManager = isColonyManager;
        this.isHostile = isHostile;
    }

    public Rank(int id, String name, boolean isSubscriber, boolean isInitial) {
        this(id, 0L, name, isSubscriber, isInitial, false, false);
    }

    public int getId() {
        return this.id;
    }

    public boolean isSubscriber() {
        return this.isSubscriber;
    }

    public String getName() {
        return this.name;
    }

    public boolean isInitial() {
        return this.isInitial;
    }

    public boolean isColonyManager() {
        return this.isColonyManager;
    }

    public boolean isHostile() {
        return this.isHostile;
    }

    public void setColonyManager(boolean isColonyManager) {
        this.isColonyManager = isColonyManager;
    }

    public void setHostile(boolean isHostile) {
        this.isHostile = isHostile;
    }

    public void setSubscriber(boolean isSubscriber) {
        this.isSubscriber = isSubscriber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Rank rank = (Rank)o;
        return this.id == rank.id && this.name.equals(rank.name);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.id);
    }

    public int compareTo(Rank rank) {
        return this.getId() - rank.getId();
    }

    public boolean addPermission(Action action) {
        if (!Utils.testFlag(this.permissionData, action.getFlag())) {
            this.permissionData = Utils.setFlag(this.permissionData, action.getFlag());
            return true;
        }
        return false;
    }

    public boolean removePermission(Action action) {
        if (Utils.testFlag(this.permissionData, action.getFlag())) {
            this.permissionData = Utils.unsetFlag(this.permissionData, action.getFlag());
            return true;
        }
        return false;
    }

    public long getPermissions() {
        return this.permissionData;
    }
}

