/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.minecolonies.api.crafting.CountedIngredient;
import com.minecolonies.api.crafting.registry.ModRecipeSerializer;
import com.minecolonies.api.items.ModItems;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompostRecipe
implements Recipe<Container> {
    private static final int FERMENT_TIME = 24000;
    private static final int COMPOST_RESULT = 6;
    private final ResourceLocation id;
    private final Ingredient input;
    private final ItemStack output;
    private final int strength;

    public CompostRecipe(@NotNull ResourceLocation id, @NotNull Ingredient ingredient, int strength) {
        this.id = id;
        this.input = ingredient;
        this.strength = strength;
        this.output = new ItemStack((ItemLike)ModItems.compost, 6);
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipeSerializer.CompostRecipeType.get();
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    public Ingredient getInput() {
        return this.input;
    }

    public int getStrength() {
        return this.strength;
    }

    public int getFermentTime() {
        return 24000;
    }

    public boolean m_5818_(Container inv, Level worldIn) {
        return false;
    }

    @NotNull
    public ItemStack m_5874_(Container inv) {
        return this.output.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    @NotNull
    public ItemStack m_8043_() {
        return this.output;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeSerializer.CompostRecipeSerializer.get();
    }

    @NotNull
    public NonNullList<Ingredient> m_7527_() {
        NonNullList ingredients = NonNullList.m_122779_();
        ingredients.add((Object)new CountedIngredient(this.input, this.calculateIngredientCount()));
        return ingredients;
    }

    private int calculateIngredientCount() {
        return 64 / this.strength;
    }

    @NotNull
    public static CompostRecipe individualize(@NotNull Item item, @NotNull CompostRecipe recipe) {
        return new CompostRecipe(recipe.m_6423_(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}), recipe.getStrength());
    }

    public static class Serializer
    implements RecipeSerializer<CompostRecipe> {
        @NotNull
        public CompostRecipe fromJson(@NotNull ResourceLocation recipeId, @NotNull JsonObject json) {
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)json.get("input"));
            int strength = GsonHelper.m_13824_((JsonObject)json, (String)"strength", (int)1);
            return new CompostRecipe(recipeId, ingredient, strength);
        }

        @Nullable
        public CompostRecipe fromNetwork(@NotNull ResourceLocation recipeId, @NotNull FriendlyByteBuf buffer) {
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            int strength = buffer.m_130242_();
            return new CompostRecipe(recipeId, ingredient, strength);
        }

        public void toNetwork(@NotNull FriendlyByteBuf buffer, @NotNull CompostRecipe recipe) {
            recipe.getInput().m_43923_(buffer);
            buffer.m_130130_(recipe.getStrength());
        }
    }
}

